/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.catalog;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilterListener;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCSchemaLoader;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SybaseASACatalogSchema;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.impl.CatalogImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASACatalog
extends CatalogImpl
implements ICatalogObject {
    private static final long serialVersionUID = 3372967146783478978L;
    protected Boolean schemaLoaded = Boolean.FALSE;
    private SoftReference schemaLoaderRef;
    private transient ConnectionFilterListener filterListener;

    public Database getCatalogDatabase() {
        return this.getDatabase();
    }

    public Connection getConnection() {
        return ((ICatalogObject)this.getCatalogDatabase()).getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.schemaLoaded;
        synchronized (bl) {
            if (this.schemaLoaded.booleanValue()) {
                this.schemaLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        return super.eIsSet(eFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getSchemas() {
        Boolean bl = this.schemaLoaded;
        synchronized (bl) {
            if (!this.schemaLoaded.booleanValue()) {
                this.loadSchemas(super.getSchemas());
                this.schemaLoaded = Boolean.TRUE;
                if (this.filterListener == null) {
                    ConnectionInfo connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(this.getCatalogDatabase());
                    this.filterListener = new FilterListener();
                    connectionInfo.addFilterListener(this.filterListener);
                }
            }
        }
        return super.getSchemas();
    }

    public void loadSchemas(EList schemaConstainmentList) {
        try {
            boolean deliver = this.database.eDeliver();
            this.database.eSetDeliver(false);
            ArrayList existingSchemas = new ArrayList(schemaConstainmentList.size());
            existingSchemas.addAll(schemaConstainmentList);
            this.getSchemaLoader().clearSchemas((List)schemaConstainmentList);
            this.getSchemaLoader().loadSchemas((List)schemaConstainmentList, existingSchemas);
            this.database.eSetDeliver(deliver);
        }
        catch (Exception e) {
            JDBCASAPlugin.getDefault().log(e);
        }
    }

    private JDBCSchemaLoader getSchemaLoader() {
        if (this.schemaLoaderRef == null || this.schemaLoaderRef.get() == null) {
            this.schemaLoaderRef = new SoftReference<JDBCSchemaLoader>(this.createSchemaLoader());
        }
        return (JDBCSchemaLoader)this.schemaLoaderRef.get();
    }

    protected JDBCSchemaLoader createSchemaLoader() {
        return new ASASchemaLoader(this);
    }

    private void handleFilterChanged(String filterKey) {
        boolean refresh = false;
        ConnectionInfo conInf = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(this.getDatabase());
        if (this.schemaLoaded.booleanValue() && (filterKey.equals(this.getSchemaFilterKey()) || conInf != null && "DatatoolsSchemaFilterPredicate".equals(filterKey) && conInf.getFilter(this.getSchemaFilterKey()) == null)) {
            this.schemaLoaded = Boolean.FALSE;
            refresh = true;
        }
        if (refresh) {
            RefreshManager.getInstance().referesh((ICatalogObject)this);
        }
    }

    private String getSchemaFilterKey() {
        return String.valueOf(this.getName()) + "::" + "DatatoolsSchemaFilterPredicate";
    }

    public class ASASchemaLoader
    extends JDBCSchemaLoader {
        public ASASchemaLoader(ICatalogObject catalogObject) {
            super(catalogObject);
        }

        protected Schema createSchema() {
            return new SybaseASACatalogSchema();
        }
    }

    public class FilterListener
    implements ConnectionFilterListener {
        public void connectionFilterAdded(String filterKey) {
            SybaseASACatalog.this.handleFilterChanged(filterKey);
        }

        public void connectionFilterRemoved(String filterKey) {
            SybaseASACatalog.this.handleFilterChanged(filterKey);
        }
    }
}

