/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jdtutility;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jpt.core.internal.jdtutility.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.JDTTools;
import org.eclipse.jpt.core.internal.jdtutility.ModifiedDeclaration;
import org.eclipse.jpt.core.internal.jdtutility.NameStringExpressionConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumDeclarationAnnotationElementAdapter
implements DeclarationAnnotationElementAdapter<String> {
    private final ConversionDeclarationAnnotationElementAdapter<String, Name> adapter;

    public EnumDeclarationAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter) {
        this(annotationAdapter, "value");
    }

    public EnumDeclarationAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        this(annotationAdapter, elementName, true);
    }

    public EnumDeclarationAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, boolean removeAnnotationWhenEmpty) {
        this(new ConversionDeclarationAnnotationElementAdapter<String, Name>(annotationAdapter, elementName, removeAnnotationWhenEmpty, NameStringExpressionConverter.instance()));
    }

    protected EnumDeclarationAnnotationElementAdapter(ConversionDeclarationAnnotationElementAdapter<String, Name> adapter) {
        this.adapter = adapter;
    }

    @Override
    public String getValue(ModifiedDeclaration declaration) {
        return this.resolve(this.adapter.expression(declaration), declaration);
    }

    @Override
    public void setValue(String value, ModifiedDeclaration declaration) {
        this.adapter.setValue(this.convertToShortName(value, declaration), declaration);
    }

    @Override
    public Expression expression(ModifiedDeclaration declaration) {
        return this.adapter.expression(declaration);
    }

    @Override
    public ASTNode astNode(ModifiedDeclaration declaration) {
        return this.adapter.astNode(declaration);
    }

    protected String resolve(Expression enumExpression, ModifiedDeclaration declaration) {
        return enumExpression == null ? null : JDTTools.resolveEnum(declaration.iCompilationUnit(), enumExpression);
    }

    protected String convertToShortName(String string, ModifiedDeclaration declaration) {
        if (string == null) {
            return null;
        }
        declaration.addStaticImport(string);
        return this.shortName(string);
    }

    protected String shortTypeName(String name) {
        return name.substring(0, name.lastIndexOf(46));
    }

    protected String shortName(String name) {
        return name.substring(name.lastIndexOf(46) + 1);
    }
}

