/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Iterator;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.ISecondaryTable;
import org.eclipse.jpt.core.internal.mappings.ITable;
import org.eclipse.jpt.ui.internal.details.BaseJpaComposite;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.PrimaryKeyJoinColumnsInSecondaryTableComposite;
import org.eclipse.jpt.ui.internal.mappings.details.SecondaryTableDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class SecondaryTablesComposite
extends BaseJpaComposite {
    private IEntity entity;
    private final Adapter entityListener = this.buildEntityListener();
    private final Adapter secondaryTableListener = this.buildSecondaryTableListener();
    ListViewer secondaryTablesListViewer;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private PrimaryKeyJoinColumnsInSecondaryTableComposite pkJoinColumnsComposite;

    public SecondaryTablesComposite(Composite parent, CommandStack commandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, 0, commandStack, widgetFactory);
    }

    private Adapter buildEntityListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                SecondaryTablesComposite.this.entityChanged(notification);
            }
        };
    }

    private Adapter buildSecondaryTableListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                SecondaryTablesComposite.this.seoncaryTableChanged(notification);
            }
        };
    }

    protected void initializeLayout(Composite composite) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        Composite secondaryTablesComposite = new Composite(composite, 0);
        layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        secondaryTablesComposite.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        secondaryTablesComposite.setLayoutData((Object)gridData);
        this.secondaryTablesListViewer = this.buildSecondaryTablesListViewer(secondaryTablesComposite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.secondaryTablesListViewer.getList().setLayoutData((Object)gridData);
        Composite buttonsComposite = new Composite(secondaryTablesComposite, 0);
        layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        buttonsComposite.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 0x1000008;
        buttonsComposite.setLayoutData((Object)gridData);
        this.addButton = new Button(buttonsComposite, 0);
        this.addButton.setText(JptUiMappingsMessages.SecondaryTablesComposite_add);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.addButton.setLayoutData((Object)gridData);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SecondaryTablesComposite.this.addSecondaryTable();
            }
        });
        this.editButton = new Button(buttonsComposite, 0);
        this.editButton.setText(JptUiMappingsMessages.SecondaryTablesComposite_edit);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.editButton.setLayoutData((Object)gridData);
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SecondaryTablesComposite.this.editSecondaryTable();
            }
        });
        this.removeButton = new Button(buttonsComposite, 0);
        this.removeButton.setText(JptUiMappingsMessages.SecondaryTablesComposite_remove);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        this.removeButton.setLayoutData((Object)gridData);
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SecondaryTablesComposite.this.removeSecondaryTable();
            }
        });
        this.pkJoinColumnsComposite = new PrimaryKeyJoinColumnsInSecondaryTableComposite(composite, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.pkJoinColumnsComposite.getControl().setLayoutData((Object)gridData);
    }

    private ListViewer buildSecondaryTablesListViewer(Composite parent) {
        ListViewer listViewer = new ListViewer(parent, 2052);
        listViewer.setLabelProvider((IBaseLabelProvider)this.buildSecondaryTablesListLabelProvider());
        listViewer.setContentProvider(this.buildSecondaryTablesListContentProvider());
        listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SecondaryTablesComposite.this.updateEnablement();
                SecondaryTablesComposite.this.secondaryTablesListSelectionChanged(event);
            }
        });
        return listViewer;
    }

    protected void secondaryTablesListSelectionChanged(SelectionChangedEvent event) {
        if (((StructuredSelection)event.getSelection()).isEmpty()) {
            this.pkJoinColumnsComposite.populate(null);
            this.pkJoinColumnsComposite.enableWidgets(false);
        } else {
            ISecondaryTable selectedSecondaryTable = this.getSelectedSecondaryTable();
            this.pkJoinColumnsComposite.populate((EObject)selectedSecondaryTable);
            this.pkJoinColumnsComposite.enableWidgets(true);
        }
    }

    private IContentProvider buildSecondaryTablesListContentProvider() {
        return new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((IEntity)inputElement).getSecondaryTables().toArray();
            }
        };
    }

    private ILabelProvider buildSecondaryTablesListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                ISecondaryTable secondaryTable = (ISecondaryTable)element;
                return secondaryTable.getName();
            }
        };
    }

    void addSecondaryTable() {
        SecondaryTableDialog dialog = new SecondaryTableDialog(this.getControl().getShell(), this.entity);
        this.addSecondaryTableFromDialog(dialog);
    }

    private void addSecondaryTableFromDialog(SecondaryTableDialog dialog) {
        if (dialog.open() == 0) {
            int index = this.entity.getSpecifiedSecondaryTables().size();
            String name = dialog.getSelectedName();
            String catalog = dialog.getSelectedCatalog();
            String schema = dialog.getSelectedSchema();
            ISecondaryTable secondaryTable = this.entity.createSecondaryTable(index);
            this.entity.getSpecifiedSecondaryTables().add((Object)secondaryTable);
            secondaryTable.setSpecifiedName(name);
            secondaryTable.setSpecifiedCatalog(catalog);
            secondaryTable.setSpecifiedSchema(schema);
            this.secondaryTablesListViewer.setSelection((ISelection)new StructuredSelection((Object)secondaryTable));
        }
    }

    void editSecondaryTable() {
        ISecondaryTable secondaryTable = this.getSelectedSecondaryTable();
        SecondaryTableDialog dialog = new SecondaryTableDialog(this.getControl().getShell(), secondaryTable, this.entity);
        this.editSecondaryTableFromDialog(dialog, secondaryTable);
    }

    private void editSecondaryTableFromDialog(SecondaryTableDialog dialog, ISecondaryTable secondaryTable) {
        if (dialog.open() == 0) {
            this.editSecondaryTableDialogOkd(dialog, secondaryTable);
        }
    }

    private void editSecondaryTableDialogOkd(SecondaryTableDialog dialog, ISecondaryTable secondaryTable) {
        String name = dialog.getSelectedName();
        String catalog = dialog.getSelectedCatalog();
        String schema = dialog.getSelectedSchema();
        if (secondaryTable.getSpecifiedName() == null || !secondaryTable.getSpecifiedName().equals(name)) {
            secondaryTable.setSpecifiedName(name);
        }
        if (dialog.isDefaultCatalogSelected()) {
            if (secondaryTable.getSpecifiedCatalog() != null) {
                secondaryTable.setSpecifiedCatalog(null);
            }
        } else if (secondaryTable.getSpecifiedCatalog() == null || !secondaryTable.getSpecifiedCatalog().equals(catalog)) {
            secondaryTable.setSpecifiedCatalog(catalog);
        }
        if (dialog.isDefaultSchemaSelected()) {
            if (secondaryTable.getSpecifiedSchema() != null) {
                secondaryTable.setSpecifiedSchema(null);
            }
        } else if (secondaryTable.getSpecifiedSchema() == null || !secondaryTable.getSpecifiedSchema().equals(schema)) {
            secondaryTable.setSpecifiedSchema(schema);
        }
    }

    private ISecondaryTable getSelectedSecondaryTable() {
        return (ISecondaryTable)((StructuredSelection)this.secondaryTablesListViewer.getSelection()).getFirstElement();
    }

    void removeSecondaryTable() {
        ISelection selection = this.secondaryTablesListViewer.getSelection();
        if (selection instanceof StructuredSelection) {
            Iterator i = ((StructuredSelection)selection).iterator();
            while (i.hasNext()) {
                this.entity.getSpecifiedSecondaryTables().remove(i.next());
            }
        }
    }

    void updateEnablement() {
        this.editButton.setEnabled(!((StructuredSelection)this.secondaryTablesListViewer.getSelection()).isEmpty());
        this.removeButton.setEnabled(!((StructuredSelection)this.secondaryTablesListViewer.getSelection()).isEmpty());
    }

    public void doPopulate(EObject obj) {
        this.entity = (IEntity)obj;
        if (this.entity == null) {
            this.secondaryTablesListViewer.setInput(null);
            return;
        }
        this.secondaryTablesListViewer.setInput((Object)this.entity);
        if (!this.entity.getSecondaryTables().isEmpty()) {
            this.secondaryTablesListViewer.setSelection((ISelection)new StructuredSelection(this.entity.getSecondaryTables().get(0)));
        } else {
            this.secondaryTablesListViewer.setSelection(null);
        }
        this.updateEnablement();
    }

    protected void doPopulate() {
    }

    protected void engageListeners() {
        if (this.entity != null) {
            this.entity.eAdapters().add((Object)this.entityListener);
            for (ISecondaryTable secondaryTable : this.entity.getSecondaryTables()) {
                secondaryTable.eAdapters().add((Object)this.secondaryTableListener);
            }
        }
    }

    protected void disengageListeners() {
        if (this.entity != null) {
            for (ISecondaryTable secondaryTable : this.entity.getSecondaryTables()) {
                secondaryTable.eAdapters().remove((Object)this.secondaryTableListener);
            }
            this.entity.eAdapters().remove((Object)this.entityListener);
        }
    }

    protected void entityChanged(Notification notification) {
        if (notification.getFeatureID(IEntity.class) == 5) {
            if (notification.getEventType() == 3) {
                ((ISecondaryTable)notification.getNewValue()).eAdapters().add((Object)this.secondaryTableListener);
            } else if (notification.getEventType() == 4) {
                ((ISecondaryTable)notification.getOldValue()).eAdapters().remove((Object)this.secondaryTableListener);
            }
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (SecondaryTablesComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    SecondaryTablesComposite.this.secondaryTablesListViewer.refresh();
                    SecondaryTablesComposite.this.updateEnablement();
                }
            });
        }
    }

    protected void seoncaryTableChanged(Notification notification) {
        if (notification.getFeatureID(ITable.class) == 1 || notification.getFeatureID(ITable.class) == 4 || notification.getFeatureID(ITable.class) == 7 || notification.getFeatureID(ITable.class) == 5 || notification.getFeatureID(ITable.class) == 8) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (SecondaryTablesComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    SecondaryTablesComposite.this.secondaryTablesListViewer.refresh();
                }
            });
        }
    }
}

