/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.ui.common.sash;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jst.jsf.common.ui.internal.guiutils.SWTUtils;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.ui.common.sash.SashEditorSelectionProvider;
import org.eclipse.jst.pagedesigner.ui.common.sash.SashEditorSite;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.INestableKeyBindingService;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.part.MultiPageEditorSite;

public abstract class SashEditorPart
extends EditorPart {
    private int _orientation = 512;
    private SashForm _sashForm;
    private ArrayList _nestedEditors = new ArrayList(3);
    private Map _editorToComposite = new HashMap();
    private IEditorPart _activeEditor = null;

    public void addPage(final IEditorPart editor, IEditorInput input) throws PartInitException {
        IEditorSite site = this.createSite(editor);
        editor.init(site, input);
        final Composite parent1 = new Composite(this.getContainer(), 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 1;
        fillLayout.marginWidth = 1;
        parent1.setLayout((Layout)fillLayout);
        parent1.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 26) {
                    SashEditorPart.this.activeEditorChanged(editor);
                    parent1.setBackground(ColorConstants.green);
                }
            }
        });
        parent1.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                parent1.setBackground(ColorConstants.titleInactiveBackground);
            }
        });
        SWTUtils.workaroundResize((Composite)parent1);
        editor.createPartControl(parent1);
        editor.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propertyId) {
                SashEditorPart.this.handlePropertyChange(propertyId);
            }
        });
        this._nestedEditors.add(editor);
        this._editorToComposite.put(editor, parent1);
        this.connectPage(editor);
    }

    protected void connectPage(IEditorPart editor) {
        ISelectionProvider editSelectionProvider = editor.getSite().getSelectionProvider();
        if (editSelectionProvider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)editSelectionProvider).addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ((SashEditorSelectionProvider)SashEditorPart.this.getSite().getSelectionProvider()).firePostSelectionChanged(event);
                }
            });
        } else {
            editSelectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ((SashEditorSelectionProvider)SashEditorPart.this.getSite().getSelectionProvider()).fireSelectionChanged(event);
                }
            });
        }
    }

    private SashForm createContainer(Composite parent) {
        SashForm newContainer = new SashForm(parent, 0);
        SWTUtils.workaroundResize((Composite)newContainer);
        newContainer.setOrientation(this._orientation);
        return newContainer;
    }

    protected abstract void createPages() throws PartInitException;

    public final void createPartControl(Composite parent) {
        this._sashForm = this.createContainer(parent);
        try {
            this.createPages();
        }
        catch (PartInitException ex) {
            ex.printStackTrace();
        }
        if (this.getActiveEditor() == null && !this._nestedEditors.isEmpty()) {
            this.setActiveEditor((IEditorPart)this._nestedEditors.get(0));
        }
    }

    protected IEditorSite createSite(IEditorPart editor) {
        return new SashEditorSite(this, editor);
    }

    public void dispose() {
        this._activeEditor = null;
        int i = 0;
        while (i < this._nestedEditors.size()) {
            IEditorPart editor = (IEditorPart)this._nestedEditors.get(i);
            this.disposePart((IWorkbenchPart)editor);
            ++i;
        }
        this._nestedEditors.clear();
        this._editorToComposite.clear();
    }

    public IEditorPart getActiveEditor() {
        return this._activeEditor;
    }

    protected Composite getContainer() {
        return this._sashForm;
    }

    protected IEditorPart getEditor(int pageIndex) {
        return (IEditorPart)this._nestedEditors.get(pageIndex);
    }

    protected void handlePropertyChange(int propertyId) {
        this.firePropertyChange(propertyId);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        site.setSelectionProvider((ISelectionProvider)new SashEditorSelectionProvider(this));
    }

    public boolean isDirty() {
        for (IEditorPart editor : this._nestedEditors) {
            if (!editor.isDirty()) continue;
            return true;
        }
        return false;
    }

    protected void activeEditorChanged(IEditorPart activeEditor) {
        ISelectionProvider selectionProvider;
        this.setActiveEditor(activeEditor);
        this.setFocus();
        Object site = this.getEditorSite();
        while (site != null) {
            IEditorActionBarContributor contributor = site.getActionBarContributor();
            if (contributor != null && contributor instanceof MultiPageEditorActionBarContributor) {
                ((MultiPageEditorActionBarContributor)contributor).setActivePage(activeEditor);
            }
            site = site instanceof MultiPageEditorSite ? (IEditorSite)((MultiPageEditorSite)site).getMultiPageEditor().getSite() : (site instanceof SashEditorSite ? (IEditorSite)((SashEditorSite)site).getSashEditor().getSite() : null);
        }
        if (activeEditor != null && (selectionProvider = activeEditor.getSite().getSelectionProvider()) != null) {
            SelectionChangedEvent event = new SelectionChangedEvent(selectionProvider, selectionProvider.getSelection());
            ((SashEditorSelectionProvider)this.getSite().getSelectionProvider()).fireSelectionChanged(event);
        }
    }

    private void disposePart(final IWorkbenchPart part) {
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                if (part.getSite() instanceof SashEditorSite) {
                    SashEditorSite partSite = (SashEditorSite)part.getSite();
                    partSite.dispose();
                }
                part.dispose();
            }

            public void handleException(Throwable e) {
            }
        });
    }

    protected void setActiveEditor(IEditorPart part) {
        this._activeEditor = part;
    }

    public void setFocus() {
        this.setFocus(this.getActiveEditor());
    }

    private void setFocus(IEditorPart editor) {
        IKeyBindingService service = this.getSite().getKeyBindingService();
        if (editor == null) {
            if (service instanceof INestableKeyBindingService) {
                INestableKeyBindingService nestableService = (INestableKeyBindingService)service;
                nestableService.activateKeyBindingService(null);
            } else {
                PDPlugin.getLogger(((Object)((Object)this)).getClass()).error("MultiPageEditorPart.setFocus()   Parent key binding service was not an instance of INestableKeyBindingService.  It was an instance of " + service.getClass().getName() + " instead.");
            }
            return;
        }
        editor.setFocus();
        if (service instanceof INestableKeyBindingService) {
            INestableKeyBindingService nestableService = (INestableKeyBindingService)service;
            if (editor != null) {
                nestableService.activateKeyBindingService((IWorkbenchSite)editor.getEditorSite());
            } else {
                nestableService.activateKeyBindingService(null);
            }
        } else {
            PDPlugin.getLogger(((Object)((Object)this)).getClass()).error("MultiPageEditorPart.setFocus()   Parent key binding service was not an instance of INestableKeyBindingService.  It was an instance of " + service.getClass().getName() + " instead.");
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (this._activeEditor != null) {
            this._activeEditor.doSave(monitor);
        }
    }

    public void doSaveAs() {
        if (this._activeEditor != null) {
            this._activeEditor.doSaveAs();
        }
    }

    public boolean isSaveAsAllowed() {
        if (this._activeEditor != null) {
            return this._activeEditor.isSaveAsAllowed();
        }
        return false;
    }

    public void setOrientation(int orientation) {
        this._orientation = orientation;
        if (this._sashForm != null && !this._sashForm.isDisposed()) {
            this._sashForm.setMaximizedControl(null);
            this._sashForm.setOrientation(this._orientation);
        }
    }

    public void setMaximizedEditor(IEditorPart part) {
        if (part != null) {
            Composite c = (Composite)this._editorToComposite.get(part);
            if (c != null && this._sashForm != null && !this._sashForm.isDisposed()) {
                this._sashForm.setMaximizedControl((Control)c);
                part.setFocus();
            }
        } else if (this._sashForm != null && !this._sashForm.isDisposed()) {
            this._sashForm.setMaximizedControl(null);
        }
    }
}

