/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.utils;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.utils.BodyHelper;
import org.eclipse.wst.html.core.internal.format.HTMLFormatProcessorImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JSPUtil {
    public static String getOrCreatePrefix(IDOMModel model, String uri, String defaultPrefix) {
        return JSPUtil.getOrCreatePrefix(model, uri, defaultPrefix, null);
    }

    public static String getOrCreatePrefix(IDOMModel model, String uri, String defaultPrefix, Node[] nodes) {
        String prefix = JSPUtil.getPrefix(model, uri);
        if (prefix != null) {
            return prefix;
        }
        prefix = JSPUtil.findUnusedPrefix(model, defaultPrefix);
        if (!model.getDocument().isXMLType()) {
            Node[] ref = new Node[1];
            BodyHelper.findHeaderInsertPosition("jsp", "taglib", (Node)model.getDocument(), ref);
            Element ele = model.getDocument().createElement("jsp:directive.taglib");
            ((IDOMElement)ele).setJSPTag(true);
            ele.setAttribute("uri", uri);
            ele.setAttribute("prefix", prefix);
            if (nodes != null && nodes.length > 0) {
                nodes[0] = ele;
            }
            model.getDocument().insertBefore((Node)ele, ref[0]);
            new HTMLFormatProcessorImpl().formatNode((Node)ele);
        } else {
            boolean tldRefExists = false;
            Element root = JSPUtil.getRootElement(model);
            if (root != null) {
                NamedNodeMap attrs = root.getAttributes();
                int i = 0;
                while (i < attrs.getLength()) {
                    Attr a = (Attr)attrs.item(i);
                    if (a.getValue().equals(uri)) {
                        tldRefExists = true;
                        break;
                    }
                    ++i;
                }
                if (!tldRefExists) {
                    Attr a = model.getDocument().createAttribute("xmlns:" + prefix);
                    a.setValue(uri);
                    root.setAttributeNode(a);
                    new HTMLFormatProcessorImpl().formatNode((Node)root);
                    if (nodes != null && nodes.length > 0) {
                        nodes[0] = a;
                    }
                }
            }
        }
        return prefix;
    }

    private static Element getRootElement(IDOMModel model) {
        Document docNode = EditModelQuery.getDocumentNode((Node)model.getDocument());
        return docNode.getDocumentElement();
    }

    public static String getPrefix(IDOMModel model, String uri) {
        TLDCMDocumentManager m = TaglibController.getTLDCMDocumentManager((IDocument)model.getStructuredDocument());
        if (m == null) {
            return null;
        }
        List trackers = m.getTaglibTrackers();
        for (TaglibTracker tracker : trackers) {
            if (uri.equals(tracker.getURI())) {
                return tracker.getPrefix();
            }
            CMDocument cmdoc = tracker.getDocument();
            if (!(cmdoc instanceof TLDDocument) || !uri.equals(((TLDDocument)cmdoc).getUri())) continue;
            return tracker.getPrefix();
        }
        return null;
    }

    public static Element createTaglibDeclaration(IDOMModel model, String uri, String prefix) {
        Node[] ref = new Node[1];
        BodyHelper.findHeaderInsertPosition("jsp", "taglib", (Node)model.getDocument(), ref);
        Element ele = model.getDocument().createElement("jsp:directive.taglib");
        ((IDOMElement)ele).setJSPTag(true);
        ele.setAttribute("uri", uri);
        ele.setAttribute("prefix", prefix);
        model.getDocument().insertBefore((Node)ele, ref[0]);
        return ele;
    }

    public static String findUnusedPrefix(IDOMModel model, String suggestion) {
        TLDCMDocumentManager m;
        if (suggestion == null) {
            suggestion = "p";
        }
        if ((m = TaglibController.getTLDCMDocumentManager((IDocument)model.getStructuredDocument())) == null) {
            return suggestion;
        }
        List trackers = m.getTaglibTrackers();
        HashSet<String> map = new HashSet<String>();
        for (TaglibTracker tracker : trackers) {
            map.add(tracker.getPrefix());
        }
        if (!map.contains(suggestion)) {
            return suggestion;
        }
        int i = 1;
        while (map.contains(String.valueOf(suggestion) + i)) {
            ++i;
        }
        return String.valueOf(suggestion) + i;
    }

    public static String findURIForPrefix(IDOMModel model, String prefix) {
        if (prefix == null || model == null) {
            return null;
        }
        TLDCMDocumentManager m = TaglibController.getTLDCMDocumentManager((IDocument)model.getStructuredDocument());
        if (m == null) {
            return null;
        }
        List trackers = m.getTaglibTrackers();
        for (TaglibTracker tracker : trackers) {
            if (!prefix.equals(tracker.getPrefix())) continue;
            CMDocument cmdoc = tracker.getDocument();
            if (!(cmdoc instanceof TLDDocument)) break;
            return ((TLDDocument)cmdoc).getUri();
        }
        return null;
    }

    public static boolean supportTaglib(String uri, IFile baseFile) {
        IPath location = baseFile.getLocation();
        if (location != null) {
            return TaglibIndex.resolve((String)location.toString(), (String)uri, (boolean)false) != null;
        }
        return false;
    }
}

