/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.model.elements;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.model.elements.ElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.ui.IMemento;

public class ExpressionsViewMementoProvider
extends ElementMementoProvider {
    private static final String ELEMENT_NAME = "ELEMENT_NAME";
    private static final String EXP_MGR = "EXP_MGR";

    protected boolean encodeElement(Object element, IMemento memento, IPresentationContext context) throws CoreException {
        if (element instanceof IExpressionManager) {
            memento.putString(ELEMENT_NAME, EXP_MGR);
        } else if (element instanceof IExpression) {
            memento.putString(ELEMENT_NAME, ((IExpression)element).getExpressionText());
        } else if (element instanceof IVariable) {
            memento.putString(ELEMENT_NAME, ((IVariable)element).getName());
        } else {
            return false;
        }
        return true;
    }

    protected boolean isEqual(Object element, IMemento memento, IPresentationContext context) throws CoreException {
        String mementoName = memento.getString(ELEMENT_NAME);
        if (mementoName != null) {
            String elementName = null;
            if (element instanceof IExpressionManager) {
                elementName = EXP_MGR;
            } else if (element instanceof IVariable) {
                elementName = ((IVariable)element).getName();
            } else if (element instanceof IExpression) {
                elementName = ((IExpression)element).getExpressionText();
            }
            if (elementName != null) {
                return elementName.equals(mementoName);
            }
        }
        return false;
    }
}

