/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables.details;

import com.ibm.icu.text.MessageFormat;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.LazyModelPresentation;
import org.eclipse.debug.internal.ui.VariablesViewModelPresentation;
import org.eclipse.debug.internal.ui.actions.variables.details.DetailPaneAssignValueAction;
import org.eclipse.debug.internal.ui.actions.variables.details.DetailPaneMaxLengthAction;
import org.eclipse.debug.internal.ui.actions.variables.details.DetailPaneWordWrapAction;
import org.eclipse.debug.internal.ui.views.variables.IndexedValuePartition;
import org.eclipse.debug.internal.ui.views.variables.StatusLineContributionItem;
import org.eclipse.debug.internal.ui.views.variables.details.AbstractDetailPane;
import org.eclipse.debug.internal.ui.views.variables.details.DetailMessages;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.console.actions.TextViewerAction;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.operations.OperationHistoryActionHandler;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class DefaultDetailPane
extends AbstractDetailPane
implements IAdaptable,
IPropertyChangeListener {
    protected static final String DETAIL_COPY_ACTION = String.valueOf(ActionFactory.COPY.getId()) + ".SourceDetailPane";
    protected static final String DETAIL_SELECT_ALL_ACTION = String.valueOf(IDebugView.SELECT_ALL_ACTION) + ".SourceDetailPane";
    protected static final String DETAIL_PASTE_ACTION = ActionFactory.PASTE.getId();
    protected static final String DETAIL_CUT_ACTION = ActionFactory.CUT.getId();
    protected static final String DETAIL_FIND_REPLACE_TEXT_ACTION = "FindReplaceText";
    protected static final String DETAIL_CONTENT_ASSIST_ACTION = "ContentAssist";
    protected static final String DETAIL_ASSIGN_VALUE_ACTION = "AssignValue";
    protected static final String DETAIL_WORD_WRAP_ACTION = "org.eclipse.debug.ui.detail_pane_word_wrap";
    protected static final String DETAIL_MAX_LENGTH_ACTION = "MaxLength";
    public static final String ID = DetailMessages.DefaultDetailPane_0;
    public static final String NAME = DetailMessages.DefaultDetailPane_1;
    public static final String DESCRIPTION = DetailMessages.DefaultDetailPane_57;
    private VariablesViewModelPresentation fModelPresentation;
    private String fDebugModelIdentifier;
    private StatusLineContributionItem fStatusLineItem;
    private SourceViewer fSourceViewer;
    private IStructuredSelection fLastDisplayed = null;
    private IDocument fDetailDocument;
    private DetailJob fDetailJob = null;
    private final String fPositionLabelPattern = DetailMessages.DefaultDetailPane_56;
    private final PositionLabelValue fLineLabel = new PositionLabelValue();
    private final PositionLabelValue fColumnLabel = new PositionLabelValue();
    private final Object[] fPositionLabelPatternArguments = new Object[]{this.fLineLabel, this.fColumnLabel};
    private ICursorListener fCursorListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public Control createControl(Composite parent) {
        this.fModelPresentation = new VariablesViewModelPresentation();
        this.createSourceViewer(parent);
        if (this.isInView()) {
            this.createViewSpecificComponents();
            this.createActions();
            DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
            JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        }
        return this.fSourceViewer.getControl();
    }

    private void createSourceViewer(Composite parent) {
        this.fSourceViewer = new SourceViewer(parent, null, 768);
        this.fSourceViewer.setDocument(this.getDetailDocument());
        this.fSourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.DetailPaneFont"));
        this.fSourceViewer.getTextWidget().setWordWrap(DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(DETAIL_WORD_WRAP_ACTION));
        this.fSourceViewer.setEditable(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fSourceViewer.getTextWidget(), "org.eclipse.debug.ui.detail_pane_context");
        Control control = this.fSourceViewer.getControl();
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
    }

    private void createViewSpecificComponents() {
        this.getDetailDocument().addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                DefaultDetailPane.this.updateSelectionDependentActions();
            }
        });
        this.fSourceViewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DefaultDetailPane.this.updateSelectionDependentActions();
            }
        });
        this.fSourceViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DefaultDetailPane.this.getViewSite().setSelectionProvider(DefaultDetailPane.this.fSourceViewer.getSelectionProvider());
                DefaultDetailPane.this.setGlobalAction(IDebugView.SELECT_ALL_ACTION, DefaultDetailPane.this.getAction(DETAIL_SELECT_ALL_ACTION));
                DefaultDetailPane.this.setGlobalAction(IDebugView.CUT_ACTION, DefaultDetailPane.this.getAction(DETAIL_CUT_ACTION));
                DefaultDetailPane.this.setGlobalAction(IDebugView.COPY_ACTION, DefaultDetailPane.this.getAction(DETAIL_COPY_ACTION));
                DefaultDetailPane.this.setGlobalAction(IDebugView.PASTE_ACTION, DefaultDetailPane.this.getAction(DETAIL_PASTE_ACTION));
                DefaultDetailPane.this.setGlobalAction(IDebugView.FIND_ACTION, DefaultDetailPane.this.getAction(DefaultDetailPane.DETAIL_FIND_REPLACE_TEXT_ACTION));
                IAction action = DefaultDetailPane.this.getAction(DefaultDetailPane.DETAIL_ASSIGN_VALUE_ACTION);
                DefaultDetailPane.this.setGlobalAction(action.getActionDefinitionId(), action);
                action = DefaultDetailPane.this.getAction(DefaultDetailPane.DETAIL_CONTENT_ASSIST_ACTION);
                DefaultDetailPane.this.setGlobalAction(action.getActionDefinitionId(), action);
                DefaultDetailPane.this.getViewSite().getActionBars().updateActionBars();
                DefaultDetailPane.this.updateAction(DefaultDetailPane.DETAIL_FIND_REPLACE_TEXT_ACTION);
            }

            public void focusLost(FocusEvent e) {
                DefaultDetailPane.this.getViewSite().setSelectionProvider(null);
                DefaultDetailPane.this.setGlobalAction(IDebugView.SELECT_ALL_ACTION, null);
                DefaultDetailPane.this.setGlobalAction(IDebugView.CUT_ACTION, null);
                DefaultDetailPane.this.setGlobalAction(IDebugView.COPY_ACTION, null);
                DefaultDetailPane.this.setGlobalAction(IDebugView.PASTE_ACTION, null);
                DefaultDetailPane.this.setGlobalAction(IDebugView.FIND_ACTION, null);
                DefaultDetailPane.this.setGlobalAction(DefaultDetailPane.this.getAction(DefaultDetailPane.DETAIL_ASSIGN_VALUE_ACTION).getActionDefinitionId(), null);
                DefaultDetailPane.this.setGlobalAction(DefaultDetailPane.this.getAction(DefaultDetailPane.DETAIL_CONTENT_ASSIST_ACTION).getActionDefinitionId(), null);
                DefaultDetailPane.this.getViewSite().getActionBars().updateActionBars();
            }
        });
        this.fStatusLineItem = new StatusLineContributionItem("ModeContributionItem");
        IStatusLineManager manager = this.getViewSite().getActionBars().getStatusLineManager();
        manager.add((IContributionItem)this.fStatusLineItem);
        this.fSourceViewer.getTextWidget().addMouseListener((MouseListener)this.getCursorListener());
        this.fSourceViewer.getTextWidget().addKeyListener((KeyListener)this.getCursorListener());
        this.createDetailContextMenu((Control)this.fSourceViewer.getTextWidget());
    }

    private void createActions() {
        TextViewerAction textAction = new TextViewerAction((ITextViewer)this.fSourceViewer, 13);
        textAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        textAction.configureAction(DetailMessages.DefaultDetailPane_Co_ntent_Assist_3, "", "");
        textAction.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_CONTENT_ASSIST"));
        textAction.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_CONTENT_ASSIST"));
        textAction.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_CONTENT_ASSIST"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)textAction, "org.eclipse.debug.ui.detail_pane_content_assist_action_context");
        this.setAction(DETAIL_CONTENT_ASSIST_ACTION, (IAction)textAction);
        ActionHandler actionHandler = new ActionHandler((IAction)textAction);
        IViewSite iViewSite = this.getViewSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IHandlerService handlerService = (IHandlerService)iViewSite.getService((Class)clazz);
        handlerService.activateHandler(textAction.getActionDefinitionId(), (IHandler)actionHandler);
        textAction = new TextViewerAction((ITextViewer)this.fSourceViewer, 7);
        textAction.configureAction(DetailMessages.DefaultDetailPane_Select__All_5, "", "");
        textAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)textAction, "org.eclipse.debug.ui.detail_pane_select_all_action_context");
        this.setAction(DETAIL_SELECT_ALL_ACTION, (IAction)textAction);
        textAction = new TextViewerAction((ITextViewer)this.fSourceViewer, 4);
        textAction.configureAction(DetailMessages.DefaultDetailPane__Copy_8, "", "");
        textAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)textAction, "org.eclipse.debug.ui.detail_pane_copy_action_context");
        this.setAction(DETAIL_COPY_ACTION, (IAction)textAction);
        textAction = new TextViewerAction((ITextViewer)this.fSourceViewer, 3);
        textAction.configureAction(DetailMessages.DefaultDetailPane_Cu_t_11, "", "");
        textAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)textAction, "org.eclipse.debug.ui.detail_pane_cut_action_context");
        this.setAction(DETAIL_CUT_ACTION, (IAction)textAction);
        textAction = new TextViewerAction((ITextViewer)this.fSourceViewer, 5);
        textAction.configureAction(DetailMessages.DefaultDetailPane__Paste_14, "", "");
        textAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)textAction, "org.eclipse.debug.ui.detail_pane_paste_action_context");
        this.setAction(ActionFactory.PASTE.getId(), (IAction)textAction);
        this.setSelectionDependantAction(DETAIL_COPY_ACTION);
        this.setSelectionDependantAction(DETAIL_CUT_ACTION);
        this.setSelectionDependantAction(DETAIL_PASTE_ACTION);
        ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.debug.internal.ui.views.variables.VariablesViewResourceBundleMessages");
        Object action = new FindReplaceAction(bundle, "find_replace_action_", this.getWorkbenchPartSite().getShell(), (IFindReplaceTarget)new FindReplaceTargetWrapper(this.fSourceViewer.getFindReplaceTarget()));
        action.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.eclipse.debug.ui.detail_pane_find_replace_action_context");
        this.setAction(DETAIL_FIND_REPLACE_TEXT_ACTION, (IAction)action);
        this.updateSelectionDependentActions();
        action = new DetailPaneWordWrapAction((ITextViewer)this.fSourceViewer);
        this.setAction(DETAIL_WORD_WRAP_ACTION, (IAction)action);
        action = new DetailPaneMaxLengthAction(this.fSourceViewer.getControl().getShell());
        this.setAction(DETAIL_MAX_LENGTH_ACTION, (IAction)action);
        action = new DetailPaneAssignValueAction((ITextViewer)this.fSourceViewer, this.getViewSite());
        this.setAction(DETAIL_ASSIGN_VALUE_ACTION, (IAction)action);
    }

    protected void createDetailContextMenu(Control menuControl) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                DefaultDetailPane.this.fillDetailContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(menuControl);
        menuControl.setMenu(menu);
        this.getViewSite().registerContextMenu("org.eclipse.debug.ui.VariableView.detail", menuMgr, this.fSourceViewer.getSelectionProvider());
    }

    protected void fillDetailContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("variableGroup"));
        if (this.isInView()) {
            menu.add(this.getAction(DETAIL_ASSIGN_VALUE_ACTION));
            menu.add(this.getAction(DETAIL_CONTENT_ASSIST_ACTION));
        }
        menu.add((IContributionItem)new Separator());
        menu.add(this.getAction(DETAIL_CUT_ACTION));
        menu.add(this.getAction(DETAIL_COPY_ACTION));
        menu.add(this.getAction(DETAIL_PASTE_ACTION));
        menu.add(this.getAction(DETAIL_SELECT_ALL_ACTION));
        menu.add((IContributionItem)new Separator("FIND"));
        if (this.isInView()) {
            menu.add(this.getAction(DETAIL_FIND_REPLACE_TEXT_ACTION));
        }
        menu.add((IContributionItem)new Separator());
        menu.add(this.getAction(DETAIL_WORD_WRAP_ACTION));
        menu.add(this.getAction(DETAIL_MAX_LENGTH_ACTION));
        menu.add((IContributionItem)new Separator("additions"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(IStructuredSelection selection) {
        IAction assignAction;
        if (selection == null) {
            this.clearSourceViewer();
            return;
        }
        this.fLastDisplayed = selection;
        if (this.isInView()) {
            this.fSourceViewer.setEditable(true);
        }
        if (selection.isEmpty()) {
            this.clearSourceViewer();
            return;
        }
        Object firstElement = selection.getFirstElement();
        if (firstElement != null && firstElement instanceof IDebugElement) {
            String modelID = ((IDebugElement)firstElement).getModelIdentifier();
            this.setDebugModel(modelID);
        }
        if (this.isInView() && (assignAction = this.getAction(DETAIL_ASSIGN_VALUE_ACTION)) instanceof DetailPaneAssignValueAction) {
            ((DetailPaneAssignValueAction)assignAction).updateCurrentVariable(selection);
        }
        DefaultDetailPane defaultDetailPane = this;
        synchronized (defaultDetailPane) {
            if (this.fDetailJob != null) {
                this.fDetailJob.cancel();
            }
            this.fDetailJob = new DetailJob(selection, this.fModelPresentation);
            this.fDetailJob.schedule();
        }
    }

    public boolean setFocus() {
        if (this.fSourceViewer != null) {
            this.fSourceViewer.getTextWidget().setFocus();
            return true;
        }
        return false;
    }

    public void dispose() {
        super.dispose();
        if (this.fDetailJob != null) {
            this.fDetailJob.cancel();
        }
        if (this.fModelPresentation != null) {
            this.fModelPresentation.dispose();
        }
        this.fDebugModelIdentifier = null;
        if (this.fSourceViewer != null && this.fSourceViewer.getControl() != null) {
            this.fSourceViewer.getControl().dispose();
        }
        if (this.isInView()) {
            this.disposeUndoRedoAction(ITextEditorActionConstants.UNDO);
            this.disposeUndoRedoAction(ITextEditorActionConstants.REDO);
            this.getViewSite().getActionBars().getStatusLineManager().remove((IContributionItem)this.fStatusLineItem);
            DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
            JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        }
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getID() {
        return ID;
    }

    public String getName() {
        return NAME;
    }

    public Object getAdapter(Class required) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.text.IFindReplaceTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            return this.fSourceViewer.getFindReplaceTarget();
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.jface.text.ITextViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(required)) {
            return this.fSourceViewer;
        }
        return null;
    }

    protected IDocument getDetailDocument() {
        if (this.fDetailDocument == null) {
            this.fDetailDocument = new Document();
        }
        return this.fDetailDocument;
    }

    protected void clearSourceViewer() {
        if (this.fDetailJob != null) {
            this.fDetailJob.cancel();
        }
        this.fLastDisplayed = null;
        this.fDetailDocument.set("");
        this.fSourceViewer.setEditable(false);
    }

    protected void configureDetailsViewer() {
        LazyModelPresentation mp = (LazyModelPresentation)this.fModelPresentation.getPresentation(this.getDebugModel());
        SourceViewerConfiguration svc = null;
        if (mp != null) {
            try {
                svc = mp.newDetailsViewerConfiguration();
            }
            catch (CoreException e) {
                DebugUIPlugin.errorDialog(this.fSourceViewer.getControl().getShell(), DetailMessages.DefaultDetailPane_Error_1, DetailMessages.DefaultDetailPane_2, e);
            }
        }
        if (svc == null) {
            svc = new SourceViewerConfiguration();
            this.fSourceViewer.setEditable(false);
        }
        this.fSourceViewer.unconfigure();
        this.fSourceViewer.configure(svc);
        if (this.isInView()) {
            this.updateAction(DETAIL_ASSIGN_VALUE_ACTION);
            this.updateAction(DETAIL_CONTENT_ASSIST_ACTION);
        }
        if (this.isInView()) {
            this.createUndoRedoActions();
        }
    }

    protected String getCursorPosition() {
        if (this.fSourceViewer == null) {
            return "";
        }
        StyledText styledText = this.fSourceViewer.getTextWidget();
        int caret = styledText.getCaretOffset();
        IDocument document = this.fSourceViewer.getDocument();
        if (document == null) {
            return "";
        }
        try {
            int line = document.getLineOfOffset(caret);
            int lineOffset = document.getLineOffset(line);
            int tabWidth = styledText.getTabs();
            int column = 0;
            int i = lineOffset;
            while (i < caret) {
                column = '\t' == document.getChar(i) ? (column += tabWidth - (tabWidth == 0 ? 0 : column % tabWidth)) : ++column;
                ++i;
            }
            this.fLineLabel.fValue = line + 1;
            this.fColumnLabel.fValue = column + 1;
            return MessageFormat.format((String)this.fPositionLabelPattern, (Object[])this.fPositionLabelPatternArguments);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    private ICursorListener getCursorListener() {
        if (this.fCursorListener == null) {
            this.fCursorListener = new ICursorListener(){

                public void keyPressed(KeyEvent e) {
                    DefaultDetailPane.this.fStatusLineItem.setText(DefaultDetailPane.this.getCursorPosition());
                }

                public void keyReleased(KeyEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    DefaultDetailPane.this.fStatusLineItem.setText(DefaultDetailPane.this.getCursorPosition());
                }
            };
        }
        return this.fCursorListener;
    }

    protected String getDebugModel() {
        return this.fDebugModelIdentifier;
    }

    protected void setDebugModel(String id) {
        if (id != this.fDebugModelIdentifier) {
            this.fDebugModelIdentifier = id;
            this.configureDetailsViewer();
        }
    }

    protected void createUndoRedoActions() {
        this.disposeUndoRedoAction(ITextEditorActionConstants.UNDO);
        this.disposeUndoRedoAction(ITextEditorActionConstants.REDO);
        IUndoContext undoContext = this.getUndoContext();
        if (undoContext != null) {
            UndoActionHandler undoAction = new UndoActionHandler((IWorkbenchPartSite)this.getViewSite(), undoContext);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)undoAction, IAbstractTextEditorHelpContextIds.UNDO_ACTION);
            undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
            this.setAction(ITextEditorActionConstants.UNDO, (IAction)undoAction);
            this.setGlobalAction(ITextEditorActionConstants.UNDO, (IAction)undoAction);
            RedoActionHandler redoAction = new RedoActionHandler((IWorkbenchPartSite)this.getViewSite(), undoContext);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)redoAction, IAbstractTextEditorHelpContextIds.REDO_ACTION);
            redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
            this.setAction(ITextEditorActionConstants.REDO, (IAction)redoAction);
            this.setGlobalAction(ITextEditorActionConstants.REDO, (IAction)redoAction);
            this.getViewSite().getActionBars().updateActionBars();
        }
    }

    protected void disposeUndoRedoAction(String actionId) {
        OperationHistoryActionHandler action = (OperationHistoryActionHandler)this.getAction(actionId);
        if (action != null) {
            action.dispose();
            this.setAction(actionId, null);
        }
    }

    private IUndoContext getUndoContext() {
        IUndoManager undoManager = this.fSourceViewer.getUndoManager();
        if (undoManager instanceof IUndoManagerExtension) {
            return ((IUndoManagerExtension)undoManager).getUndoContext();
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getProperty();
        if (propertyName.equals("org.eclipse.debug.ui.DetailPaneFont")) {
            this.fSourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.DetailPaneFont"));
        } else if (propertyName.equals("org.eclipse.debug.ui.max_detail_length")) {
            this.display(this.fLastDisplayed);
        } else if (propertyName.equals(DETAIL_WORD_WRAP_ACTION)) {
            this.fSourceViewer.getTextWidget().setWordWrap(DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(DETAIL_WORD_WRAP_ACTION));
            this.getAction(DETAIL_WORD_WRAP_ACTION).setChecked(DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(DETAIL_WORD_WRAP_ACTION));
        }
    }

    class DetailJob
    extends Job
    implements IValueDetailListener {
        private IStructuredSelection fElements;
        private IDebugModelPresentation fModel;
        private boolean fFirst = true;
        private boolean fComputed = false;
        private IProgressMonitor fMonitor;

        public DetailJob(IStructuredSelection elements, IDebugModelPresentation model) {
            super("compute variable details");
            this.setSystem(true);
            this.fElements = elements;
            this.fModel = model;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            this.fMonitor = monitor;
            Iterator iterator = this.fElements.iterator();
            String message = null;
            while (iterator.hasNext()) {
                if (monitor.isCanceled()) break;
                Object element = iterator.next();
                IValue val = null;
                if (element instanceof IVariable) {
                    try {
                        val = ((IVariable)element).getValue();
                    }
                    catch (DebugException e) {
                        this.detailComputed(null, e.getStatus().getMessage());
                    }
                } else if (element instanceof IExpression) {
                    val = ((IExpression)element).getValue();
                }
                if (val instanceof IndexedValuePartition) {
                    this.detailComputed(null, "");
                    val = null;
                }
                if (element instanceof String) {
                    message = (String)element;
                }
                if (val == null || monitor.isCanceled()) continue;
                this.fModel.computeDetail(val, this);
                DetailJob detailJob = this;
                synchronized (detailJob) {
                    block16: {
                        try {
                            this.wait(30000L);
                            if (this.fComputed) break block16;
                            this.fMonitor.setCanceled(true);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                    }
                }
            }
            if (!this.fComputed) {
                if (message == null) {
                    this.detailComputed(null, "");
                } else {
                    this.detailComputed(null, message);
                }
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void canceling() {
            super.canceling();
            DetailJob detailJob = this;
            synchronized (detailJob) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void detailComputed(IValue value, String result) {
            DetailJob detailJob = this;
            synchronized (detailJob) {
                this.fComputed = true;
            }
            if (!this.fMonitor.isCanceled()) {
                WorkbenchJob append = new WorkbenchJob(this, "append details", result){
                    final /* synthetic */ DetailJob this$1;
                    private final /* synthetic */ String val$result;
                    {
                        this.this$1 = detailJob;
                        this.val$result = string;
                    }

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (!DetailJob.access$0(this.this$1).isCanceled()) {
                            String insert = this.val$result;
                            int length = 0;
                            if (!DetailJob.access$1(this.this$1)) {
                                length = DetailJob.access$3(this.this$1).getDetailDocument().getLength();
                            }
                            if (length > 0) {
                                insert = "\n" + this.val$result;
                            }
                            try {
                                int max = DebugUIPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.debug.ui.max_detail_length");
                                if (max > 0 && insert.length() > max) {
                                    insert = String.valueOf(insert.substring(0, max)) + "...";
                                }
                                if (DetailJob.access$1(this.this$1)) {
                                    DetailJob.access$3(this.this$1).getDetailDocument().set(insert);
                                    DetailJob.access$2(this.this$1, false);
                                } else {
                                    DetailJob.access$3(this.this$1).getDetailDocument().replace(length, 0, insert);
                                }
                            }
                            catch (BadLocationException e) {
                                DebugUIPlugin.log(e);
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                append.setSystem(true);
                append.schedule();
            }
            detailJob = this;
            synchronized (detailJob) {
                this.notifyAll();
            }
        }

        static /* synthetic */ IProgressMonitor access$0(DetailJob detailJob) {
            return detailJob.fMonitor;
        }

        static /* synthetic */ boolean access$1(DetailJob detailJob) {
            return detailJob.fFirst;
        }

        static /* synthetic */ void access$2(DetailJob detailJob, boolean bl) {
            detailJob.fFirst = bl;
        }

        static /* synthetic */ DefaultDetailPane access$3(DetailJob detailJob) {
            return detailJob.DefaultDetailPane.this;
        }
    }

    class FindReplaceTargetWrapper
    implements IFindReplaceTarget {
        private IFindReplaceTarget fTarget;

        public FindReplaceTargetWrapper(IFindReplaceTarget target) {
            this.fTarget = target;
        }

        public boolean canPerformFind() {
            return this.fTarget.canPerformFind();
        }

        public int findAndSelect(int widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
            StyledText text;
            int position = this.fTarget.findAndSelect(widgetOffset, findString, searchForward, caseSensitive, wholeWord);
            if (DefaultDetailPane.this.fSourceViewer != null && (text = DefaultDetailPane.this.fSourceViewer.getTextWidget()) != null && !text.isDisposed()) {
                text.showSelection();
            }
            return position;
        }

        public Point getSelection() {
            return this.fTarget.getSelection();
        }

        public String getSelectionText() {
            return this.fTarget.getSelectionText();
        }

        public boolean isEditable() {
            return this.fTarget.isEditable();
        }

        public void replaceSelection(String text) {
            this.fTarget.replaceSelection(text);
        }
    }

    static interface ICursorListener
    extends MouseListener,
    KeyListener {
    }

    private static class PositionLabelValue {
        public int fValue;

        private PositionLabelValue() {
        }

        public String toString() {
            return String.valueOf(this.fValue);
        }
    }
}

