/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.ChainedJob;
import org.eclipse.wst.server.core.internal.IClient;
import org.eclipse.wst.server.core.internal.ILaunchableAdapter;
import org.eclipse.wst.server.core.internal.PublishServerJob;
import org.eclipse.wst.server.core.internal.RestartServerJob;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.ServerType;
import org.eclipse.wst.server.core.internal.StartServerJob;
import org.eclipse.wst.server.core.model.ModuleArtifactDelegate;
import org.eclipse.wst.server.ui.internal.EclipseUtil;
import org.eclipse.wst.server.ui.internal.LaunchClientJob;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.actions.RunOnServerActionDelegate;

public class RunOnServerLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public static final String ATTR_SERVER_ID = "server-id";
    public static final String ATTR_MODULE_ARTIFACT = "module-artifact";
    public static final String ATTR_MODULE_ARTIFACT_CLASS = "module-artifact-class";
    public static final String ATTR_LAUNCHABLE_ADAPTER_ID = "launchable-adapter-id";
    public static final String ATTR_CLIENT_ID = "client-id";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void launch(ILaunchConfiguration configuration, String launchMode, final ILaunch launch2, IProgressMonitor monitor) throws CoreException {
        String serverId = configuration.getAttribute(ATTR_SERVER_ID, null);
        String moduleArt = configuration.getAttribute(ATTR_MODULE_ARTIFACT, null);
        String moduleArtifactClass = configuration.getAttribute(ATTR_MODULE_ARTIFACT_CLASS, null);
        String laId = configuration.getAttribute(ATTR_LAUNCHABLE_ADAPTER_ID, null);
        String clientId = configuration.getAttribute(ATTR_CLIENT_ID, null);
        IServer server = ServerCore.findServer((String)serverId);
        IModule module = null;
        ModuleArtifactDelegate moduleArtifact = null;
        ILaunchableAdapter launchableAdapter = ServerPlugin.findLaunchableAdapter((String)laId);
        IClient client = ServerPlugin.findClient((String)clientId);
        try {
            Class<?> c = Class.forName(moduleArtifactClass);
            moduleArtifact = (ModuleArtifactDelegate)c.newInstance();
            moduleArtifact.deserialize(moduleArt);
            module = moduleArtifact.getModule();
        }
        catch (Throwable throwable) {
            Trace.trace((byte)2, "Could not load module artifact delegate class");
        }
        if (moduleArtifact == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.ui", Messages.errorLaunchConfig));
        }
        if (module == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.ui", Messages.errorLaunchConfig));
        }
        if (server == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.ui", Messages.errorInvalidServer));
        }
        if (launchableAdapter == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.ui", Messages.errorLaunchConfig));
        }
        final Shell[] shell2 = new Shell[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                shell2[0] = EclipseUtil.getShell();
            }
        });
        Shell shell = shell2[0];
        if (client == null) {
            client = new IClient(){

                public String getDescription() {
                    return Messages.clientDefaultDescription;
                }

                public String getId() {
                    return "org.eclipse.wst.server.ui.client.default";
                }

                public String getName() {
                    return Messages.clientDefaultName;
                }

                public IStatus launch(IServer server3, Object launchable2, String launchMode3, ILaunch launch) {
                    return Status.OK_STATUS;
                }

                public boolean supports(IServer server3, Object launchable2, String launchMode3) {
                    return true;
                }
            };
        }
        Trace.trace((byte)4, "Ready to launch");
        IModule[] modules = new IModule[]{module};
        int state = server.getServerState();
        if (state == 1) {
            LaunchClientJob clientJob = new LaunchClientJob(server, modules, launchMode, (IModuleArtifact)moduleArtifact, launchableAdapter, client);
            clientJob.schedule();
            return;
        } else if (state == 2) {
            int result;
            boolean restart = false;
            String mode = server.getMode();
            IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            boolean disabledBreakpoints = false;
            if (server.getServerRestartState()) {
                result = RunOnServerActionDelegate.openRestartDialog(shell);
                if (result == 0) {
                    launchMode = mode;
                    restart = true;
                } else if (result == 9) {
                    return;
                }
            }
            if (!restart) {
                int result2;
                boolean breakpointsOption;
                if (!"run".equals(mode) && "run".equals(launchMode)) {
                    breakpointsOption = false;
                    if (breakpointManager.isEnabled() && "debug".equals(mode)) {
                        breakpointsOption = true;
                    }
                    if ((result2 = RunOnServerActionDelegate.openOptionsDialog(shell, Messages.wizRunOnServerTitle, Messages.dialogModeWarningRun, breakpointsOption)) == 0) {
                        restart = true;
                    } else if (result2 == 1) {
                        breakpointManager.setEnabled(false);
                        disabledBreakpoints = true;
                        launchMode = mode;
                    } else {
                        if (result2 != 2) return;
                        launchMode = mode;
                    }
                } else if (!"debug".equals(mode) && "debug".equals(launchMode)) {
                    result = RunOnServerActionDelegate.openOptionsDialog(shell, Messages.wizDebugOnServerTitle, Messages.dialogModeWarningDebug, false);
                    if (result == 0) {
                        restart = true;
                    } else {
                        if (result != 1) return;
                        launchMode = mode;
                    }
                } else if (!"profile".equals(mode) && "profile".equals(launchMode)) {
                    breakpointsOption = false;
                    if (breakpointManager.isEnabled() && "debug".equals(mode)) {
                        breakpointsOption = true;
                    }
                    if ((result2 = RunOnServerActionDelegate.openOptionsDialog(shell, Messages.wizProfileOnServerTitle, Messages.dialogModeWarningProfile, breakpointsOption)) == 0) {
                        restart = true;
                    } else if (result2 == 1) {
                        breakpointManager.setEnabled(false);
                        disabledBreakpoints = true;
                        launchMode = mode;
                    } else {
                        if (result2 != 2) return;
                        launchMode = mode;
                    }
                }
                if ("debug".equals(launchMode) && !breakpointManager.isEnabled() && !disabledBreakpoints) {
                    result = RunOnServerActionDelegate.openBreakpointDialog(shell);
                    if (result == 0) {
                        breakpointManager.setEnabled(true);
                    } else if (result != 1) {
                        return;
                    }
                }
            }
            PublishServerJob publishJob = new PublishServerJob(server, 1, false);
            LaunchClientJob clientJob = new LaunchClientJob(server, modules, launchMode, (IModuleArtifact)moduleArtifact, launchableAdapter, client);
            publishJob.setNextJob((Job)clientJob);
            if (restart) {
                RestartServerJob restartJob = new RestartServerJob(server, launchMode);
                restartJob.setNextJob((Job)publishJob);
                restartJob.schedule();
                return;
            } else {
                publishJob.schedule();
            }
            return;
        } else {
            if (state == 3) return;
            PublishServerJob publishJob = new PublishServerJob(server);
            StartServerJob startServerJob = new StartServerJob(server, launchMode);
            LaunchClientJob clientJob = new LaunchClientJob(server, modules, launchMode, (IModuleArtifact)moduleArtifact, launchableAdapter, client);
            ChainedJob myJob = new ChainedJob("test", server){

                protected IStatus run(IProgressMonitor monitor2) {
                    try {
                        LaunchConfigurationManager lcm = DebugUIPlugin.getDefault().getLaunchConfigurationManager();
                        lcm.setRecentLaunch(launch2);
                    }
                    catch (Throwable throwable) {
                        Trace.trace((byte)2, "Could not tweak debug launch history");
                    }
                    return Status.OK_STATUS;
                }
            };
            if (((ServerType)server.getServerType()).startBeforePublish()) {
                startServerJob.setNextJob((Job)publishJob);
                publishJob.setNextJob((Job)clientJob);
                clientJob.setNextJob((Job)myJob);
                startServerJob.schedule();
                return;
            } else {
                publishJob.setNextJob((Job)startServerJob);
                startServerJob.setNextJob((Job)clientJob);
                clientJob.setNextJob((Job)myJob);
                publishJob.schedule();
            }
        }
    }
}

