/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.internal.ui.text.FileSearchPage;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.internal.ui.text.IFileSearchContentProvider;
import org.eclipse.search.ui.text.AbstractTextSearchResult;

public class FileTreeContentProvider
implements ITreeContentProvider,
IFileSearchContentProvider {
    private final Object[] EMPTY_ARR = new Object[0];
    private AbstractTextSearchResult fResult;
    private FileSearchPage fPage;
    private AbstractTreeViewer fTreeViewer;
    private Map fChildrenMap;

    FileTreeContentProvider(FileSearchPage page, AbstractTreeViewer viewer) {
        this.fPage = page;
        this.fTreeViewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        Object[] children = this.getChildren(inputElement);
        int elementLimit = this.getElementLimit();
        if (elementLimit != -1 && elementLimit < children.length) {
            Object[] limitedChildren = new Object[elementLimit];
            System.arraycopy(children, 0, limitedChildren, 0, elementLimit);
            return limitedChildren;
        }
        return children;
    }

    private int getElementLimit() {
        return this.fPage.getElementLimit();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof FileSearchResult) {
            this.initialize((FileSearchResult)newInput);
        }
    }

    protected synchronized void initialize(AbstractTextSearchResult result) {
        this.fResult = result;
        this.fChildrenMap = new HashMap();
        if (result != null) {
            Object[] elements = result.getElements();
            int i = 0;
            while (i < elements.length) {
                this.insert(elements[i], false);
                ++i;
            }
        }
    }

    protected void insert(Object child, boolean refreshViewer) {
        Object parent = this.getParent(child);
        while (parent != null) {
            if (this.insertChild(parent, child)) {
                if (refreshViewer) {
                    this.fTreeViewer.add(parent, child);
                }
            } else {
                if (refreshViewer) {
                    this.fTreeViewer.refresh(parent);
                }
                return;
            }
            child = parent;
            parent = this.getParent(child);
        }
        if (this.insertChild(this.fResult, child) && refreshViewer) {
            this.fTreeViewer.add((Object)this.fResult, child);
        }
    }

    private boolean insertChild(Object parent, Object child) {
        HashSet<Object> children = (HashSet<Object>)this.fChildrenMap.get(parent);
        if (children == null) {
            children = new HashSet<Object>();
            this.fChildrenMap.put(parent, children);
        }
        return children.add(child);
    }

    protected void remove(Object element, boolean refreshViewer) {
        if (this.hasChildren(element)) {
            if (refreshViewer) {
                this.fTreeViewer.refresh(element);
            }
        } else if (this.fResult.getMatchCount(element) == 0) {
            this.fChildrenMap.remove(element);
            Object parent = this.getParent(element);
            if (parent != null) {
                this.removeFromSiblings(element, parent);
                this.remove(parent, refreshViewer);
            } else {
                this.removeFromSiblings(element, this.fResult);
                if (refreshViewer) {
                    this.fTreeViewer.refresh();
                }
            }
        } else if (refreshViewer) {
            this.fTreeViewer.refresh(element);
        }
    }

    private void removeFromSiblings(Object element, Object parent) {
        Set siblings = (Set)this.fChildrenMap.get(parent);
        if (siblings != null) {
            siblings.remove(element);
        }
    }

    public Object[] getChildren(Object parentElement) {
        Set children = (Set)this.fChildrenMap.get(parentElement);
        if (children == null) {
            return this.EMPTY_ARR;
        }
        return children.toArray();
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public synchronized void elementsChanged(Object[] updatedElements) {
        int i = 0;
        while (i < updatedElements.length) {
            if (this.fResult.getMatchCount(updatedElements[i]) > 0) {
                this.insert(updatedElements[i], true);
            } else {
                this.remove(updatedElements[i], true);
            }
            ++i;
        }
    }

    public void clear() {
        this.initialize(this.fResult);
        this.fTreeViewer.refresh();
    }

    public Object getParent(Object element) {
        if (element instanceof IProject) {
            return null;
        }
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            return resource.getParent();
        }
        return null;
    }
}

