/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.mapping;

import com.ibm.icu.text.DateFormat;
import java.util.Date;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.client.listeners.LogEntry;
import org.eclipse.team.internal.core.subscribers.DiffChangeSet;

public class CVSCheckedInChangeSet
extends DiffChangeSet {
    private final ILogEntry entry;

    public CVSCheckedInChangeSet(ILogEntry entry) {
        this.entry = entry;
        Date date = entry.getDate();
        String comment = LogEntry.flattenText(entry.getComment());
        if (date == null) {
            this.setName("[" + entry.getAuthor() + "] " + comment);
        } else {
            String dateString = DateFormat.getDateTimeInstance().format(date);
            this.setName("[" + entry.getAuthor() + "] (" + dateString + ") " + comment);
        }
    }

    public String getAuthor() {
        return this.entry.getAuthor();
    }

    public Date getDate() {
        return this.entry.getDate();
    }

    public String getComment() {
        return this.entry.getComment();
    }
}

