/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.registry.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.equinox.http.registry.internal.DefaultRegistryHttpContext;
import org.eclipse.equinox.http.registry.internal.ExtensionPointTracker;
import org.eclipse.equinox.http.registry.internal.HttpRegistryManager;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

public class HttpContextManager
implements ExtensionPointTracker.Listener {
    private static final String HTTPCONTEXTS_EXTENSION_POINT = "org.eclipse.equinox.http.registry.httpcontexts";
    private static final String HTTPCONTEXT = "httpcontext";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String CLASS = "class";
    private static final String PATH = "path";
    private static final String MIMEMAPPING = "mime-mapping";
    private static final String MIMEEXTENSION = "extension";
    private static final String MIMETYPE = "mime-type";
    private static final String RESOURCEMAPPING = "resource-mapping";
    private static final String BUNDLE = "bundle";
    private List registered = new ArrayList();
    private HttpRegistryManager httpRegistryManager;
    private ExtensionPointTracker tracker;

    public HttpContextManager(HttpRegistryManager httpRegistryManager, IExtensionRegistry registry) {
        this.httpRegistryManager = httpRegistryManager;
        this.tracker = new ExtensionPointTracker(registry, HTTPCONTEXTS_EXTENSION_POINT, this);
    }

    public void start() {
        this.tracker.open();
    }

    public void stop() {
        this.tracker.close();
    }

    public void added(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            block12: {
                String httpContextId;
                IConfigurationElement httpContextElement = elements[i];
                if (HTTPCONTEXT.equals(httpContextElement.getName()) && ((httpContextId = httpContextElement.getAttribute(ID)) != null || (httpContextId = httpContextElement.getAttribute(NAME)) != null)) {
                    HttpContext context;
                    block11: {
                        if (httpContextId.indexOf(46) == -1) {
                            httpContextId = String.valueOf(httpContextElement.getNamespaceIdentifier()) + "." + httpContextId;
                        }
                        context = null;
                        String clazz = httpContextElement.getAttribute(CLASS);
                        if (clazz != null) {
                            try {
                                context = (HttpContext)httpContextElement.createExecutableExtension(CLASS);
                                break block11;
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                                break block12;
                            }
                        }
                        Bundle contributingBundle = this.httpRegistryManager.getBundle(extension.getContributor());
                        DefaultRegistryHttpContext defaultContext = this.httpRegistryManager.createDefaultRegistryHttpContext();
                        String oldPath = httpContextElement.getAttribute(PATH);
                        if (oldPath != null) {
                            defaultContext.addResourceMapping(contributingBundle, oldPath);
                        }
                        IConfigurationElement[] resourceMappingElements = httpContextElement.getChildren(RESOURCEMAPPING);
                        int j = 0;
                        while (j < resourceMappingElements.length) {
                            AdminPermission resourcePermission;
                            IConfigurationElement resourceMappingElement = resourceMappingElements[i];
                            String path = resourceMappingElement.getAttribute(PATH);
                            Bundle resourceBundle = contributingBundle;
                            String bundleName = resourceMappingElement.getAttribute(BUNDLE);
                            if (bundleName == null || (resourceBundle = this.httpRegistryManager.getBundle(bundleName)) != null && (System.getSecurityManager() == null || contributingBundle.hasPermission((Object)(resourcePermission = new AdminPermission(resourceBundle, "resource"))))) {
                                defaultContext.addResourceMapping(resourceBundle, path);
                            }
                            ++j;
                        }
                        IConfigurationElement[] mimeMappingElements = httpContextElement.getChildren(MIMEMAPPING);
                        int j2 = 0;
                        while (j2 < mimeMappingElements.length) {
                            IConfigurationElement mimeMappingElement = mimeMappingElements[i];
                            String mimeExtension = mimeMappingElement.getAttribute(MIMEEXTENSION);
                            String mimeType = mimeMappingElement.getAttribute(MIMETYPE);
                            defaultContext.addMimeMapping(mimeExtension, mimeType);
                            ++j2;
                        }
                        context = defaultContext;
                    }
                    if (this.httpRegistryManager.addHttpContextContribution(httpContextId, context, extension.getContributor())) {
                        this.registered.add(httpContextElement);
                    }
                }
            }
            ++i;
        }
    }

    public void removed(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            String httpContextId;
            IConfigurationElement httpContextElement = elements[i];
            if (HTTPCONTEXT.equals(httpContextElement.getName()) && ((httpContextId = httpContextElement.getAttribute(ID)) != null || (httpContextId = httpContextElement.getAttribute(NAME)) != null)) {
                if (httpContextId.indexOf(46) == -1) {
                    httpContextId = String.valueOf(httpContextElement.getNamespaceIdentifier()) + "." + httpContextId;
                }
                if (this.registered.remove(httpContextElement)) {
                    this.httpRegistryManager.removeHttpContextContribution(httpContextId);
                }
            }
            ++i;
        }
    }
}

