/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.loader;

import com.ibm.icu.text.MessageFormat;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCColumn;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.connectivity.sqm.loader.Messages;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.ReferenceDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.StructuredUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.ecore.EStructuralFeature;

public class JDBCTableColumnLoader
extends JDBCBaseLoader {
    public static final String COLUMN_COLUMN_NAME = "COLUMN_NAME";
    public static final String COLUMN_DATA_TYPE = "DATA_TYPE";
    public static final String COLUMN_TYPE_NAME = "TYPE_NAME";
    public static final String COLUMN_COLUMN_SIZE = "COLUMN_SIZE";
    public static final String COLUMN_DECIMAL_DIGITS = "DECIMAL_DIGITS";
    public static final String COLUMN_NULLABLE = "NULLABLE";
    public static final String COLUMN_REMARKS = "REMARKS";
    public static final String COLUMN_COLUMN_DEF = "COLUMN_DEF";
    public static final String COLUMN_SCOPE_CATALOG = "SCOPE_CATALOG";
    public static final String COLUMN_SCOPE_SCHEMA = "SCOPE_SCHEMA";
    public static final String COLUMN_SCOPE_TABLE = "SCOPE_TABLE";
    private Pattern mUDTNameMatcherPattern;
    private boolean mCatalogAtStart;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JDBCTableColumnLoader(ICatalogObject catalogObject) {
        this(catalogObject, null);
    }

    public JDBCTableColumnLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
        if (!$assertionsDisabled && !(catalogObject instanceof Table)) {
            throw new AssertionError();
        }
    }

    public List loadColumns() throws SQLException {
        ArrayList retVal = new ArrayList();
        this.loadColumns(retVal, Collections.EMPTY_SET);
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadColumns(List containmentList, Collection existingColumns) throws SQLException {
        ResultSet rs = null;
        try {
            this.initActiveFilter();
            rs = this.createResultSet();
            while (rs.next()) {
                String columnName = rs.getString(COLUMN_COLUMN_NAME);
                if (columnName == null || this.isFiltered(columnName)) continue;
                Column column = (Column)this.getAndRemoveSQLObject(existingColumns, columnName);
                if (column == null) {
                    column = this.processRow(rs);
                    if (column == null) continue;
                    containmentList.add(column);
                    continue;
                }
                this.initialize(column, rs);
                containmentList.add(column);
                if (!(column instanceof ICatalogObject)) continue;
                ((ICatalogObject)column).refresh();
            }
        }
        finally {
            if (rs != null) {
                this.closeResultSet(rs);
            }
        }
    }

    public void clearColumns(List columns) {
        columns.clear();
    }

    protected ResultSet createResultSet() throws SQLException {
        try {
            Table table = this.getTable();
            Schema schema = table.getSchema();
            return this.getCatalogObject().getConnection().getMetaData().getColumns(schema.getCatalog().getName(), schema.getName(), table.getName(), null);
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException(MessageFormat.format((String)Messages.Error_Unsupported_DatabaseMetaData_Method, (Object[])new Object[]{"java.sql.DatabaseMetaData.getColumns()"}));
            error.initCause(e);
            throw error;
        }
    }

    protected void closeResultSet(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected Column processRow(ResultSet rs) throws SQLException {
        Column column = this.createColumn();
        this.initialize(column, rs);
        return column;
    }

    protected Column createColumn() {
        return new JDBCColumn();
    }

    protected void initialize(Column column, ResultSet rs) throws SQLException {
        column.setName(rs.getString(COLUMN_COLUMN_NAME));
        column.setDescription(rs.getString(COLUMN_REMARKS));
        column.setDefaultValue(rs.getString(COLUMN_COLUMN_DEF));
        this.initColumnType(column, rs);
        column.setNullable(rs.getInt(COLUMN_NULLABLE) == 1);
    }

    protected void initColumnType(Column column, ResultSet rs) throws SQLException {
        String typeName = rs.getString(COLUMN_TYPE_NAME).toUpperCase();
        int typeCode = rs.getInt(COLUMN_DATA_TYPE);
        List pdtds = this.getDatabaseDefinition().getPredefinedDataTypeDefinitionsByJDBCEnumType(typeCode);
        if (pdtds.size() > 0) {
            PredefinedDataTypeDefinition pdtd = null;
            Iterator it = pdtds.iterator();
            block0: while (pdtd == null && it.hasNext()) {
                PredefinedDataTypeDefinition curPDTD = (PredefinedDataTypeDefinition)it.next();
                Iterator nameIt = curPDTD.getName().iterator();
                while (nameIt.hasNext()) {
                    String name = (String)nameIt.next();
                    if (!typeName.equals(name)) continue;
                    pdtd = curPDTD;
                    continue block0;
                }
            }
            if (pdtd == null) {
                pdtd = this.getDatabaseDefinition().getPredefinedDataTypeDefinition(typeName);
            }
            if (pdtd != null || pdtd == null && typeCode != 1111 && typeCode != 2006) {
                EStructuralFeature feature;
                if (pdtd == null) {
                    pdtd = (PredefinedDataTypeDefinition)pdtds.get(0);
                }
                PredefinedDataType pdt = this.getDatabaseDefinition().getPredefinedDataType(pdtd);
                if (pdtd.isLengthSupported()) {
                    feature = pdt.eClass().getEStructuralFeature("length");
                    pdt.eSet(feature, (Object)new Integer(rs.getInt(COLUMN_COLUMN_SIZE)));
                }
                if (pdtd.isPrecisionSupported()) {
                    feature = pdt.eClass().getEStructuralFeature("precision");
                    pdt.eSet(feature, (Object)new Integer(rs.getInt(COLUMN_COLUMN_SIZE)));
                }
                if (pdtd.isScaleSupported()) {
                    feature = pdt.eClass().getEStructuralFeature("scale");
                    pdt.eSet(feature, (Object)new Integer(rs.getInt(COLUMN_DECIMAL_DIGITS)));
                }
                column.setDataType((DataType)pdt);
                return;
            }
        }
        if (typeName == null) {
            column.setDataType(null);
            return;
        }
        if (2006 == typeCode) {
            ReferenceDataType ref = this.createReferenceDataType();
            if (ref == null) {
                column.setDataType(null);
                return;
            }
            UserDefinedType udt = this.findUserDefinedType(typeName);
            Table table = this.findScopedTable(rs.getString(COLUMN_SCOPE_CATALOG), rs.getString(COLUMN_SCOPE_SCHEMA), rs.getString(COLUMN_SCOPE_TABLE));
            this.initReferenceDataType(ref, udt, table);
            column.setDataType((DataType)ref);
        } else {
            UserDefinedType udt = this.findUserDefinedType(typeName);
            column.setDataType((DataType)udt);
        }
    }

    protected ReferenceDataType createReferenceDataType() {
        return null;
    }

    protected void initReferenceDataType(ReferenceDataType ref, UserDefinedType udt, Table scopeTable) {
        if (udt instanceof StructuredUserDefinedType) {
            ref.setReferencedType((StructuredUserDefinedType)udt);
        }
        ref.setScopeTable(scopeTable);
    }

    protected Table getTable() {
        return (Table)this.getCatalogObject();
    }

    protected DatabaseDefinition getDatabaseDefinition() {
        return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogObject().getCatalogDatabase());
    }

    protected Matcher getUDTNameMatcher(String name) throws SQLException {
        if (this.mUDTNameMatcherPattern == null) {
            DatabaseMetaData dbmd = this.getCatalogObject().getConnection().getMetaData();
            String namePattern = "([a-zA-Z0-9_" + dbmd.getExtraNameCharacters() + "]*)";
            String catalogSeparator = dbmd.getCatalogSeparator();
            String regex = namePattern + "." + namePattern;
            if (name.indexOf(catalogSeparator) < 0) {
                regex = regex + "()";
            } else if (dbmd.isCatalogAtStart()) {
                this.mCatalogAtStart = true;
                regex = namePattern + catalogSeparator + regex;
            } else {
                regex = regex + catalogSeparator + namePattern;
            }
            this.mUDTNameMatcherPattern = Pattern.compile(regex);
        }
        return this.mUDTNameMatcherPattern.matcher(name);
    }

    protected UserDefinedType findUserDefinedType(String typeName) {
        Matcher matcher;
        try {
            matcher = this.getUDTNameMatcher(typeName);
        }
        catch (SQLException e) {
            return null;
        }
        if (matcher.matches()) {
            String udtName;
            String schemaName;
            String catalogName;
            if (this.mCatalogAtStart) {
                catalogName = matcher.group(1);
                schemaName = matcher.group(2);
                udtName = matcher.group(3);
            } else {
                schemaName = matcher.group(1);
                udtName = matcher.group(2);
                catalogName = matcher.group(3);
            }
            if (udtName == null) {
                return null;
            }
            if (catalogName == null) {
                catalogName = new String();
            }
            if (schemaName == null) {
                schemaName = new String();
            }
            Database db = this.getCatalogObject().getCatalogDatabase();
            Iterator catIt = db.getCatalogs().iterator();
            while (catIt.hasNext()) {
                Catalog catalog = (Catalog)catIt.next();
                if (!catalogName.equals(catalog.getName())) continue;
                Iterator schemIt = catalog.getSchemas().iterator();
                while (schemIt.hasNext()) {
                    Schema schema = (Schema)schemIt.next();
                    if (!schemaName.equals(schema.getName())) continue;
                    Iterator udtIt = schema.getUserDefinedTypes().iterator();
                    while (udtIt.hasNext()) {
                        UserDefinedType udt = (UserDefinedType)udtIt.next();
                        if (!udtName.equals(udt.getName())) continue;
                        return udt;
                    }
                }
            }
        }
        return null;
    }

    protected Table findScopedTable(String catalogScope, String schemaScope, String tableScope) {
        if (tableScope == null) {
            return null;
        }
        if (catalogScope == null) {
            catalogScope = this.getTable().getSchema().getCatalog().getName();
            try {
                if (this.getCatalogObject().getConnection().getMetaData().supportsCatalogsInTableDefinitions()) {
                    catalogScope = new String();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (schemaScope == null) {
            schemaScope = this.getTable().getSchema().getName();
            try {
                if (this.getCatalogObject().getConnection().getMetaData().supportsSchemasInTableDefinitions()) {
                    schemaScope = new String();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        Database db = this.getCatalogObject().getCatalogDatabase();
        Iterator catIt = db.getCatalogs().iterator();
        while (catIt.hasNext()) {
            Catalog catalog = (Catalog)catIt.next();
            if (!catalogScope.equals(catalog.getName())) continue;
            Iterator schemIt = catalog.getSchemas().iterator();
            while (schemIt.hasNext()) {
                Schema schema = (Schema)schemIt.next();
                if (!schemaScope.equals(schema.getName())) continue;
                Iterator tableIt = schema.getTables().iterator();
                while (tableIt.hasNext()) {
                    Table table = (Table)tableIt.next();
                    if (!tableScope.equals(table.getName())) continue;
                    return table;
                }
            }
        }
        return null;
    }

    static {
        $assertionsDisabled = !JDBCTableColumnLoader.class.desiredAssertionStatus();
    }
}

