/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.net.URL;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.AbstractWebBrowser;
import org.eclipse.ui.internal.browser.Messages;
import org.eclipse.ui.internal.browser.Trace;
import org.eclipse.ui.internal.browser.WebBrowserUtil;

public class SystemBrowserInstance
extends AbstractWebBrowser {
    public SystemBrowserInstance(String id) {
        super(id);
    }

    public void openURL(URL url) throws PartInitException {
        String urlText = null;
        if (url != null) {
            urlText = url.toExternalForm();
        }
        if (urlText != null && !WebBrowserUtil.isWindows()) {
            int index = urlText.indexOf(" ");
            while (index >= 0) {
                urlText = String.valueOf(urlText.substring(0, index)) + "%20" + urlText.substring(index + 1);
                index = urlText.indexOf(" ");
            }
        }
        Trace.trace(Trace.FINEST, "Launching system Web browser: " + urlText);
        Program program = Program.findProgram((String)"html");
        if (program != null && program.execute(urlText)) {
            return;
        }
        if (!Program.launch((String)urlText)) {
            throw new PartInitException(NLS.bind((String)Messages.errorCouldNotLaunchWebBrowser, (Object)url.toExternalForm()));
        }
    }
}

