/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptorManager;
import org.eclipse.ui.navigator.IExtensionActivationListener;
import org.eclipse.ui.navigator.INavigatorActivationService;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;

public final class NavigatorActivationService
implements INavigatorActivationService {
    private static final String ACTIVATED_EXTENSIONS = ".activatedExtensions";
    private static final NavigatorContentDescriptorManager CONTENT_DESCRIPTOR_REGISTRY = NavigatorContentDescriptorManager.getInstance();
    private static final INavigatorContentDescriptor[] NO_DESCRIPTORS = new INavigatorContentDescriptor[0];
    private static final String DELIM = ";";
    private static final char EQUALS = '=';
    private final Map activatedExtensionsMap = new HashMap();
    private final ListenerList listeners = new ListenerList();
    private INavigatorContentService contentService;

    public NavigatorActivationService(INavigatorContentService aContentService) {
        this.contentService = aContentService;
        this.revertExtensionActivations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNavigatorExtensionActive(String aNavigatorExtensionId) {
        Boolean b = (Boolean)this.activatedExtensionsMap.get(aNavigatorExtensionId);
        if (b != null) {
            return b;
        }
        Map map = this.activatedExtensionsMap;
        synchronized (map) {
            NavigatorContentDescriptor descriptor = CONTENT_DESCRIPTOR_REGISTRY.getContentDescriptor(aNavigatorExtensionId);
            if (descriptor.isActiveByDefault()) {
                this.activatedExtensionsMap.put(aNavigatorExtensionId, Boolean.TRUE);
            } else {
                this.activatedExtensionsMap.put(aNavigatorExtensionId, Boolean.FALSE);
            }
            return descriptor.isActiveByDefault();
        }
    }

    public void setActive(String aNavigatorExtensionId, boolean toEnable) {
        boolean currentlyActive = this.isNavigatorExtensionActive(aNavigatorExtensionId);
        if (currentlyActive == toEnable) {
            return;
        }
        if (toEnable) {
            this.activatedExtensionsMap.put(aNavigatorExtensionId, Boolean.TRUE);
        } else {
            this.activatedExtensionsMap.put(aNavigatorExtensionId, Boolean.FALSE);
        }
        this.notifyListeners(new String[]{aNavigatorExtensionId}, toEnable);
    }

    public void setActive(String[] aNavigatorExtensionIds, boolean toEnable) {
        if (toEnable) {
            int i = 0;
            while (i < aNavigatorExtensionIds.length) {
                this.activatedExtensionsMap.put(aNavigatorExtensionIds[i], Boolean.TRUE);
                ++i;
            }
        } else {
            int i = 0;
            while (i < aNavigatorExtensionIds.length) {
                this.activatedExtensionsMap.put(aNavigatorExtensionIds[i], Boolean.FALSE);
                ++i;
            }
        }
        this.notifyListeners(aNavigatorExtensionIds, toEnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistExtensionActivations() {
        Preferences preferences = NavigatorPlugin.getDefault().getPluginPreferences();
        Map map = this.activatedExtensionsMap;
        synchronized (map) {
            Iterator activatedExtensionsIterator = this.activatedExtensionsMap.keySet().iterator();
            StringBuffer preferenceValue = new StringBuffer();
            String navigatorExtensionId = null;
            boolean isActive = false;
            while (activatedExtensionsIterator.hasNext()) {
                navigatorExtensionId = (String)activatedExtensionsIterator.next();
                isActive = this.isNavigatorExtensionActive(navigatorExtensionId);
                preferenceValue.append(navigatorExtensionId).append('=').append(isActive ? Boolean.TRUE : Boolean.FALSE).append(DELIM);
            }
            preferences.setValue(this.getPreferenceKey(), preferenceValue.toString());
        }
        NavigatorPlugin.getDefault().savePluginPreferences();
    }

    public void addExtensionActivationListener(IExtensionActivationListener aListener) {
        this.listeners.add((Object)aListener);
    }

    public void removeExtensionActivationListener(IExtensionActivationListener aListener) {
        this.listeners.remove((Object)aListener);
    }

    private void notifyListeners(String[] navigatorExtensionIds, boolean toEnable) {
        if (navigatorExtensionIds != null) {
            if (navigatorExtensionIds.length > 1) {
                Arrays.sort(navigatorExtensionIds);
            }
            Object[] listenerArray = this.listeners.getListeners();
            int i = 0;
            while (i < listenerArray.length) {
                ((IExtensionActivationListener)listenerArray[i]).onExtensionActivation(this.contentService.getViewerId(), navigatorExtensionIds, toEnable);
                ++i;
            }
        }
    }

    private void revertExtensionActivations() {
        Preferences preferences = NavigatorPlugin.getDefault().getPluginPreferences();
        String activatedExtensionsString = preferences.getString(this.getPreferenceKey());
        if (activatedExtensionsString != null && activatedExtensionsString.length() > 0) {
            String[] contentExtensionIds = activatedExtensionsString.split(DELIM);
            String id = null;
            String booleanString = null;
            int indx = 0;
            int i = 0;
            while (i < contentExtensionIds.length) {
                indx = contentExtensionIds[i].indexOf(61);
                if (indx > -1) {
                    id = contentExtensionIds[i].substring(0, indx);
                    booleanString = contentExtensionIds[i].substring(indx + 1, contentExtensionIds[i].length());
                    this.activatedExtensionsMap.put(id, Boolean.valueOf(booleanString));
                } else {
                    NavigatorContentDescriptor descriptor = CONTENT_DESCRIPTOR_REGISTRY.getContentDescriptor(contentExtensionIds[i]);
                    if (descriptor != null) {
                        this.activatedExtensionsMap.put(id, descriptor.isActiveByDefault());
                    }
                }
                ++i;
            }
        } else {
            NavigatorContentDescriptor[] contentDescriptors = CONTENT_DESCRIPTOR_REGISTRY.getAllContentDescriptors();
            int i = 0;
            while (i < contentDescriptors.length) {
                if (contentDescriptors[i].isActiveByDefault()) {
                    this.activatedExtensionsMap.put(contentDescriptors[i].getId(), Boolean.TRUE);
                }
                ++i;
            }
        }
    }

    private String getPreferenceKey() {
        return String.valueOf(this.contentService.getViewerId()) + ACTIVATED_EXTENSIONS;
    }

    public INavigatorContentDescriptor[] activateExtensions(String[] extensionIds, boolean toDeactivateAllOthers) {
        HashSet<NavigatorContentDescriptor> activatedDescriptors = new HashSet<NavigatorContentDescriptor>();
        this.setActive(extensionIds, true);
        int extId = 0;
        while (extId < extensionIds.length) {
            activatedDescriptors.add(CONTENT_DESCRIPTOR_REGISTRY.getContentDescriptor(extensionIds[extId]));
            ++extId;
        }
        if (toDeactivateAllOthers) {
            NavigatorContentDescriptor[] descriptors = CONTENT_DESCRIPTOR_REGISTRY.getAllContentDescriptors();
            ArrayList<NavigatorContentDescriptor> descriptorList = new ArrayList<NavigatorContentDescriptor>(Arrays.asList(descriptors));
            int descriptorIndx = 0;
            while (descriptorIndx < descriptors.length) {
                int extId2 = 0;
                while (extId2 < extensionIds.length) {
                    if (descriptors[descriptorIndx].getId().equals(extensionIds[extId2])) {
                        descriptorList.remove(descriptors[descriptorIndx]);
                    }
                    ++extId2;
                }
                ++descriptorIndx;
            }
            String[] deactivatedExtensions = new String[descriptorList.size()];
            int i = 0;
            while (i < descriptorList.size()) {
                INavigatorContentDescriptor descriptor = (INavigatorContentDescriptor)descriptorList.get(i);
                deactivatedExtensions[i] = descriptor.getId();
                ++i;
            }
            this.setActive(deactivatedExtensions, false);
        }
        if (activatedDescriptors.size() == 0) {
            return NO_DESCRIPTORS;
        }
        return activatedDescriptors.toArray(new NavigatorContentDescriptor[activatedDescriptors.size()]);
    }

    public INavigatorContentDescriptor[] deactivateExtensions(String[] extensionIds, boolean toEnableAllOthers) {
        HashSet<NavigatorContentDescriptor> activatedDescriptors = new HashSet<NavigatorContentDescriptor>();
        this.setActive(extensionIds, false);
        if (toEnableAllOthers) {
            NavigatorContentDescriptor[] descriptors = CONTENT_DESCRIPTOR_REGISTRY.getAllContentDescriptors();
            ArrayList<NavigatorContentDescriptor> descriptorList = new ArrayList<NavigatorContentDescriptor>(Arrays.asList(descriptors));
            int descriptorIndx = 0;
            while (descriptorIndx < descriptors.length) {
                int extId = 0;
                while (extId < extensionIds.length) {
                    if (descriptors[descriptorIndx].getId().equals(extensionIds[extId])) {
                        descriptorList.remove(descriptors[descriptorIndx]);
                    }
                    ++extId;
                }
                ++descriptorIndx;
            }
            String[] activatedExtensions = new String[descriptorList.size()];
            int i = 0;
            while (i < descriptorList.size()) {
                NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)descriptorList.get(i);
                activatedExtensions[i] = descriptor.getId();
                activatedDescriptors.add(descriptor);
                ++i;
            }
            this.setActive(activatedExtensions, true);
        }
        if (activatedDescriptors.size() == 0) {
            return NO_DESCRIPTORS;
        }
        return activatedDescriptors.toArray(new NavigatorContentDescriptor[activatedDescriptors.size()]);
    }
}

