/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.dialogs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDAdapterFactory;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.RootContentEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.typeviz.design.figures.TypeVizFigureFactory;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.wst.xsd.ui.internal.design.editparts.XSDEditPartFactory;
import org.eclipse.wst.xsd.ui.internal.dialogs.IOpenInNewEditor;
import org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.editor.XSDFileEditorInput;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;

public class XSDGraphViewerDialog
extends PopupDialog {
    protected Object model;
    protected ScrollingGraphicalViewer viewer;
    protected IOpenInNewEditor openInNewEditorHelper;
    private OpenEditorLinkListener linkListener;
    private Label nsInfoLabel;
    private Hyperlink link;
    private String infoText;
    private Font infoFont;
    private String uniqueID;
    private PreviewControlListener moveListener;
    private static String X_ORIGIN = "DIALOG_X_ORIGIN";
    private static String Y_ORIGIN = "DIALOG_Y_ORIGIN";

    public XSDGraphViewerDialog(Shell parentShell, String titleText, String infoText, Object model, String ID) {
        super(parentShell, 540680, true, true, true, false, titleText, infoText);
        this.setModel(model);
        this.linkListener = new OpenEditorLinkListener();
        this.infoText = infoText;
        this.uniqueID = ID;
        Assert.isTrue((ID != null && ID.length() > 0 ? 1 : 0) != 0);
        this.moveListener = new PreviewControlListener();
        this.create();
    }

    public void setOpenExternalEditor(IOpenInNewEditor helper) {
        this.openInNewEditorHelper = helper;
    }

    protected void fillDialogMenu(IMenuManager dialogMenu) {
        super.fillDialogMenu(dialogMenu);
        dialogMenu.add((IContributionItem)new Separator());
        dialogMenu.add((IAction)new SetOpenInEditor());
    }

    protected Control createDialogArea(Composite parent) {
        this.viewer = new ScrollingGraphicalViewer();
        Composite c = new Composite(parent, 0);
        c.setBackground(ColorConstants.white);
        c.setLayout((Layout)new FillLayout());
        org.eclipse.wst.xsd.ui.internal.adt.design.editparts.RootEditPart root = new org.eclipse.wst.xsd.ui.internal.adt.design.editparts.RootEditPart();
        this.viewer.setRootEditPart((RootEditPart)root);
        this.viewer.createControl(c);
        this.viewer.getControl().setBackground(ColorConstants.white);
        XSDEditPartFactory editPartFactory = new XSDEditPartFactory(new TypeVizFigureFactory());
        this.viewer.setEditPartFactory((EditPartFactory)editPartFactory);
        RootContentEditPart rootContentEditPart = new RootContentEditPart();
        rootContentEditPart.setModel(this.model);
        this.viewer.setContents((EditPart)rootContentEditPart);
        this.getShell().addControlListener((ControlListener)this.moveListener);
        return c;
    }

    protected Control createInfoTextArea(Composite parent) {
        Composite infoComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        infoComposite.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1808);
        infoComposite.setLayoutData((Object)gd);
        this.nsInfoLabel = new Label(infoComposite, 16384);
        this.nsInfoLabel.setText(this.infoText);
        Font font = this.nsInfoLabel.getFont();
        FontData[] fontDatas = font.getFontData();
        int i = 0;
        while (i < fontDatas.length) {
            fontDatas[i].setHeight(fontDatas[i].getHeight() * 9 / 10);
            ++i;
        }
        this.infoFont = new Font((Device)this.nsInfoLabel.getDisplay(), fontDatas);
        this.nsInfoLabel.setFont(this.infoFont);
        gd = new GridData(802);
        this.nsInfoLabel.setLayoutData((Object)gd);
        this.nsInfoLabel.setForeground(parent.getDisplay().getSystemColor(17));
        this.link = new Hyperlink(infoComposite, 131072);
        this.link.setText(Messages._UI_ACTION_OPEN_IN_NEW_EDITOR);
        this.link.setFont(this.infoFont);
        this.link.addHyperlinkListener((IHyperlinkListener)this.linkListener);
        return infoComposite;
    }

    private void setModel(Object model) {
        Assert.isTrue((boolean)(model instanceof XSDConcreteComponent));
        this.model = XSDAdapterFactory.getInstance().adapt((Notifier)((XSDConcreteComponent)model));
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = XSDEditorPlugin.getDefault().getDialogSettings().getSection(this.uniqueID);
        if (settings == null) {
            settings = XSDEditorPlugin.getDefault().getDialogSettings().addNewSection(this.uniqueID);
        }
        return settings;
    }

    protected Point getInitialLocation(Point initialSize) {
        Point result = super.getInitialLocation(initialSize);
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            try {
                String prefix = this.uniqueID == null ? ((Object)((Object)this)).getClass().getName() : this.uniqueID;
                int x = settings.getInt(String.valueOf(prefix) + X_ORIGIN);
                int y = settings.getInt(String.valueOf(prefix) + Y_ORIGIN);
                result = new Point(x, y);
                Shell parent = this.getParentShell();
                if (parent != null) {
                    Point parentLocation = parent.getLocation();
                    result.x += parentLocation.x;
                    result.y += parentLocation.y;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    protected void saveDialogBounds(Shell shell) {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            Point shellLocation = shell.getLocation();
            Shell parent = this.getParentShell();
            if (parent != null) {
                Point parentLocation = parent.getLocation();
                shellLocation.x -= parentLocation.x;
                shellLocation.y -= parentLocation.y;
            }
            String prefix = this.uniqueID == null ? ((Object)((Object)this)).getClass().getName() : this.uniqueID;
            settings.put(String.valueOf(prefix) + X_ORIGIN, shellLocation.x);
            settings.put(String.valueOf(prefix) + Y_ORIGIN, shellLocation.y);
        }
    }

    public boolean close() {
        this.getShell().removeControlListener((ControlListener)this.moveListener);
        this.link.removeHyperlinkListener((IHyperlinkListener)this.linkListener);
        this.infoFont.dispose();
        this.infoFont = null;
        return super.close();
    }

    public static void openNonXSDResourceSchema(XSDConcreteComponent xsdComponent, XSDSchema schema, String editorName) {
        if (schema != null) {
            IWorkbenchWindow workbenchWindow;
            String schemaLocation = URIHelper.removePlatformResourceProtocol((String)schema.getSchemaLocation());
            Path schemaPath = new Path(schemaLocation);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)schemaPath);
            if (file != null && file.exists() && (workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
                IWorkbenchPage page = workbenchWindow.getActivePage();
                try {
                    IEditorPart editorPart = null;
                    XSDFileEditorInput editorInput = new XSDFileEditorInput(file, schema);
                    editorInput.setEditorName(editorName);
                    IEditorReference[] refs = page.getEditorReferences();
                    int length = refs.length;
                    int i = 0;
                    while (i < length) {
                        IFile aFile;
                        IEditorInput input = refs[i].getEditorInput();
                        if (input instanceof XSDFileEditorInput && (aFile = ((XSDFileEditorInput)input).getFile()).getFullPath().equals((Object)file.getFullPath()) && ((XSDFileEditorInput)input).getSchema() == schema) {
                            editorPart = refs[i].getEditor(true);
                            page.activate(refs[i].getPart(true));
                            break;
                        }
                        ++i;
                    }
                    if (editorPart == null) {
                        editorPart = page.openEditor((IEditorInput)editorInput, "org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor", true, 0);
                    }
                    if (editorPart instanceof InternalXSDMultiPageEditor) {
                        InternalXSDMultiPageEditor xsdEditor = (InternalXSDMultiPageEditor)editorPart;
                        xsdEditor.openOnGlobalReference(xsdComponent);
                    }
                }
                catch (PartInitException partInitException) {}
            }
        }
    }

    public static void openXSDEditor(XSDConcreteComponent xsdComponent) {
        XSDSchema schema = xsdComponent.getSchema();
        if (schema != null) {
            IWorkbenchWindow workbenchWindow;
            String schemaLocation = URIHelper.removePlatformResourceProtocol((String)schema.getSchemaLocation());
            Path schemaPath = new Path(schemaLocation);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)schemaPath);
            if (file != null && file.exists() && (workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
                IWorkbenchPage page = workbenchWindow.getActivePage();
                try {
                    IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    if (editorPart instanceof InternalXSDMultiPageEditor) {
                        InternalXSDMultiPageEditor xsdEditor = (InternalXSDMultiPageEditor)editorPart;
                        xsdEditor.openOnGlobalReference(xsdComponent);
                    }
                }
                catch (PartInitException partInitException) {}
            }
        }
    }

    private final class OpenEditorLinkListener
    implements IHyperlinkListener {
        private OpenEditorLinkListener() {
        }

        public void linkActivated(HyperlinkEvent e) {
            new SetOpenInEditor().run();
            XSDGraphViewerDialog.this.close();
        }

        public void linkEntered(HyperlinkEvent e) {
            XSDGraphViewerDialog.this.link.setForeground(ColorConstants.lightBlue);
        }

        public void linkExited(HyperlinkEvent e) {
            XSDGraphViewerDialog.this.link.setForeground(XSDGraphViewerDialog.this.link.getParent().getForeground());
        }
    }

    protected class PreviewControlListener
    implements ControlListener {
        protected PreviewControlListener() {
        }

        public void controlMoved(ControlEvent e) {
            XSDGraphViewerDialog.this.saveDialogBounds(XSDGraphViewerDialog.this.getShell());
        }

        public void controlResized(ControlEvent e) {
        }
    }

    protected class SetOpenInEditor
    extends Action {
        public SetOpenInEditor() {
            super(Messages._UI_ACTION_OPEN_IN_NEW_EDITOR);
        }

        public void run() {
            if (XSDGraphViewerDialog.this.openInNewEditorHelper != null) {
                try {
                    XSDGraphViewerDialog.this.openInNewEditorHelper.openXSDEditor();
                }
                catch (Exception exception) {}
            }
        }
    }
}

