/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.providers.decorators.impl;

import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.providers.decorators.IColumnDecorationService;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.providers.decorators.impl.AbstractDecorationService;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.icons.ImageDescription;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.preferences.ColumnDecoratorUtil;
import org.eclipse.datatools.connectivity.sqm.core.ui.services.IDataToolsUIServiceManager;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.jface.viewers.IDecoration;

public class ColumnDecorationService
extends AbstractDecorationService
implements IColumnDecorationService {
    private void decorate(Column column, IDecoration decoration) {
        boolean pk = column.isPartOfPrimaryKey();
        boolean fk = column.isPartOfForeignKey();
        boolean nullable = column.isNullable();
        String dataType = IDataToolsUIServiceManager.INSTANCE.getColumnHelperService().getDataType(column);
        if (fk && pk) {
            decoration.addSuffix(ColumnDecoratorUtil.getPKFKColumnDecoration(dataType));
            decoration.addOverlay(ImageDescription.getPKFKDecorationDescriptor());
        } else if (fk && nullable) {
            decoration.addSuffix(ColumnDecoratorUtil.getFKNullableColumnDecoration(dataType));
            decoration.addOverlay(ImageDescription.getFKDecorationDescriptor());
        } else if (fk) {
            decoration.addSuffix(ColumnDecoratorUtil.getFKColumnDecoration(dataType));
            decoration.addOverlay(ImageDescription.getFKDecorationDescriptor());
        } else if (pk) {
            decoration.addSuffix(ColumnDecoratorUtil.getPKColumnDecoration(dataType));
            decoration.addOverlay(ImageDescription.getPKDecorationDescriptor());
        } else if (nullable) {
            decoration.addSuffix(ColumnDecoratorUtil.getNullableColumnDecoration(dataType));
        } else {
            decoration.addSuffix(ColumnDecoratorUtil.getColumnDecoration(dataType));
        }
    }

    public void decorate(Object column, IDecoration decoration) {
        if (column instanceof Column) {
            this.decorate((Column)column, decoration);
        }
    }
}

