/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser.codeDataDB;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.php.internal.core.phpModel.parser.codeDataDB.CodeDataDB;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.util.collections.BucketMap;

public class TreeCodeDataDB
implements CodeDataDB {
    private List cachedList = null;
    private final Set sortedData = new TreeSet();
    private final BucketMap elements = new BucketMap(1000);

    public synchronized void addCodeData(CodeData codeData) {
        this.cachedList = null;
        String string = this.getCodeDataIdentifier(codeData.getName());
        this.elements.add(string, codeData);
        this.sortedData.add(codeData);
    }

    public synchronized List asList() {
        if (this.cachedList != null) {
            return this.cachedList;
        }
        this.cachedList = Arrays.asList(this.sortedData.toArray());
        return this.cachedList;
    }

    public synchronized void clear() {
        this.cachedList = null;
        this.elements.clear();
        this.sortedData.clear();
    }

    public synchronized Collection getCodeData(String string) {
        if (string == null) {
            return null;
        }
        return this.elements.get(this.getCodeDataIdentifier(string));
    }

    private String getCodeDataIdentifier(String string) {
        return string.trim().toLowerCase();
    }

    public synchronized void removeCodeData(CodeData codeData) {
        this.cachedList = null;
        String string = this.getCodeDataIdentifier(codeData.getName());
        this.elements.remove(string, codeData);
        this.sortedData.remove(codeData);
    }
}

