/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser.management;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.php.internal.core.phpModel.parser.IParserClientFactory;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.parser.management.ProjectParsingManager;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.php.internal.core.util.project.observer.IProjectClosedObserver;
import org.eclipse.php.internal.core.util.project.observer.ProjectRemovedObserversAttacher;

public class GlobalParsingManager {
    private static GlobalParsingManager instance;
    private Map project2ParsingManagerMap = new HashMap();

    private GlobalParsingManager() {
    }

    public static GlobalParsingManager getInstance() {
        if (instance == null) {
            instance = new GlobalParsingManager();
        }
        return instance;
    }

    public boolean addParserClient(IParserClientFactory iParserClientFactory, IProject iProject) {
        ProjectParsingManager projectParsingManager = this.getProjectParsingManager(iProject);
        if (projectParsingManager == null) {
            return false;
        }
        projectParsingManager.addParserClient(iParserClientFactory);
        return true;
    }

    public void removeParserClient(IParserClientFactory iParserClientFactory, IProject iProject) {
        Object v = this.project2ParsingManagerMap.get(iProject);
        if (v == null) {
            return;
        }
        ProjectParsingManager projectParsingManager = (ProjectParsingManager)v;
        projectParsingManager.removeParserClient(iParserClientFactory);
    }

    private ProjectParsingManager getProjectParsingManager(IProject iProject) {
        Object v = this.project2ParsingManagerMap.get(iProject);
        if (v == null) {
            ProjectParsingManager projectParsingManager = new ProjectParsingManager(iProject);
            this.project2ParsingManagerMap.put(iProject, projectParsingManager);
            PHPProjectModel pHPProjectModel = null;
            if (iProject != null && !ExternalFilesRegistry.getInstance().getExternalFilesProject().equals((Object)iProject)) {
                this.register2RemoveManagerWhenProjectCloses(iProject);
                pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProject);
            } else {
                pHPProjectModel = PHPWorkspaceModelManager.getDefaultPHPProjectModel();
            }
            if (pHPProjectModel != null) {
                pHPProjectModel.addProjectModelListener(projectParsingManager);
            }
            return projectParsingManager;
        }
        return (ProjectParsingManager)v;
    }

    private void register2RemoveManagerWhenProjectCloses(final IProject iProject) {
        ProjectRemovedObserversAttacher.getInstance().addProjectClosedObserver(iProject, new IProjectClosedObserver(){

            public void closed() {
                ProjectParsingManager projectParsingManager = (ProjectParsingManager)GlobalParsingManager.this.project2ParsingManagerMap.remove(iProject);
                if (projectParsingManager == null) {
                    return;
                }
                projectParsingManager.dispose();
            }
        });
    }
}

