/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project.options.includepath;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.php.core.IIncludePathVariableInitializer;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathVariablesListener;

public class IncludePathVariableManager {
    private static IncludePathVariableManager instance;
    IPreferenceStore preferenceStore = PHPCorePlugin.getDefault().getPreferenceStore();
    HashMap variables = new HashMap();
    HashMap reservedVariables = new HashMap();
    private ArrayList listeners;

    public static IncludePathVariableManager instance() {
        if (instance == null) {
            instance = new IncludePathVariableManager();
        }
        return instance;
    }

    private IncludePathVariableManager() {
    }

    public IPath getIncludePathVariable(String string) {
        return (IPath)this.variables.get(string);
    }

    public void setIncludePathVariables(String[] stringArray, IPath[] iPathArray, SubProgressMonitor subProgressMonitor) {
        this.variables.clear();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (iPathArray[n] != null) {
                this.variables.put(stringArray[n], iPathArray[n]);
                if (n > 0) {
                    stringBuffer.append(",");
                    stringBuffer2.append(",");
                }
                stringBuffer.append(stringArray[n]);
                stringBuffer2.append(iPathArray[n].toOSString());
            }
            ++n;
        }
        this.preferenceStore.setValue("org.eclipse.php.core.includePathVariableNames", stringBuffer.toString());
        this.preferenceStore.setValue("org.eclipse.php.core.includePathVariablePaths", stringBuffer2.toString());
        this.fireIncludePathVariablesChanged(stringArray, iPathArray);
    }

    private void fireIncludePathVariablesChanged(String[] stringArray, IPath[] iPathArray) {
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((IncludePathVariablesListener)iterator.next()).includePathVariablesChanged(stringArray, iPathArray);
        }
    }

    public void addListener(IncludePathVariablesListener includePathVariablesListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(1);
        }
        if (!this.listeners.contains(includePathVariablesListener)) {
            this.listeners.add(includePathVariablesListener);
        }
    }

    public void removeListener(IncludePathVariablesListener includePathVariablesListener) {
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        if (this.listeners.contains(includePathVariablesListener)) {
            this.listeners.remove(includePathVariablesListener);
        }
    }

    public String[] getIncludePathVariableNames() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.variables.keySet());
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void startUp() {
        String string = this.preferenceStore.getString("org.eclipse.php.core.includePathVariableNames");
        String string2 = this.preferenceStore.getString("org.eclipse.php.core.includePathVariablePaths");
        String[] stringArray = new String[]{};
        if (string.length() > 0) {
            stringArray = string.split(",");
        }
        String[] stringArray2 = new String[]{};
        if (string2.length() > 0) {
            stringArray2 = string2.split(",");
        }
        int n = 0;
        while (n < stringArray.length) {
            String string3 = n < stringArray2.length ? stringArray2[n] : "";
            this.variables.put(stringArray[n], new Path(string3));
            ++n;
        }
        this.initExtensionPoints();
    }

    private void initExtensionPoints() {
        PHPCorePlugin pHPCorePlugin = PHPCorePlugin.getDefault();
        if (pHPCorePlugin == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.core", "includePathVariables");
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if ("variable".equals(iConfigurationElement.getName())) {
                String string = iConfigurationElement.getAttribute("name");
                String string2 = iConfigurationElement.getAttribute("value");
                if (iConfigurationElement.getAttribute("initializer") != null) {
                    try {
                        IIncludePathVariableInitializer iIncludePathVariableInitializer = (IIncludePathVariableInitializer)iConfigurationElement.createExecutableExtension("initializer");
                        string2 = iIncludePathVariableInitializer.initialize(string);
                    }
                    catch (CoreException coreException) {
                        PHPCorePlugin.log(coreException);
                    }
                }
                if (string2 != null) {
                    this.putVariable(string, (IPath)new Path(string2));
                    this.reservedVariables.put(string, null);
                }
            }
            ++n;
        }
    }

    public synchronized void putVariable(String string, IPath iPath) {
        this.variables.put(string, iPath);
    }

    public boolean isReserved(String string) {
        return this.reservedVariables.containsKey(string);
    }

    public String[] getReservedVariables() {
        Set set = this.reservedVariables.keySet();
        return set.toArray(new String[set.size()]);
    }
}

