/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.base.catalog;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.sybase.asa.baseloaders.GroupASALoader;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SybaseASACatalogUtils;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.impl.SybaseASABaseGroupImpl;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Group;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASACatalogBaseGroup
extends SybaseASABaseGroupImpl
implements ICatalogObject {
    private static final long serialVersionUID = -9099341886539383531L;
    protected Boolean groupMemberLoaded = Boolean.FALSE;
    protected Boolean privilegesLoaded = Boolean.FALSE;
    protected Boolean ownedSchemaLoaded = Boolean.FALSE;
    protected Boolean userInfoLoaded = Boolean.FALSE;
    private SoftReference groupLoaderRef;
    private Database database;

    public SybaseASACatalogBaseGroup(ICatalogObject catalogDatabase) {
        this.database = catalogDatabase.getCatalogDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.groupMemberLoaded;
        synchronized (bl) {
            if (this.groupMemberLoaded.booleanValue()) {
                this.groupMemberLoaded = Boolean.FALSE;
            }
        }
        bl = this.privilegesLoaded;
        synchronized (bl) {
            if (this.privilegesLoaded.booleanValue()) {
                this.privilegesLoaded = Boolean.FALSE;
            }
        }
        bl = this.ownedSchemaLoaded;
        synchronized (bl) {
            if (this.ownedSchemaLoaded.booleanValue()) {
                this.ownedSchemaLoaded = Boolean.FALSE;
            }
        }
        bl = this.userInfoLoaded;
        synchronized (bl) {
            if (this.userInfoLoaded.booleanValue()) {
                this.userInfoLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 13: {
                this.getUser();
                break;
            }
            case 12: {
                this.getReceivedPrivilege();
                break;
            }
            case 3: {
                this.getDescription();
                break;
            }
            case 7: {
                this.getOwnedSchema();
            }
        }
        return super.eIsSet(eFeature);
    }

    public Database getCatalogDatabase() {
        return this.database;
    }

    public Connection getConnection() {
        return ((ICatalogObject)this.database).getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getUser() {
        Boolean bl = this.groupMemberLoaded;
        synchronized (bl) {
            if (!this.groupMemberLoaded.booleanValue()) {
                this.getGroupLoader().loadGroupUsers((List)super.getUser());
                this.groupMemberLoaded = Boolean.TRUE;
            }
        }
        return super.getUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getReceivedPrivilege() {
        Boolean bl = this.privilegesLoaded;
        synchronized (bl) {
            if (!this.privilegesLoaded.booleanValue()) {
                this.getGroupLoader().loadPrivilegs(super.getReceivedPrivilege());
                this.privilegesLoaded = Boolean.TRUE;
            }
        }
        return super.getReceivedPrivilege();
    }

    private GroupASALoader getGroupLoader() {
        GroupASALoader loader;
        GroupASALoader groupASALoader = loader = this.groupLoaderRef == null ? null : (GroupASALoader)this.groupLoaderRef.get();
        if (loader == null) {
            loader = this.createGroupLoader();
            this.groupLoaderRef = new SoftReference<GroupASALoader>(loader);
        }
        return loader;
    }

    protected GroupASALoader createGroupLoader() {
        return new GroupASALoader((Group)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getOwnedSchema() {
        Boolean bl = this.ownedSchemaLoaded;
        synchronized (bl) {
            if (!this.ownedSchemaLoaded.booleanValue()) {
                EList ownedSchemas = super.getOwnedSchema();
                ownedSchemas.clear();
                Schema schema = (Schema)SybaseASACatalogUtils.findElement((Collection)this.database.getSchemas(), this.getName());
                ownedSchemas.add((Object)schema);
                this.ownedSchemaLoaded = Boolean.TRUE;
            }
        }
        return super.getOwnedSchema();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription() {
        Boolean bl = this.userInfoLoaded;
        synchronized (bl) {
            if (!this.userInfoLoaded.booleanValue()) {
                this.getGroupLoader().loadAuthInfo();
                this.userInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getDescription();
    }
}

