/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.transport;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Hashtable;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.wst.ws.internal.explorer.platform.util.XMLUtils;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.transport.ChunkedInputStream;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.transport.HTTPResponse;
import org.eclipse.wst.ws.internal.explorer.transport.HTTPTransportException;
import org.w3c.dom.Element;
import sun.misc.BASE64Encoder;

public class HTTPTransport {
    private final String SYS_PROP_HTTPS_PROXY_HOST = "https.proxyHost";
    private final String SYS_PROP_HTTPS_PROXY_PORT = "https.proxyPort";
    private final String SYS_PROP_HTTPS_NON_PROXY_HOSTS = "https.nonProxyHosts";
    private final String SYS_PROP_HTTP_PROXY_HOST = "http.proxyHost";
    private final String SYS_PROP_HTTP_PROXY_PORT = "http.proxyPort";
    private final String SYS_PROP_HTTP_PROXY_USER_NAME = "http.proxyUserName";
    private final String SYS_PROP_HTTP_PROXY_PASSWORD = "http.proxyPassword";
    private final String SYS_PROP_HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    private final String HTTP_METHOD = "POST";
    private final String HTTP_CONNECT = "CONNECT";
    private final String HTTP_VERSION_1_0 = "HTTP/1.0";
    private final String HTTP_VERSION = "HTTP/1.1";
    private final String HTTP_HEADER_SOAP_ACTION = "SOAPAction";
    public static final String HTTP_HEADER_AUTH = "Authorization";
    public static final String HTTP_HEADER_WWW_AUTH = "WWW-Authenticate";
    private final String HTTP_HEADER_PROXY_AUTH = "Proxy-authorization";
    private final String HTTP_HEADER_COOKIE = "Cookie";
    private final String HTTP_HEADER_COOKIE2 = "Cookie2";
    private final String HTTP_HEADER_HOST = "Host";
    private final String HTTP_HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HTTP_HEADER_CONTENT_LENGTH = "Content-Length";
    private final String HTTP_HEADER_ACCEPT = "Accept";
    private final String HTTP_HEADER_USER_AGENT = "User-Agent";
    private final String HTTP_HEADER_CACHE_CONTROL = "Cache-Control";
    private final String HTTP_HEADER_PRAGMA = "Pragma";
    private final String HTTP_HEADER_TRANSFER_ENCODEING = "Transfer-Encoding";
    private final String HTTP_HEADER_CONNECTION = "Connection";
    private final int HTTP_CODE_CONTINUE = 100;
    private final int HTTP_CODE_OK = 200;
    private final int HTTP_CODE_EXCEPTION = 300;
    private final String IBM_WEB_SERVICES_EXPLORER = "IBM Web Services Explorer";
    private final String TEXT_XML = "text/xml";
    private final String CONTENT_TYPE_VALUE = "text/xml; charset=utf-8";
    private final String ACCEPT_VALUE = "application/soap+xml, application/dime, multipart/related, text/*";
    public static final String BASIC = "Basic";
    private final String NO_CACHE = "no-cache";
    private final String CHUNKED = "chunked";
    private final String CLOSE = "close";
    private final String HTTPS = "https";
    private final char QUOTE = (char)34;
    public static final char COLON = ':';
    private final char SPACE = (char)32;
    private final char TAB = (char)9;
    private final char R = (char)13;
    private final char N = (char)10;
    private final char ROOT = (char)47;
    private final String NEW_LINE = "\r\n";
    private final String EMPTY_STRING = "";
    private final int DEFAULT_HTTP_PORT = 80;
    private final int DEFAULT_HTTPS_PORT = 443;
    private final String DEFAULT_SOAP_ENCODING = "UTF-8";
    private final String DEFAULT_HTTP_HEADER_ENCODING = "iso-8859-1";
    private final boolean DEFAULT_CASE_SENSITIVE_FOR_HOST_NAME = false;
    private String httpBasicAuthUsername;
    private String httpBasicAuthPassword;
    private boolean maintainSession = false;
    private String cookie;
    private String cookie2;
    private HTTPResponse httpResponse;

    public String getHttpBasicAuthUsername() {
        return this.httpBasicAuthUsername;
    }

    public void setHttpBasicAuthUsername(String httpBasicAuthUsername) {
        this.httpBasicAuthUsername = httpBasicAuthUsername;
    }

    public String getHttpBasicAuthPassword() {
        return this.httpBasicAuthPassword;
    }

    public void setHttpBasicAuthPassword(String httpBasicAuthPassword) {
        this.httpBasicAuthPassword = httpBasicAuthPassword;
    }

    private String getMethod(URL url) {
        StringBuffer sb = new StringBuffer("POST");
        sb.append(' ');
        String protocol = url.getProtocol();
        String httpProxyHost = System.getProperty("http.proxyHost");
        String httpsProxyHost = System.getProperty("https.proxyHost");
        if (protocol.equalsIgnoreCase("http") && httpProxyHost != null && httpProxyHost.length() > 0) {
            sb.append(url.toString());
        } else if (protocol.equalsIgnoreCase("https") && httpsProxyHost != null && httpsProxyHost.length() > 0) {
            sb.append(url.toString());
        } else {
            String file = url.getFile();
            if (file != null && file.length() > 0) {
                sb.append(file);
            } else {
                sb.append('/');
            }
        }
        sb.append(' ');
        sb.append("HTTP/1.1");
        sb.append("\r\n");
        return sb.toString();
    }

    private String getHost(URL url) {
        StringBuffer sb = new StringBuffer("Host");
        sb.append(':');
        sb.append(' ');
        sb.append(url.getHost());
        sb.append(':');
        int port = url.getPort();
        if (port > 0) {
            sb.append(String.valueOf(port));
        } else if (url.getProtocol().equalsIgnoreCase("https")) {
            sb.append(443);
        } else {
            sb.append(80);
        }
        sb.append("\r\n");
        return sb.toString();
    }

    private String getContentType() {
        return this.getHTTPHeader("Content-Type", "text/xml; charset=utf-8");
    }

    private String getContentLength(byte[] payloadAsBytes) {
        return this.getHTTPHeader(HTTP_HEADER_CONTENT_LENGTH, String.valueOf(payloadAsBytes.length));
    }

    private String getSOAPAction(String soapAction) {
        StringBuffer sb = new StringBuffer("SOAPAction");
        sb.append(':');
        sb.append(' ');
        sb.append('\"');
        if (soapAction != null) {
            sb.append(soapAction);
        }
        sb.append('\"');
        sb.append("\r\n");
        return sb.toString();
    }

    private String getCookie() {
        if (this.maintainSession) {
            return this.getHTTPHeader("Cookie", this.cookie);
        }
        return "";
    }

    private String getCookie2() {
        if (this.maintainSession) {
            return this.getHTTPHeader("Cookie2", this.cookie2);
        }
        return "";
    }

    private String getWWWAuthentication() {
        if (this.httpBasicAuthUsername != null && this.httpBasicAuthPassword != null) {
            StringBuffer sb = new StringBuffer(this.httpBasicAuthUsername);
            sb.append(':');
            sb.append(this.httpBasicAuthPassword);
            BASE64Encoder encoder = new BASE64Encoder();
            String encodedUserNamePassword = encoder.encode(sb.toString().getBytes());
            sb.setLength(0);
            sb.append(HTTP_HEADER_AUTH);
            sb.append(':');
            sb.append(' ');
            sb.append(BASIC);
            sb.append(' ');
            sb.append(encodedUserNamePassword);
            sb.append("\r\n");
            return sb.toString();
        }
        return "";
    }

    private String getProxyAuthentication() {
        String proxyUserName = System.getProperty("http.proxyUserName");
        String proxyPassword = System.getProperty("http.proxyPassword");
        if (proxyUserName != null && proxyPassword != null) {
            StringBuffer sb = new StringBuffer(proxyUserName);
            sb.append(':');
            sb.append(proxyPassword);
            BASE64Encoder encoder = new BASE64Encoder();
            String encodedUserNamePassword = encoder.encode(sb.toString().getBytes());
            sb.setLength(0);
            sb.append("Proxy-authorization");
            sb.append(':');
            sb.append(' ');
            sb.append(BASIC);
            sb.append(' ');
            sb.append(encodedUserNamePassword);
            sb.append("\r\n");
            return sb.toString();
        }
        return "";
    }

    private String getAccept() {
        return this.getHTTPHeader("Accept", "application/soap+xml, application/dime, multipart/related, text/*");
    }

    private String getUserAgent() {
        return this.getHTTPHeader("User-Agent", "IBM Web Services Explorer");
    }

    private String getCacheControl() {
        return this.getHTTPHeader("Cache-Control", "no-cache");
    }

    private String getPragma() {
        return this.getHTTPHeader("Pragma", "no-cache");
    }

    private String getConnection() {
        return this.getHTTPHeader("Connection", "close");
    }

    private String getHTTPHeader(String key, String value) {
        if (value != null) {
            StringBuffer sb = new StringBuffer(key);
            sb.append(':');
            sb.append(' ');
            sb.append(value);
            sb.append("\r\n");
            return sb.toString();
        }
        return "";
    }

    public void send(URL url, String soapAction, String payload) throws UnknownHostException, IOException {
        byte[] payloadAsUTF8 = payload.getBytes("UTF-8");
        StringBuffer httpHeader = new StringBuffer();
        httpHeader.append(this.getMethod(url));
        httpHeader.append(this.getHost(url));
        httpHeader.append(this.getContentType());
        httpHeader.append(this.getContentLength(payloadAsUTF8));
        httpHeader.append(this.getAccept());
        httpHeader.append(this.getUserAgent());
        httpHeader.append(this.getCacheControl());
        httpHeader.append(this.getPragma());
        httpHeader.append(this.getSOAPAction(soapAction));
        httpHeader.append(this.getWWWAuthentication());
        httpHeader.append(this.getProxyAuthentication());
        httpHeader.append(this.getCookie());
        httpHeader.append(this.getCookie2());
        httpHeader.append(this.getConnection());
        httpHeader.append("\r\n");
        Socket socket = this.buildSocket(url);
        InputStream is = socket.getInputStream();
        OutputStream os = socket.getOutputStream();
        os.write(httpHeader.toString().getBytes("iso-8859-1"));
        os.write(payloadAsUTF8);
        os.flush();
        this.httpResponse = new HTTPResponse();
        this.readHTTPResponseHeader(is, this.httpResponse);
        int code = this.httpResponse.getStatusCode();
        if (code == 100) {
            this.httpResponse.reset();
            this.readHTTPResponseHeader(is, this.httpResponse);
        }
        this.readHTTPResponsePayload(is, this.httpResponse);
        os.close();
        is.close();
        socket.close();
        code = this.httpResponse.getStatusCode();
        String contentType = this.httpResponse.getHeader("Content-Type".toLowerCase());
        if (code >= 300 && (contentType == null || contentType.toLowerCase().indexOf("text/xml".toLowerCase()) == -1)) {
            throw new HTTPTransportException(code, this.httpResponse.getStatusMessage(), this.httpResponse.getHeaders());
        }
    }

    private void readHTTPResponseHeader(InputStream is, HTTPResponse resp) throws IOException {
        int b = 0;
        int len = 0;
        int colonIndex = -1;
        boolean readTooMuch = false;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        while (true) {
            String value;
            String key;
            if (!readTooMuch) {
                b = (byte)is.read();
            }
            if (b == -1) break;
            readTooMuch = false;
            if (b != 13 && b != 10) {
                if (b == 58 && colonIndex == -1) {
                    colonIndex = len;
                }
                ++len;
                baos.write(b);
                continue;
            }
            if (b == 13) continue;
            if (len == 0) break;
            b = (byte)is.read();
            readTooMuch = true;
            if (b == 32 || b == 9) continue;
            baos.close();
            byte[] bArray = baos.toByteArray();
            baos.reset();
            if (colonIndex != -1) {
                key = new String(bArray, 0, colonIndex, "iso-8859-1");
                value = new String(bArray, colonIndex + 1, len - 1 - colonIndex, "iso-8859-1");
                colonIndex = -1;
            } else {
                key = new String(bArray, 0, len, "iso-8859-1");
                value = "";
            }
            if (!resp.isStatusSet()) {
                int start = key.indexOf(32) + 1;
                String s = key.substring(start).trim();
                int end = s.indexOf(32);
                if (end != -1) {
                    s = s.substring(0, end);
                }
                try {
                    resp.setStatusCode(Integer.parseInt(s));
                }
                catch (NumberFormatException numberFormatException) {
                    resp.setStatusCode(-1);
                }
                resp.setStatusMessage(key.substring(start + end + 1));
            } else {
                resp.addHeader(key.toLowerCase().trim(), value.trim());
            }
            len = 0;
        }
        baos.close();
    }

    private void readHTTPResponsePayload(InputStream is, HTTPResponse resp) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte b = (byte)is.read();
            while (b != -1) {
                baos.write(b);
                b = (byte)is.read();
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {}
        baos.close();
        resp.setPayload(baos.toByteArray());
    }

    byte[] receiveBytes() throws IOException {
        if (this.httpResponse != null) {
            byte[] payload = this.httpResponse.getPayload();
            if ("chunked".equalsIgnoreCase(this.httpResponse.getHeader("Transfer-Encoding".toLowerCase()))) {
                byte b;
                ByteArrayInputStream bais = new ByteArrayInputStream(payload);
                ChunkedInputStream cis = new ChunkedInputStream(bais);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while ((b = (byte)cis.read()) != -1) {
                    baos.write(b);
                }
                baos.close();
                cis.close();
                bais.close();
                return baos.toByteArray();
            }
            return payload;
        }
        return null;
    }

    public BufferedReader receive() {
        try {
            Element soapEnvelope;
            byte[] payload = this.receiveBytes();
            if (payload != null && (soapEnvelope = XMLUtils.byteArrayToElement(payload, false)) != null) {
                return new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(XMLUtils.serialize(soapEnvelope, true).getBytes("UTF-8")), "UTF-8"));
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    public Hashtable getHeaders() {
        Hashtable headers = new Hashtable();
        if (this.httpResponse != null) {
            headers.putAll(this.httpResponse.getHeaders());
        }
        return headers;
    }

    private StringBuffer getConnectMethod(URL url) {
        StringBuffer sb = new StringBuffer("CONNECT");
        sb.append(' ');
        sb.append(url.getHost());
        sb.append(':');
        sb.append(url.getPort());
        sb.append(' ');
        sb.append("HTTP/1.0");
        sb.append("\r\n");
        return sb;
    }

    private Socket buildTunnelSocket(URL url, String proxyHost, int proxyPort) throws IOException {
        StringBuffer httpHeader = new StringBuffer();
        httpHeader.append(this.getConnectMethod(url));
        httpHeader.append(this.getProxyAuthentication());
        httpHeader.append("\r\n");
        Socket tunnel = new Socket(proxyHost, proxyPort);
        InputStream is = tunnel.getInputStream();
        OutputStream os = tunnel.getOutputStream();
        os.write(httpHeader.toString().getBytes("iso-8859-1"));
        os.flush();
        HTTPResponse httpResponse = new HTTPResponse();
        this.readHTTPResponseHeader(is, httpResponse);
        int code = httpResponse.getStatusCode();
        if (code != 200) {
            throw new HTTPTransportException(code, httpResponse.getStatusMessage(), httpResponse.getHeaders());
        }
        return tunnel;
    }

    private Socket buildSocket(URL url) throws UnknownHostException, IOException {
        Socket s = null;
        String host = url.getHost();
        int port = url.getPort();
        String proxyHost = System.getProperty("http.proxyHost");
        int proxyPort = Integer.getInteger("http.proxyPort", 80);
        String nonProxyHosts = System.getProperty("http.nonProxyHosts");
        if (url.getProtocol().equalsIgnoreCase("https")) {
            proxyHost = System.getProperty("https.proxyHost");
            proxyPort = Integer.getInteger("https.proxyPort", 443);
            nonProxyHosts = System.getProperty("https.nonProxyHosts");
            if (proxyHost != null && proxyHost.length() > 0 && !this.isHostInNonProxyHosts(host, nonProxyHosts, false)) {
                Socket tunnel = this.buildTunnelSocket(url, proxyHost, proxyPort);
                s = ((SSLSocketFactory)SSLSocketFactory.getDefault()).createSocket(tunnel, host, port, true);
            } else {
                s = SSLSocketFactory.getDefault().createSocket(host, port > 0 ? port : 443);
            }
        } else {
            s = proxyHost != null && proxyHost.length() > 0 && !this.isHostInNonProxyHosts(host, nonProxyHosts, false) ? new Socket(proxyHost, proxyPort) : new Socket(host, port > 0 ? port : 80);
        }
        return s;
    }

    private boolean isHostInNonProxyHosts(String host, String nonProxyHosts, boolean caseSensitive) {
        if (caseSensitive) {
            return host.matches(this.createPatternFromString(nonProxyHosts));
        }
        return host.toLowerCase().matches(this.createPatternFromString(nonProxyHosts.toLowerCase()));
    }

    private String createPatternFromString(String str) {
        return str == null ? null : str.replaceAll("\\.", "\\.").replaceAll("\\*", "\\w*");
    }
}

