/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.util.manifest;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;

class Relationship {
    static final String ELEMENT_NAME = "relationship";
    static final String RELATED_ID_ATTRIBUTE_NAME = "relatedId";
    static final String TYPE_ATTRIBUTE_NAME = "type";
    static final int TYPE_REPLACED_BY_CODE = 1;
    static final String[] sm_typeValues = new String[]{"none", "replacedBy"};
    private int m_type;
    private String m_relatedId;

    static Relationship createInstance(IConfigurationElement relationshipParentElement) {
        Relationship anInstance = new Relationship();
        try {
            anInstance.init(relationshipParentElement);
        }
        catch (OdaException e) {
            return null;
        }
        return anInstance;
    }

    private Relationship() {
    }

    private void init(IConfigurationElement parentElement) throws OdaException {
        if (parentElement == null) {
            throw new OdaException();
        }
        IConfigurationElement[] elements = parentElement.getChildren(ELEMENT_NAME);
        if (elements.length < 1) {
            throw new OdaException();
        }
        IConfigurationElement relationshipElement = elements[0];
        this.m_relatedId = relationshipElement.getAttribute(RELATED_ID_ATTRIBUTE_NAME);
        if (this.m_relatedId == null || this.m_relatedId.length() == 0) {
            throw new OdaException(Messages.bind((String)Messages.manifest_NO_ATTRIBUTE_ID_DEFINED, (Object)RELATED_ID_ATTRIBUTE_NAME, (Object)ELEMENT_NAME));
        }
        this.setRelationshipType(relationshipElement.getAttribute(TYPE_ATTRIBUTE_NAME));
    }

    private void setRelationshipType(String typeAttributeValue) throws OdaException {
        if (typeAttributeValue == null || typeAttributeValue.length() == 0) {
            throw new OdaException();
        }
        for (int i = 1; i < sm_typeValues.length; ++i) {
            if (!typeAttributeValue.equalsIgnoreCase(sm_typeValues[i])) continue;
            this.m_type = i;
            return;
        }
        throw new OdaException();
    }

    boolean isDeprecated() {
        return this.m_type == 1;
    }

    String getRelatedId() {
        return this.m_relatedId;
    }
}

