/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.project.facet;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestDataModelProvider;
import org.eclipse.jst.j2ee.internal.common.operations.NewJavaClassDataModelProvider;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.jee.project.facet.JEEFacetInstallDelegate;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class AppClientFacetPostInstallDelegate
extends JEEFacetInstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            try {
                IDataModel model = (IDataModel)config;
                ComponentCore.createComponent((IProject)project);
                if (model.getBooleanProperty("IAppClientComponentCreationDataModelProperties.CREATE_DEFAULT_MAIN_CLASS")) {
                    this.addMainClass(monitor, model, project);
                }
                String earProjectName = (String)model.getProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME");
                if (model.getBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR") && earProjectName != null && !earProjectName.equals("")) {
                    String ver;
                    String j2eeVersionText = ver = fv.getVersionString();
                    this.installEARFacet(j2eeVersionText, earProjectName, (IRuntime)model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME"), monitor);
                    String moduleURI = model.getStringProperty("IJ2EEModuleFacetInstallDataModelProperties.MODULE_URI");
                    this.installAndAddModuletoEAR(j2eeVersionText, earProjectName, (IRuntime)model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME"), project, moduleURI, monitor);
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
            }
            catch (Exception e) {
                Logger.getLogger().logError((Throwable)e);
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void addMainClass(IProgressMonitor monitor, IDataModel model, IProject project) {
        try {
            IDataModel mainClassDataModel = DataModelFactory.createDataModel(NewJavaClassDataModelProvider.class);
            mainClassDataModel.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)project.getName());
            mainClassDataModel.setProperty("NewJavaClassDataModel.CLASS_NAME", (Object)"Main");
            mainClassDataModel.setBooleanProperty("NewJavaClassDataModel.MAIN_METHOD", true);
            IContainer container = J2EEProjectUtilities.getSourceFolderOrFirst((IProject)project, null);
            if (container != null) {
                String projRelativeSourcePath = String.valueOf('/') + project.getName() + '/' + container.getName();
                mainClassDataModel.setProperty("NewJavaClassDataModel.SOURCE_FOLDER", (Object)projRelativeSourcePath);
                mainClassDataModel.getDefaultOperation().execute(monitor, null);
                this.createManifestEntryForMainClass(monitor, model, project);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void createManifestEntryForMainClass(IProgressMonitor monitor, IDataModel model, IProject project) throws CoreException, InvocationTargetException, InterruptedException {
        IVirtualComponent appClientComponent = ComponentCore.createComponent((IProject)project);
        IVirtualFile vf = appClientComponent.getRootFolder().getFile((IPath)new Path("META-INF/MANIFEST.MF"));
        IFile manifestmf = vf.getUnderlyingFile();
        if (manifestmf == null || !manifestmf.exists()) {
            try {
                this.createManifest(project, appClientComponent.getRootFolder().getUnderlyingFolder(), monitor);
            }
            catch (Exception e) {
                Logger.getLogger().logError((Throwable)e);
            }
            String manifestFolder = String.valueOf('/') + model.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER") + '/' + "META-INF";
            IFolder container = project.getFolder(manifestFolder);
            manifestmf = container.getFile((IPath)new Path("MANIFEST.MF"));
        }
        if (model.getBooleanProperty("IAppClientComponentCreationDataModelProperties.CREATE_DEFAULT_MAIN_CLASS")) {
            IDataModel dm = DataModelFactory.createDataModel(UpdateManifestDataModelProvider.class);
            dm.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)project.getName());
            dm.setBooleanProperty("UpdateManifestDataModel.MERGE", false);
            dm.setProperty("UpdateManifestDataModel.MANIFEST_FILE", (Object)manifestmf);
            dm.setProperty("UpdateManifestDataModel.MAIN_CLASS", (Object)"Main");
            try {
                dm.getDefaultOperation().execute(monitor, null);
            }
            catch (Exception exception) {}
        }
    }

    protected void installAndAddModuletoEAR(String versionText, String earProjectName, IRuntime runtime, IProject moduleProject, String moduleURI, IProgressMonitor monitor) {
        this.installEARFacet(versionText, earProjectName, runtime, monitor);
    }
}

