/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.scripting;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryService;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringDescriptorDeleteQuery;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryEditHelper;
import org.eclipse.ltk.internal.ui.refactoring.history.ShowRefactoringHistoryControl;
import org.eclipse.ltk.internal.ui.refactoring.scripting.ScriptingMessages;
import org.eclipse.ltk.internal.ui.refactoring.scripting.ShowRefactoringHistoryWizard;
import org.eclipse.ltk.internal.ui.refactoring.util.PixelConverter;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class ShowRefactoringHistoryWizardPage
extends WizardPage {
    private static final String PAGE_NAME = "ShowRefactoringHistoryWizardPage";
    private static final String SETTING_SORT = "org.eclipse.ltk.ui.refactoring.sortRefactorings";
    private ShowRefactoringHistoryControl fHistoryControl = null;
    private final ShowRefactoringHistoryWizard fWizard;

    public ShowRefactoringHistoryWizardPage(ShowRefactoringHistoryWizard wizard) {
        super(PAGE_NAME);
        Assert.isNotNull((Object)((Object)wizard));
        this.fWizard = wizard;
        this.setTitle(ScriptingMessages.ShowRefactoringHistoryWizard_caption);
        this.setDescription(ScriptingMessages.ShowRefactoringHistoryWizard_description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        RefactoringHistoryControlConfiguration configuration = new RefactoringHistoryControlConfiguration(null, true, false){

            public final String getWorkspaceCaption() {
                return ScriptingMessages.ShowRefactoringHistoryWizard_workspace_caption;
            }
        };
        this.fHistoryControl = new ShowRefactoringHistoryControl(composite, configuration){

            protected void createBottomButtonBar(Composite control) {
                Assert.isNotNull((Object)control);
                Composite container = new Composite(control, 0);
                GridLayout grid = new GridLayout(1, false);
                grid.marginWidth = 0;
                grid.marginHeight = 0;
                container.setLayout((Layout)grid);
                GridData data = new GridData();
                data.grabExcessHorizontalSpace = true;
                data.grabExcessVerticalSpace = false;
                data.horizontalAlignment = 4;
                data.verticalAlignment = 128;
                container.setLayoutData((Object)data);
                this.createDeleteButton(container, 3);
            }

            protected void createDeleteAllButton(Composite control) {
            }

            protected void createEditButton(Composite control) {
            }

            protected void createRightButtonBar(Composite control) {
                Composite container = new Composite(control, 0);
                container.setLayout((Layout)new GridLayout(1, false));
            }

            protected int getContainerColumns() {
                return 1;
            }
        };
        this.fHistoryControl.createControl();
        boolean sortProjects = true;
        IDialogSettings settings = this.fWizard.getDialogSettings();
        if (settings != null) {
            sortProjects = settings.getBoolean(SETTING_SORT);
        }
        if (sortProjects) {
            this.fHistoryControl.sortByProjects();
        } else {
            this.fHistoryControl.sortByDate();
        }
        this.fHistoryControl.setInput(this.fWizard.getRefactoringHistory());
        GridData data = new GridData(1808);
        data.heightHint = new PixelConverter((Control)parent).convertHeightInCharsToPixels(24);
        this.fHistoryControl.setLayoutData(data);
        this.fHistoryControl.getDeleteButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                RefactoringDescriptorProxy[] selection = ShowRefactoringHistoryWizardPage.this.fHistoryControl.getCheckedDescriptors();
                if (selection.length > 0) {
                    Shell shell = ShowRefactoringHistoryWizardPage.this.getShell();
                    ProgressMonitorDialog context = new ProgressMonitorDialog(shell);
                    RefactoringHistoryEditHelper.promptRefactoringDelete(shell, (IRunnableContext)context, ShowRefactoringHistoryWizardPage.this.fHistoryControl, new RefactoringDescriptorDeleteQuery(shell, null, selection.length), new RefactoringHistoryEditHelper.IRefactoringHistoryProvider(this){
                        final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public RefactoringHistory getRefactoringHistory(IProgressMonitor monitor) {
                            return RefactoringHistoryService.getInstance().getWorkspaceHistory(monitor);
                        }
                    }, selection);
                }
            }
        });
        Button button = this.fHistoryControl.getEditButton();
        if (button != null) {
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public final void widgetSelected(SelectionEvent event) {
                    RefactoringDescriptorProxy[] selection = ShowRefactoringHistoryWizardPage.this.fHistoryControl.getSelectedDescriptors();
                    if (selection.length > 0) {
                        RefactoringHistoryEditHelper.promptRefactoringDetails((IRunnableContext)ShowRefactoringHistoryWizardPage.this.getContainer(), ShowRefactoringHistoryWizardPage.this.fHistoryControl, selection[0]);
                    }
                }
            });
        }
        this.setPageComplete(false);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.refactoring_show_history_page");
    }

    public boolean isPageComplete() {
        return true;
    }

    public void performFinish() {
        IDialogSettings settings = this.fWizard.getDialogSettings();
        if (settings != null) {
            settings.put(SETTING_SORT, this.fHistoryControl.isSortByProjects());
        }
    }
}

