/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.actions.BuildUtilities;

public class BuildAction
extends WorkspaceAction {
    public static final String ID_BUILD = "org.eclipse.ui.BuildAction";
    public static final String ID_REBUILD_ALL = "org.eclipse.ui.RebuildAllAction";
    private int buildType;
    private List projectsToBuild = null;

    public BuildAction(Shell shell, int n) {
        super(shell, "");
        if (n == 10) {
            this.setText(IDEWorkbenchMessages.BuildAction_text);
            this.setToolTipText(IDEWorkbenchMessages.BuildAction_toolTip);
            this.setId(ID_BUILD);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.incremental_build_action_context");
        } else {
            this.setText(IDEWorkbenchMessages.RebuildAction_text);
            this.setToolTipText(IDEWorkbenchMessages.RebuildAction_tooltip);
            this.setId(ID_REBUILD_ALL);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.full_build_action_context");
        }
        this.buildType = n;
    }

    private void addAllProjects(IProject iProject, HashSet hashSet) {
        if (iProject == null || !iProject.isAccessible() || hashSet.contains(iProject)) {
            return;
        }
        hashSet.add(iProject);
        try {
            IProject[] iProjectArray = iProject.getReferencedProjects();
            int n = 0;
            while (n < iProjectArray.length) {
                this.addAllProjects(iProjectArray[n], hashSet);
                ++n;
            }
        }
        catch (CoreException coreException) {}
    }

    protected List getActionResources() {
        return this.getProjectsToBuild();
    }

    protected String getOperationMessage() {
        return IDEWorkbenchMessages.BuildAction_operationMessage;
    }

    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.BuildAction_problemMessage;
    }

    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.BuildAction_problemTitle;
    }

    List getProjectsToBuild() {
        if (this.projectsToBuild == null) {
            this.projectsToBuild = new ArrayList(3);
            for (IResource iResource : this.getSelectedResources()) {
                IProject iProject = iResource.getProject();
                if (iProject == null || this.projectsToBuild.contains(iProject) || !this.hasBuilder(iProject)) continue;
                this.projectsToBuild.add(iProject);
            }
        }
        return this.projectsToBuild;
    }

    boolean hasBuilder(IProject iProject) {
        try {
            ICommand[] iCommandArray = iProject.getDescription().getBuildSpec();
            if (iCommandArray.length > 0) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    protected void invokeOperation(IResource iResource, IProgressMonitor iProgressMonitor) throws CoreException {
        ((IProject)iResource).build(this.buildType, iProgressMonitor);
    }

    public boolean isEnabled() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            this.selectionChanged((IStructuredSelection)new StructuredSelection((Object[])BuildUtilities.findSelectedProjects((IWorkbenchWindow)iWorkbenchWindow)));
        }
        return super.isEnabled();
    }

    public static boolean isSaveAllSet() {
        IPreferenceStore iPreferenceStore = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getBoolean("SAVE_ALL_BEFORE_BUILD");
    }

    List pruneResources(List list) {
        HashSet hashSet = new HashSet();
        String[] stringArray = list.iterator();
        while (stringArray.hasNext()) {
            this.addAllProjects((IProject)stringArray.next(), hashSet);
        }
        if (hashSet.size() < 2) {
            return list;
        }
        stringArray = ResourcesPlugin.getWorkspace().getDescription().getBuildOrder();
        if (stringArray != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>(hashSet.size());
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            int n = 0;
            while (n < stringArray.length) {
                IProject iProject = iWorkspaceRoot.getProject(stringArray[n]);
                if (hashSet.contains(iProject)) {
                    arrayList.add(iProject);
                    hashSet.remove(iProject);
                }
                ++n;
            }
            arrayList.addAll(hashSet);
            return arrayList;
        }
        IProject[] iProjectArray = new IProject[hashSet.size()];
        iProjectArray = hashSet.toArray(iProjectArray);
        IWorkspace.ProjectOrder projectOrder = ResourcesPlugin.getWorkspace().computeProjectOrder(iProjectArray);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(Arrays.asList(projectOrder.projects));
        return arrayList;
    }

    public void run() {
        List list = this.getProjectsToBuild();
        if (list == null || list.isEmpty()) {
            return;
        }
        BuildUtilities.saveEditors((Collection)list);
        this.runInBackground(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule(), ResourcesPlugin.FAMILY_MANUAL_BUILD);
    }

    protected boolean shouldPerformResourcePruning() {
        return true;
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        this.projectsToBuild = null;
        IProject[] iProjectArray = this.getProjectsToBuild().toArray(new IProject[0]);
        return BuildUtilities.isEnabled((IProject[])iProjectArray, (int)10);
    }
}

