/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.ui.autoEdit.CaseDefaultAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.CurlyCloseAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.CurlyOpenAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.DocBlockAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.IndentLineAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.MatchingBracketAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.QuotesAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.TabAutoEditStrategy;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class MainAutoEditStrategy
implements IAutoEditStrategy {
    private static IAutoEditStrategy indentLineAutoEditStrategy = new IndentLineAutoEditStrategy();
    private static IAutoEditStrategy curlyOpenAutoEditStrategy = new CurlyOpenAutoEditStrategy();
    private static IAutoEditStrategy curlyCloseAutoEditStrategy = new CurlyCloseAutoEditStrategy();
    private static IAutoEditStrategy matchingBracketAutoEditStrategy = new MatchingBracketAutoEditStrategy();
    private static IAutoEditStrategy quotesAutoEditStrategy = new QuotesAutoEditStrategy();
    private static IAutoEditStrategy caseDefaultAutoEditStrategy = new CaseDefaultAutoEditStrategy();
    private static IAutoEditStrategy docBlockAutoEditStrategy = new DocBlockAutoEditStrategy();
    private static IAutoEditStrategy tabAutoEditStrategy = new TabAutoEditStrategy();

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.text == null) {
            return;
        }
        String string = FormatterUtils.getPartitionType((IStructuredDocument)((IStructuredDocument)iDocument), (int)documentCommand.offset);
        if (string.equals("org.eclipse.php.PHP_DOC") || string.equals("org.eclipse.php.PHP_MULTI_LINE_COMMENT")) {
            docBlockAutoEditStrategy.customizeDocumentCommand(iDocument, documentCommand);
        } else if (string.equals("org.eclipse.php.PHP_QUOTED_STRING")) {
            quotesAutoEditStrategy.customizeDocumentCommand(iDocument, documentCommand);
        } else if (string.equals("org.eclipse.php.PHP_DEFAULT") || string.equals("org.eclipse.php.PHP_SINGLE_LINE_COMMENT")) {
            caseDefaultAutoEditStrategy.customizeDocumentCommand(iDocument, documentCommand);
            matchingBracketAutoEditStrategy.customizeDocumentCommand(iDocument, documentCommand);
            curlyOpenAutoEditStrategy.customizeDocumentCommand(iDocument, documentCommand);
            curlyCloseAutoEditStrategy.customizeDocumentCommand(iDocument, documentCommand);
            indentLineAutoEditStrategy.customizeDocumentCommand(iDocument, documentCommand);
            tabAutoEditStrategy.customizeDocumentCommand(iDocument, documentCommand);
            quotesAutoEditStrategy.customizeDocumentCommand(iDocument, documentCommand);
        }
    }
}

