/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.WorkspaceRunnableAdapter;
import org.eclipse.php.internal.ui.wizards.FragmentedWizardPage;
import org.eclipse.php.internal.ui.wizards.WizardFragment;
import org.eclipse.php.internal.ui.wizards.WizardModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FragmentedWizard
implements IWizard {
    private static final byte FINISH = 2;
    private static final byte CANCEL = 3;
    private List pages;
    private boolean addingPages;
    private Map fragmentData = new HashMap();
    protected WizardModel wizardModel;
    private IWizardContainer container = null;
    private boolean needsProgressMonitor = false;
    private boolean forcePreviousAndNextButtons = false;
    private boolean isHelpAvailable = false;
    private Image defaultImage = null;
    private RGB titleBarColor = null;
    private String windowTitle = null;
    private IDialogSettings dialogSettings = null;
    private WizardFragment rootFragment;
    private WizardFragment currentFragment;

    public FragmentedWizard(String string, WizardFragment wizardFragment) {
        this(string, wizardFragment, null);
        this.setWindowTitle(string);
    }

    public FragmentedWizard(String string, WizardFragment wizardFragment, WizardModel wizardModel) {
        if (string != null) {
            this.setWindowTitle(string);
        }
        this.rootFragment = wizardFragment;
        this.wizardModel = wizardModel;
        if (wizardModel == null) {
            this.wizardModel = new WizardModel();
        }
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
    }

    public void setWizardModel(WizardModel wizardModel) {
        this.wizardModel = wizardModel;
    }

    public WizardModel getWizardModel() {
        return this.wizardModel;
    }

    public void setRootFragment(WizardFragment wizardFragment) {
        this.rootFragment = wizardFragment;
    }

    public WizardFragment getRootFragment() {
        return this.rootFragment;
    }

    public boolean performCancel() {
        final List list = this.getAllWizardFragments();
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        FragmentedWizard.this.executeTask((WizardFragment)iterator.next(), (byte)3, iProgressMonitor);
                    }
                }
                catch (CoreException coreException) {
                    throw new InvocationTargetException(coreException);
                }
            }
        };
        Throwable throwable = null;
        try {
            if (this.getContainer() != null) {
                this.getContainer().run(true, true, iRunnableWithProgress);
            } else {
                iRunnableWithProgress.run((IProgressMonitor)new NullProgressMonitor());
            }
            return true;
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException.getCause();
        }
        catch (Exception exception) {
            throwable = exception;
        }
        PHPUiPlugin.log((IStatus)new Status(4, "org.eclipse.php.ui", 0, "Error cancelling task wizard", throwable));
        if (throwable instanceof CoreException) {
            FragmentedWizard.openError(throwable.getLocalizedMessage(), ((CoreException)throwable).getStatus());
        } else {
            FragmentedWizard.openError(throwable.getLocalizedMessage());
        }
        return false;
    }

    private static void openError(final String string) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)string);
            }
        });
    }

    private static void openError(final String string, final IStatus iStatus) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                ErrorDialog.openError((Shell)shell, (String)"Error", (String)string, (IStatus)iStatus);
            }
        });
    }

    public boolean performFinish() {
        if (this.currentFragment != null) {
            this.currentFragment.exit();
        }
        final WizardFragment wizardFragment = this.currentFragment;
        final List list = this.getAllWizardFragments();
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                Object object;
                int n = list.indexOf(wizardFragment);
                while (n > 0 && n < list.size() - 1) {
                    object = (WizardFragment)list.get(++n);
                    try {
                        Display.getDefault().syncExec(new Runnable((WizardFragment)object){
                            private final /* synthetic */ WizardFragment val$fragment;
                            {
                                this.val$fragment = wizardFragment;
                            }

                            public void run() {
                                this.val$fragment.enter();
                                this.val$fragment.exit();
                            }
                        });
                    }
                    catch (Exception exception) {
                        PHPUiPlugin.log((IStatus)new Status(4, "org.eclipse.php.ui", 0, "Could not enter/exit page", (Throwable)exception));
                    }
                }
                if (FragmentedWizard.this.useJob()) {
                    class FinishWizardJob
                    extends Job {
                        private final /* synthetic */ List val$list;

                        public FinishWizardJob(List list) {
                            this.val$list = list;
                            super(FragmentedWizard.this.getJobTitle());
                        }

                        public boolean belongsTo(Object object) {
                            return "org.eclipse.wst.server.ui.family".equals(object);
                        }

                        public IStatus run(IProgressMonitor iProgressMonitor) {
                            try {
                                Iterator iterator = this.val$list.iterator();
                                while (iterator.hasNext()) {
                                    FragmentedWizard.this.executeTask((WizardFragment)iterator.next(), (byte)2, iProgressMonitor);
                                }
                            }
                            catch (CoreException coreException) {
                                Status status = new Status(4, "org.eclipse.php.ui", 0, coreException.getLocalizedMessage(), null);
                                PHPUiPlugin.log((IStatus)status);
                                return status;
                            }
                            return Status.OK_STATUS;
                        }
                    }
                    object = new FinishWizardJob(list);
                    object.setUser(true);
                    object.schedule();
                } else {
                    object = list.iterator();
                    while (object.hasNext()) {
                        FragmentedWizard.this.executeTask((WizardFragment)object.next(), (byte)2, iProgressMonitor);
                    }
                }
            }
        };
        Throwable throwable = null;
        try {
            if (this.getContainer() != null) {
                this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceRunnableAdapter(iWorkspaceRunnable));
            } else {
                iWorkspaceRunnable.run((IProgressMonitor)new NullProgressMonitor());
            }
            return true;
        }
        catch (InvocationTargetException invocationTargetException) {
            PHPUiPlugin.log((IStatus)new Status(4, "org.eclipse.php.ui", 0, "Error finishing task wizard", (Throwable)invocationTargetException));
            throwable = invocationTargetException.getCause();
        }
        catch (Exception exception) {
            PHPUiPlugin.log((IStatus)new Status(4, "org.eclipse.php.ui", 0, "Error finishing task wizard 2", (Throwable)exception));
            throwable = exception;
        }
        if (throwable instanceof CoreException) {
            FragmentedWizard.openError(throwable.getLocalizedMessage(), ((CoreException)throwable).getStatus());
        } else if (throwable instanceof NullPointerException) {
            FragmentedWizard.openError("NullPointerException");
        } else {
            FragmentedWizard.openError(throwable.getLocalizedMessage());
        }
        return false;
    }

    public void addPage(IWizardPage iWizardPage) {
        this.pages.add(iWizardPage);
        iWizardPage.setWizard((IWizard)this);
    }

    protected void executeTask(WizardFragment wizardFragment, byte by, IProgressMonitor iProgressMonitor) throws CoreException {
        if (wizardFragment == null) {
            return;
        }
        if (by == 2) {
            wizardFragment.performFinish(iProgressMonitor);
        } else if (by == 3) {
            wizardFragment.performCancel(iProgressMonitor);
        }
    }

    protected WizardFragment getCurrentWizardFragment() {
        return this.currentFragment;
    }

    protected void switchWizardFragment(WizardFragment wizardFragment) {
        int n;
        List list = this.getAllWizardFragments();
        int n2 = list.indexOf(this.currentFragment);
        if (n2 == (n = list.indexOf(wizardFragment))) {
            return;
        }
        if (this.currentFragment != null) {
            this.currentFragment.exit();
        }
        n2 = n2 < n ? ++n2 : --n2;
        while (n2 != n) {
            WizardFragment wizardFragment2 = (WizardFragment)list.get(n2);
            wizardFragment2.enter();
            wizardFragment2.exit();
            if (n2 < n) {
                ++n2;
                continue;
            }
            --n2;
        }
        this.currentFragment = wizardFragment;
        this.currentFragment.enter();
    }

    private List getAllWizardFragments() {
        ArrayList<WizardFragment> arrayList = new ArrayList<WizardFragment>();
        arrayList.add(this.rootFragment);
        this.addSubWizardFragments(this.rootFragment, arrayList);
        for (WizardFragment wizardFragment : arrayList) {
            if (this.wizardModel.equals(wizardFragment.getWizardModel())) continue;
            wizardFragment.setWizardModel(this.wizardModel);
        }
        return arrayList;
    }

    private void addSubWizardFragments(WizardFragment wizardFragment, List list) {
        for (WizardFragment wizardFragment2 : wizardFragment.getChildFragments()) {
            list.add(wizardFragment2);
            this.addSubWizardFragments(wizardFragment2, list);
        }
    }

    public void addPages() {
        if (this.addingPages) {
            return;
        }
        try {
            try {
                this.addingPages = true;
                this.pages = new ArrayList();
                for (WizardFragment wizardFragment : this.getAllWizardFragments()) {
                    FragmentedWizardPage fragmentedWizardPage = this.getFragmentData(wizardFragment);
                    if (!wizardFragment.hasComposite()) continue;
                    if (fragmentedWizardPage != null) {
                        this.addPage((IWizardPage)fragmentedWizardPage);
                        continue;
                    }
                    FragmentedWizardPage fragmentedWizardPage2 = new FragmentedWizardPage(wizardFragment);
                    this.fragmentData.put(wizardFragment, fragmentedWizardPage2);
                    this.addPage((IWizardPage)fragmentedWizardPage2);
                }
            }
            catch (Exception exception) {
                PHPUiPlugin.log((IStatus)new Status(4, "org.eclipse.php.ui", 0, "Error adding fragments to wizard", (Throwable)exception));
                this.addingPages = false;
            }
        }
        finally {
            this.addingPages = false;
        }
    }

    private FragmentedWizardPage getFragmentData(WizardFragment wizardFragment) {
        try {
            FragmentedWizardPage fragmentedWizardPage = (FragmentedWizardPage)this.fragmentData.get(wizardFragment);
            if (fragmentedWizardPage != null) {
                return fragmentedWizardPage;
            }
        }
        catch (Exception exception) {
            PHPUiPlugin.log((IStatus)new Status(4, "org.eclipse.php.ui", 0, "Error getting fragment data", (Throwable)exception));
        }
        return null;
    }

    protected void updatePages() {
        this.addPages();
    }

    public boolean canFinish() {
        int n = 0;
        while (n < this.pages.size()) {
            if (!((IWizardPage)this.pages.get(n)).isPageComplete()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void createPageControls(Composite composite) {
        int n = 0;
        while (n < this.pages.size()) {
            IWizardPage iWizardPage = (IWizardPage)this.pages.get(n);
            iWizardPage.createControl(composite);
            ++n;
        }
    }

    public void dispose() {
        int n = 0;
        while (n < this.pages.size()) {
            ((IWizardPage)this.pages.get(n)).dispose();
            ++n;
        }
        if (this.defaultImage != null) {
            this.defaultImage.dispose();
            this.defaultImage = null;
        }
    }

    public IWizardContainer getContainer() {
        return this.container;
    }

    public Image getDefaultPageImage() {
        return this.defaultImage;
    }

    public IDialogSettings getDialogSettings() {
        return this.dialogSettings;
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        int n = this.pages.indexOf(iWizardPage);
        if (n == this.pages.size() - 1 || n == -1) {
            return null;
        }
        return (IWizardPage)this.pages.get(n + 1);
    }

    public IWizardPage getPage(String string) {
        int n = 0;
        while (n < this.pages.size()) {
            IWizardPage iWizardPage = (IWizardPage)this.pages.get(n);
            String string2 = iWizardPage.getName();
            if (string2.equals(string)) {
                return iWizardPage;
            }
            ++n;
        }
        return null;
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public IWizardPage[] getPages() {
        return this.pages.toArray(new IWizardPage[this.pages.size()]);
    }

    public IWizardPage getPreviousPage(IWizardPage iWizardPage) {
        int n = this.pages.indexOf(iWizardPage);
        if (n == 0 || n == -1) {
            return null;
        }
        return (IWizardPage)this.pages.get(n - 1);
    }

    public IWizardPage getStartingPage() {
        if (this.pages.size() == 0) {
            return null;
        }
        return (IWizardPage)this.pages.get(0);
    }

    public RGB getTitleBarColor() {
        return this.titleBarColor;
    }

    public String getWindowTitle() {
        return this.windowTitle;
    }

    public boolean isHelpAvailable() {
        return this.isHelpAvailable;
    }

    public boolean needsPreviousAndNextButtons() {
        return this.forcePreviousAndNextButtons || this.pages.size() > 1;
    }

    public boolean needsProgressMonitor() {
        return this.needsProgressMonitor;
    }

    public void setContainer(IWizardContainer iWizardContainer) {
        this.container = iWizardContainer;
    }

    public void setDialogSettings(IDialogSettings iDialogSettings) {
        this.dialogSettings = iDialogSettings;
    }

    public void setNeedsProgressMonitor(boolean bl) {
        this.needsProgressMonitor = bl;
    }

    public void setForcePreviousAndNextButtons(boolean bl) {
        this.forcePreviousAndNextButtons = bl;
    }

    public void setWindowTitle(String string) {
        this.windowTitle = string;
    }

    protected boolean useJob() {
        return false;
    }

    protected String getJobTitle() {
        return this.getWindowTitle();
    }
}

