/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.workingset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.ModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;

public class PHPWorkingSetUpdater
implements IWorkingSetUpdater,
ModelListener {
    public static final String ID = "org.eclipse.php.ui.workingset.PHPWorkingSetPage";
    private List fWorkingSets = new ArrayList();
    static final int ADD = 1;
    static final int CHANGE = 2;
    static final int REMOVE = 3;

    public PHPWorkingSetUpdater() {
        PHPWorkspaceModelManager.getInstance().addModelListener((ModelListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IWorkingSet iWorkingSet) {
        this.checkElementExistence(iWorkingSet);
        List list = this.fWorkingSets;
        synchronized (list) {
            this.fWorkingSets.add(iWorkingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(IWorkingSet iWorkingSet) {
        boolean bl;
        List list = this.fWorkingSets;
        synchronized (list) {
            bl = this.fWorkingSets.remove(iWorkingSet);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(IWorkingSet iWorkingSet) {
        List list = this.fWorkingSets;
        synchronized (list) {
            return this.fWorkingSets.contains(iWorkingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List list = this.fWorkingSets;
        synchronized (list) {
            this.fWorkingSets.clear();
        }
        PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void elementChanged(PHPFileData pHPFileData, int n) {
        IWorkingSet[] iWorkingSetArray;
        List list = this.fWorkingSets;
        synchronized (list) {
            iWorkingSetArray = this.fWorkingSets.toArray(new IWorkingSet[this.fWorkingSets.size()]);
        }
        int n2 = 0;
        while (n2 < iWorkingSetArray.length) {
            WorkingSetDelta workingSetDelta = new WorkingSetDelta(iWorkingSetArray[n2]);
            this.processPHPChange(workingSetDelta, pHPFileData, n);
            workingSetDelta.process();
            ++n2;
        }
    }

    private void processPHPChange(WorkingSetDelta workingSetDelta, PHPFileData pHPFileData, int n) {
        int n2 = workingSetDelta.indexOf(pHPFileData);
        if (n2 != -1 && n == 3) {
            workingSetDelta.remove(n2);
        }
    }

    private void processResourceDelta(WorkingSetDelta workingSetDelta, IResourceDelta iResourceDelta) {
        IResource iResource = iResourceDelta.getResource();
        int n = iResource.getType();
        int n2 = workingSetDelta.indexOf(iResource);
        int n3 = iResourceDelta.getKind();
        int n4 = iResourceDelta.getFlags();
        if (n3 == 4 && n == 4 && n2 != -1 && (n4 & 0x4000) != 0) {
            workingSetDelta.set(n2, iResource);
        }
        if (n2 != -1 && n3 == 2) {
            if ((n4 & 0x2000) != 0) {
                workingSetDelta.set(n2, ResourcesPlugin.getWorkspace().getRoot().findMember(iResourceDelta.getMovedToPath()));
            } else {
                workingSetDelta.remove(n2);
            }
        }
        IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
        int n5 = 0;
        while (n5 < iResourceDeltaArray.length) {
            this.processResourceDelta(workingSetDelta, iResourceDeltaArray[n5]);
            ++n5;
        }
    }

    private void checkElementExistence(IWorkingSet iWorkingSet) {
        ArrayList arrayList = new ArrayList(Arrays.asList(iWorkingSet.getElements()));
        boolean bl = false;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            IResource iResource;
            PHPCodeData pHPCodeData;
            IAdaptable iAdaptable = (IAdaptable)iterator.next();
            boolean bl2 = false;
            if (iAdaptable instanceof PHPCodeData) {
                pHPCodeData = (PHPCodeData)iAdaptable;
                iResource = PHPModelUtil.getResource((Object)pHPCodeData);
                IProject iProject = iResource.getProject();
                bl2 = (iProject == null || iProject.isOpen()) && !iResource.exists();
            } else if (iAdaptable instanceof IResource) {
                pHPCodeData = (IResource)iAdaptable;
                iResource = pHPCodeData.getProject();
                boolean bl3 = bl2 = (iResource == null || iResource.isOpen()) && !pHPCodeData.exists();
            }
            if (!bl2) continue;
            iterator.remove();
            bl = true;
        }
        if (bl) {
            iWorkingSet.setElements(arrayList.toArray(new IAdaptable[arrayList.size()]));
        }
    }

    public void fileDataChanged(PHPFileData pHPFileData) {
        this.elementChanged(pHPFileData, 2);
    }

    public void fileDataAdded(PHPFileData pHPFileData) {
        this.elementChanged(pHPFileData, 1);
    }

    public void fileDataRemoved(PHPFileData pHPFileData) {
        this.elementChanged(pHPFileData, 3);
    }

    public void dataCleared() {
    }

    private static class WorkingSetDelta {
        private IWorkingSet fWorkingSet;
        private List fElements;
        private boolean fChanged;

        public WorkingSetDelta(IWorkingSet iWorkingSet) {
            this.fWorkingSet = iWorkingSet;
            this.fElements = new ArrayList(Arrays.asList(iWorkingSet.getElements()));
        }

        public int indexOf(Object object) {
            return this.fElements.indexOf(object);
        }

        public void set(int n, Object object) {
            this.fElements.set(n, object);
            this.fChanged = true;
        }

        public void remove(int n) {
            if (this.fElements.remove(n) != null) {
                this.fChanged = true;
            }
        }

        public void process() {
            if (this.fChanged) {
                this.fWorkingSet.setElements(this.fElements.toArray(new IAdaptable[this.fElements.size()]));
            }
        }
    }
}

