/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.core.internal.JpaEObject;
import org.eclipse.jpt.core.internal.mappings.IAssociationOverride;
import org.eclipse.jpt.core.internal.mappings.IAttributeOverride;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.IJoinColumn;
import org.eclipse.jpt.core.internal.mappings.IOverride;
import org.eclipse.jpt.ui.internal.details.BaseJpaComposite;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.ColumnComposite;
import org.eclipse.jpt.ui.internal.mappings.details.JoinColumnInAssociationOverrideDialog;
import org.eclipse.jpt.ui.internal.mappings.details.JoinColumnsComposite;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class OverridesComposite
extends BaseJpaComposite {
    private ListViewer listViewer;
    private IEntity entity;
    private Adapter entityListener = this.buildEntityListener();
    private IOverride selectedOverride;
    private Adapter overrideListener = this.buildOverrideListener();
    protected PageBook overridePageBook;
    protected ColumnComposite columnComposite;
    protected JoinColumnsComposite joinColumnsComposite;
    private Button overrideDefaultButton;

    public OverridesComposite(Composite parent, CommandStack commandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, 0, commandStack, widgetFactory);
    }

    private Adapter buildEntityListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                OverridesComposite.this.entityChanged(notification);
            }
        };
    }

    private Adapter buildOverrideListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                OverridesComposite.this.overrideChanged(notification);
            }
        };
    }

    protected void initializeLayout(Composite composite) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Group attributeOverridesGroup = this.getWidgetFactory().createGroup(composite, JptUiMappingsMessages.AttributeOverridesComposite_attributeOverrides);
        attributeOverridesGroup.setLayout((Layout)new GridLayout(2, true));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        attributeOverridesGroup.setLayoutData((Object)gridData);
        this.listViewer = this.buildAttributeOverridesListViewer((Composite)attributeOverridesGroup);
        gridData = new GridData();
        gridData.verticalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.listViewer.getList().setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.listViewer.getList(), "org.eclipse.jpt.ui.entity_attributeOverrides");
        this.overrideDefaultButton = this.getWidgetFactory().createButton((Composite)attributeOverridesGroup, JptUiMappingsMessages.AttributeOverridesComposite_overridDefault, 32);
        this.overrideDefaultButton.addSelectionListener(this.buildOverrideDefaultSelectionListener());
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.overrideDefaultButton.setLayoutData((Object)gridData);
        this.overridePageBook = this.buildOverridePageBook((Composite)attributeOverridesGroup);
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.overridePageBook.setLayoutData((Object)gridData);
        this.joinColumnsComposite = new JoinColumnsComposite((Composite)this.overridePageBook, this.commandStack, this.getWidgetFactory(), JptUiMappingsMessages.OverridesComposite_joinColumn);
        this.columnComposite = new ColumnComposite((Composite)this.overridePageBook, this.commandStack, this.getWidgetFactory());
        this.overridePageBook.showPage(this.joinColumnsComposite.getControl());
    }

    protected PageBook buildOverridePageBook(Composite parent) {
        return new PageBook(parent, 0);
    }

    private SelectionListener buildOverrideDefaultSelectionListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                OverridesComposite.this.overrideDefaultButtonSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                OverridesComposite.this.overrideDefaultButtonSelected(e);
            }
        };
    }

    private void overrideDefaultButtonSelected(SelectionEvent e) {
        boolean selection = this.overrideDefaultButton.getSelection();
        if (selection) {
            if (this.getSelectedOverride() instanceof IAttributeOverride) {
                int index = this.entity.getSpecifiedAttributeOverrides().size();
                IAttributeOverride attributeOverride = this.entity.createAttributeOverride(index);
                this.entity.getSpecifiedAttributeOverrides().add((Object)attributeOverride);
                attributeOverride.setName(this.selectedOverride.getName());
                attributeOverride.getColumn().setSpecifiedName(((IAttributeOverride)this.selectedOverride).getColumn().getName());
            } else {
                int index = this.entity.getSpecifiedAssociationOverrides().size();
                IAssociationOverride associationOverride = this.entity.createAssociationOverride(index);
                String name = this.selectedOverride.getName();
                this.entity.getSpecifiedAssociationOverrides().add((Object)associationOverride);
                associationOverride.setName(name);
            }
        } else if (this.getSelectedOverride() instanceof IAttributeOverride) {
            this.entity.getSpecifiedAttributeOverrides().remove((Object)this.selectedOverride);
        } else {
            this.entity.getSpecifiedAssociationOverrides().remove((Object)this.selectedOverride);
        }
    }

    private ListViewer buildAttributeOverridesListViewer(Composite parent) {
        ListViewer listViewer = new ListViewer(parent, 2052);
        listViewer.setLabelProvider((IBaseLabelProvider)this.buildAttributeOverridesLabelProvider());
        listViewer.setContentProvider(this.buildAttributeOverridesContentProvider());
        listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                OverridesComposite.this.overridesListSelectionChanged(event);
            }
        });
        return listViewer;
    }

    protected void overridesListSelectionChanged(SelectionChangedEvent event) {
        if (((StructuredSelection)event.getSelection()).isEmpty()) {
            this.columnComposite.populate(null);
            this.columnComposite.enableWidgets(false);
            this.overrideDefaultButton.setSelection(false);
            this.overrideDefaultButton.setEnabled(false);
        } else {
            this.selectedOverride = this.getSelectedOverride();
            if (this.selectedOverride instanceof IAttributeOverride) {
                boolean specifiedOverride = this.entity.getSpecifiedAttributeOverrides().contains((Object)this.selectedOverride);
                this.overrideDefaultButton.setSelection(specifiedOverride);
                this.overridePageBook.showPage(this.columnComposite.getControl());
                this.columnComposite.populate((EObject)((IAttributeOverride)this.selectedOverride).getColumn());
                this.columnComposite.enableWidgets(specifiedOverride);
                this.overrideDefaultButton.setEnabled(true);
            } else {
                boolean specifiedOverride = this.entity.getSpecifiedAssociationOverrides().contains((Object)this.selectedOverride);
                this.overrideDefaultButton.setSelection(specifiedOverride);
                this.overridePageBook.showPage(this.joinColumnsComposite.getControl());
                this.joinColumnsComposite.populate((EObject)new JoinColumnsOwner((IAssociationOverride)this.getSelectedOverride()));
                this.joinColumnsComposite.enableWidgets(specifiedOverride);
                this.overrideDefaultButton.setEnabled(true);
            }
        }
    }

    private ILabelProvider buildAttributeOverridesLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                return ((IOverride)element).getName();
            }
        };
    }

    private IContentProvider buildAttributeOverridesContentProvider() {
        return new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                IEntity entity = (IEntity)inputElement;
                return CollectionTools.addAll((Object[])((IOverride[])entity.getAttributeOverrides().toArray((Object[])new IOverride[entity.getAttributeOverrides().size()])), (Collection)entity.getAssociationOverrides());
            }
        };
    }

    private IOverride getSelectedOverride() {
        return (IOverride)((StructuredSelection)this.listViewer.getSelection()).getFirstElement();
    }

    public void doPopulate(EObject obj) {
        this.entity = (IEntity)obj;
        if (this.entity == null) {
            this.selectedOverride = null;
            this.columnComposite.populate(null);
            this.joinColumnsComposite.populate(null);
            this.listViewer.setInput(null);
            return;
        }
        if (this.listViewer.getInput() != this.entity) {
            this.listViewer.setInput((Object)this.entity);
        }
        if (!this.entity.getAttributeOverrides().isEmpty()) {
            if (this.listViewer.getSelection().isEmpty()) {
                IOverride override = (IOverride)this.entity.getAttributeOverrides().get(0);
                this.listViewer.setSelection((ISelection)new StructuredSelection((Object)override));
            } else {
                Object selection = ((StructuredSelection)this.listViewer.getSelection()).getFirstElement();
                if (selection instanceof IAttributeOverride) {
                    this.overridePageBook.showPage(this.columnComposite.getControl());
                    this.columnComposite.enableWidgets(true);
                    this.columnComposite.populate((EObject)((IAttributeOverride)selection).getColumn());
                } else {
                    this.overridePageBook.showPage(this.joinColumnsComposite.getControl());
                    this.joinColumnsComposite.enableWidgets(true);
                    this.joinColumnsComposite.populate((EObject)new JoinColumnsOwner((IAssociationOverride)selection));
                }
            }
        } else {
            this.columnComposite.populate(null);
            this.columnComposite.enableWidgets(false);
        }
    }

    protected void doPopulate() {
        this.columnComposite.doPopulate();
        this.joinColumnsComposite.doPopulate();
    }

    protected void engageListeners() {
        if (this.entity != null) {
            this.entity.eAdapters().add((Object)this.entityListener);
            for (IOverride attributeOverride : this.entity.getAttributeOverrides()) {
                attributeOverride.eAdapters().add((Object)this.overrideListener);
            }
            for (IOverride attributeOverride : this.entity.getAssociationOverrides()) {
                attributeOverride.eAdapters().add((Object)this.overrideListener);
            }
        }
    }

    protected void disengageListeners() {
        if (this.entity != null) {
            this.entity.eAdapters().remove((Object)this.entityListener);
            for (IOverride attributeOverride : this.entity.getAttributeOverrides()) {
                attributeOverride.eAdapters().remove((Object)this.overrideListener);
            }
            for (IOverride attributeOverride : this.entity.getAssociationOverrides()) {
                attributeOverride.eAdapters().remove((Object)this.overrideListener);
            }
        }
    }

    protected void entityChanged(Notification notification) {
        switch (notification.getFeatureID(IEntity.class)) {
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (OverridesComposite.this.listViewer.getList().isDisposed()) {
                            return;
                        }
                        OverridesComposite.this.listViewer.refresh();
                    }
                });
                if (notification.getEventType() == 3) {
                    ((IOverride)notification.getNewValue()).eAdapters().add((Object)this.overrideListener);
                    final Object newValue = notification.getNewValue();
                    ((IOverride)newValue).eAdapters().add((Object)this.overrideListener);
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            if (OverridesComposite.this.listViewer.getList().isDisposed()) {
                                return;
                            }
                            OverridesComposite.this.listViewer.setSelection((ISelection)new StructuredSelection(newValue));
                        }
                    });
                    break;
                }
                if (notification.getEventType() == 5) {
                    List addedList = (List)notification.getNewValue();
                    for (IOverride override : addedList) {
                        override.eAdapters().add((Object)this.overrideListener);
                    }
                } else {
                    if (notification.getEventType() == 4) {
                        ((IOverride)notification.getOldValue()).eAdapters().remove((Object)this.overrideListener);
                        break;
                    }
                    if (notification.getEventType() != 6) break;
                    List removedList = (List)notification.getOldValue();
                    for (IOverride override : removedList) {
                        override.eAdapters().remove((Object)this.overrideListener);
                    }
                }
                break;
            }
        }
    }

    protected void overrideChanged(Notification notification) {
        switch (notification.getFeatureID(IOverride.class)) {
            case 0: {
                final IOverride override = (IOverride)notification.getNotifier();
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        OverridesComposite.this.listViewer.update((Object)override, null);
                    }
                });
                break;
            }
        }
    }

    public void dispose() {
        this.columnComposite.dispose();
        this.joinColumnsComposite.dispose();
        super.dispose();
    }

    void addJoinColumn() {
        JoinColumnInAssociationOverrideDialog dialog = new JoinColumnInAssociationOverrideDialog(this.getControl().getShell(), (IAssociationOverride)this.getSelectedOverride());
        this.addJoinColumnFromDialog(dialog);
    }

    private void addJoinColumnFromDialog(JoinColumnInAssociationOverrideDialog dialog) {
        if (dialog.open() != 0) {
            return;
        }
        int index = ((IAssociationOverride)this.getSelectedOverride()).getJoinColumns().size();
        IJoinColumn joinColumn = ((IAssociationOverride)this.getSelectedOverride()).createJoinColumn(index);
        ((IAssociationOverride)this.getSelectedOverride()).getSpecifiedJoinColumns().add((Object)joinColumn);
        joinColumn.setSpecifiedName(dialog.getSelectedName());
        joinColumn.setSpecifiedReferencedColumnName(dialog.getReferencedColumnName());
    }

    void editJoinColumn(IJoinColumn joinColumn) {
        JoinColumnInAssociationOverrideDialog dialog = new JoinColumnInAssociationOverrideDialog(this.getControl().getShell(), joinColumn);
        this.editJoinColumnFromDialog(dialog, joinColumn);
    }

    private void editJoinColumnFromDialog(JoinColumnInAssociationOverrideDialog dialog, IJoinColumn joinColumn) {
        if (dialog.open() == 0) {
            this.editJoinColumnDialogOkd(dialog, joinColumn);
        }
    }

    private void editJoinColumnDialogOkd(JoinColumnInAssociationOverrideDialog dialog, IJoinColumn joinColumn) {
        String name = dialog.getSelectedName();
        String referencedColumnName = dialog.getReferencedColumnName();
        if (dialog.isDefaultNameSelected()) {
            if (joinColumn.getSpecifiedName() != null) {
                joinColumn.setSpecifiedName(null);
            }
        } else if (joinColumn.getSpecifiedName() == null || !joinColumn.getSpecifiedName().equals(name)) {
            joinColumn.setSpecifiedName(name);
        }
        if (dialog.isDefaultReferencedColumnNameSelected()) {
            if (joinColumn.getSpecifiedReferencedColumnName() != null) {
                joinColumn.setSpecifiedReferencedColumnName(null);
            }
        } else if (joinColumn.getSpecifiedReferencedColumnName() == null || !joinColumn.getSpecifiedReferencedColumnName().equals(referencedColumnName)) {
            joinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JoinColumnsOwner
    extends JpaEObject
    implements JoinColumnsComposite.Owner {
        IAssociationOverride associationOverride;

        public JoinColumnsOwner(IAssociationOverride associationOverride) {
            this.associationOverride = associationOverride;
        }

        @Override
        public void addJoinColumn() {
            OverridesComposite.this.addJoinColumn();
        }

        @Override
        public boolean containsSpecifiedJoinColumns() {
            return this.associationOverride.containsSpecifiedJoinColumns();
        }

        @Override
        public IJoinColumn createJoinColumn(int index) {
            return this.associationOverride.createJoinColumn(index);
        }

        @Override
        public List<IJoinColumn> getJoinColumns() {
            return this.associationOverride.getJoinColumns();
        }

        @Override
        public List<IJoinColumn> getSpecifiedJoinColumns() {
            return this.associationOverride.getSpecifiedJoinColumns();
        }

        @Override
        public int specifiedJoinColumnsFeatureId() {
            return 2;
        }

        @Override
        public Class owningFeatureClass() {
            return IAssociationOverride.class;
        }

        @Override
        public void editJoinColumn(IJoinColumn joinColumn) {
            OverridesComposite.this.editJoinColumn(joinColumn);
        }

        @Override
        public EObject getEObject() {
            return this.associationOverride;
        }
    }
}

