/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.ui.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatWebModule;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServerBehaviour;
import org.eclipse.jst.server.tomcat.core.internal.WebModule;
import org.eclipse.jst.server.tomcat.ui.internal.Messages;
import org.eclipse.jst.server.tomcat.ui.internal.TomcatUIPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public class CleanWorkDirDialog
extends Dialog {
    public static final int ERROR_PREDELETE = 0;
    public static final int ERROR_DURINGDELETE = 1;
    public static final int ERROR_POSTDELETE = 2;
    protected IServer server;
    protected IModule module;
    protected int state;
    protected String mode;
    protected IStatus completionStatus = Status.OK_STATUS;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CleanWorkDirDialog(Shell parentShell, IServer server, IModule module) {
        super(parentShell);
        if (server == null) {
            throw new IllegalArgumentException();
        }
        this.server = server;
        this.module = module;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.confirmCleanWorkDirTitle);
    }

    protected Control createDialogArea(Composite parent) {
        if (this.state < 0 || this.state == 0) {
            this.captureServerState();
        }
        Composite composite = (Composite)super.createDialogArea(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.jst.server.tomcat.ui.tvcp0000");
        Label label = new Label(composite, 64);
        if (this.state == 1 || this.state == 3 || this.state == 0) {
            label.setText(NLS.bind((String)Messages.cleanServerStateChanging, (Object)this.server.getName()));
        } else {
            if (this.module != null) {
                label.setText(NLS.bind((String)Messages.cleanModuleWorkDir, (Object)this.module.getName(), (Object)this.server.getName()));
            } else {
                label.setText(NLS.bind((String)Messages.cleanServerWorkDir, (Object)this.server.getName()));
            }
            GridData data = new GridData();
            data.widthHint = 300;
            label.setLayoutData((Object)data);
            if (this.state == 2) {
                label = new Label(composite, 64);
                label.setText(Messages.cleanServerRunning);
                data = new GridData();
                data.widthHint = 300;
                label.setLayoutData((Object)data);
            }
        }
        CleanWorkDirDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button;
        super.createButtonsForButtonBar(parent);
        if (this.state < 0 || this.state == 0) {
            this.captureServerState();
        }
        if ((this.state == 1 || this.state == 3) && (button = this.getButton(0)) != null) {
            button.setEnabled(false);
        }
    }

    protected void okPressed() {
        DeleteWorkDirJob job = new DeleteWorkDirJob(Messages.cleanServerTask);
        job.setRule(ServerUtil.getServerSchedulingRule((IServer)this.server));
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                IStatus status = event.getResult();
                if (!status.isOK()) {
                    String title = CleanWorkDirDialog.this.module != null ? Messages.errorCleanModuleTitle : Messages.errorCleanServerTitle;
                    String message = "Message unset";
                    switch (status.getCode()) {
                        case 0: {
                            message = CleanWorkDirDialog.this.module != null ? NLS.bind((String)Messages.errorCouldNotCleanModule, (Object)CleanWorkDirDialog.this.module.getName(), (Object)CleanWorkDirDialog.this.server.getName()) : NLS.bind((String)Messages.errorCouldNotCleanServer, (Object)CleanWorkDirDialog.this.server.getName());
                            break;
                        }
                        case 1: {
                            message = CleanWorkDirDialog.this.module != null ? NLS.bind((String)Messages.errorCleanFailedModule, (Object)CleanWorkDirDialog.this.module.getName(), (Object)CleanWorkDirDialog.this.server.getName()) : NLS.bind((String)Messages.errorCleanFailedServer, (Object)CleanWorkDirDialog.this.server.getName());
                            break;
                        }
                        default: {
                            message = CleanWorkDirDialog.this.module != null ? NLS.bind((String)Messages.errorCleanNoRestartModule, (Object)CleanWorkDirDialog.this.module.getName()) : NLS.bind((String)Messages.errorCleanNoRestartServer, (Object)CleanWorkDirDialog.this.server.getName());
                        }
                    }
                    TomcatUIPlugin.openError(title, message, status);
                }
            }
        });
        job.schedule();
        super.okPressed();
    }

    private void captureServerState() {
        this.state = this.server.getServerState();
        if (this.state != 4) {
            this.mode = this.server.getMode();
        }
    }

    protected IStatus newErrorStatus(int errorCode, String message, Throwable throwable) {
        return new Status(4, "org.eclipse.jst.server.tomcat.ui", errorCode, message, throwable);
    }

    protected IStatus wrapErrorStatus(IStatus status, int errorCode, String message) {
        MultiStatus ms = new MultiStatus("org.eclipse.jst.server.tomcat.ui", errorCode, message, null);
        ms.add(status);
        return ms;
    }

    class DeleteWorkDirJob
    extends Job {
        public DeleteWorkDirJob(String name) {
            super(name);
        }

        public boolean belongsTo(Object family) {
            return ServerUtil.SERVER_JOB_FAMILY.equals(family);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected IStatus run(IProgressMonitor monitor) {
            IStatus status;
            boolean restart;
            IServer.IOperationListener listener;
            block18: {
                if (CleanWorkDirDialog.this.server.getServerState() != CleanWorkDirDialog.this.state) {
                    return CleanWorkDirDialog.this.newErrorStatus(0, Messages.errorCouldNotCleanStateChange, null);
                }
                listener = new IServer.IOperationListener(this){
                    final /* synthetic */ DeleteWorkDirJob this$1;
                    {
                        this.this$1 = deleteWorkDirJob;
                    }

                    public void done(IStatus result) {
                        DeleteWorkDirJob.access$0((DeleteWorkDirJob)this.this$1).completionStatus = result;
                    }
                };
                restart = false;
                status = Status.OK_STATUS;
                if (CleanWorkDirDialog.this.state != 4) {
                    status = CleanWorkDirDialog.this.server.canStop();
                    if (!status.isOK()) {
                        return CleanWorkDirDialog.this.wrapErrorStatus(status, 0, Messages.errorCouldNotCleanCantStop);
                    }
                    CleanWorkDirDialog.this.server.stop(false, listener);
                    if (!CleanWorkDirDialog.this.completionStatus.isOK()) {
                        return CleanWorkDirDialog.this.wrapErrorStatus(CleanWorkDirDialog.this.completionStatus, 0, Messages.errorCouldNotCleanStopFailed);
                    }
                    if (CleanWorkDirDialog.this.server.getServerState() != 4) {
                        return CleanWorkDirDialog.this.newErrorStatus(0, Messages.errorCouldNotCleanStopFailed, null);
                    }
                    restart = true;
                }
                IServer iServer = CleanWorkDirDialog.this.server;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jst.server.tomcat.core.internal.TomcatServerBehaviour");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                TomcatServerBehaviour tsb = (TomcatServerBehaviour)iServer.loadAdapter((Class)clazz, monitor);
                try {
                    if (CleanWorkDirDialog.this.module != null) {
                        IWebModule webModule;
                        IModule iModule = CleanWorkDirDialog.this.module;
                        Class<?> clazz2 = class$1;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$1 = Class.forName("org.eclipse.jst.server.core.IWebModule");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((webModule = (IWebModule)iModule.loadAdapter((Class)clazz2, null)) == null) return CleanWorkDirDialog.this.newErrorStatus(1, restart ? Messages.errorCantIdentifyWebAppWasRunning : Messages.errorCantIdentifyWebApp, null);
                        WebModule tcWebModule = new WebModule(webModule.getContextRoot(), "", "", true);
                        status = tsb.cleanContextWorkDir((ITomcatWebModule)tcWebModule, null);
                        break block18;
                    }
                    status = tsb.cleanServerWorkDir(null);
                }
                catch (CoreException ce) {
                    status = ce.getStatus();
                }
            }
            if (!status.isOK()) {
                return CleanWorkDirDialog.this.wrapErrorStatus(status, 1, restart ? Messages.errorErrorDuringCleanWasRunning : Messages.errorErrorDuringClean);
            }
            if (!restart) return status;
            status = CleanWorkDirDialog.this.server.canStart(CleanWorkDirDialog.this.mode);
            if (!status.isOK()) {
                return CleanWorkDirDialog.this.wrapErrorStatus(status, 2, Messages.errorCleanCantRestart);
            }
            CleanWorkDirDialog.this.server.start(CleanWorkDirDialog.this.mode, listener);
            if (CleanWorkDirDialog.this.completionStatus.isOK()) return status;
            return CleanWorkDirDialog.this.wrapErrorStatus(CleanWorkDirDialog.this.completionStatus, 2, Messages.errorCleanRestartFailed);
        }

        static /* synthetic */ CleanWorkDirDialog access$0(DeleteWorkDirJob deleteWorkDirJob) {
            return deleteWorkDirJob.CleanWorkDirDialog.this;
        }
    }
}

