/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.jarprocessor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.zip.ZipException;
import org.eclipse.update.internal.jarprocessor.JarProcessor;
import org.eclipse.update.internal.jarprocessor.Main;
import org.eclipse.update.internal.jarprocessor.PackStep;
import org.eclipse.update.internal.jarprocessor.PackUnpackStep;
import org.eclipse.update.internal.jarprocessor.SignCommandStep;
import org.eclipse.update.internal.jarprocessor.UnpackStep;
import org.eclipse.update.internal.jarprocessor.Utils;
import org.eclipse.update.internal.jarprocessor.ZipProcessor;

public class JarProcessorExecutor {
    public void runJarProcessor(Main.Options options) {
        block18: {
            Properties properties;
            JarProcessor packProcessor;
            JarProcessor processor;
            block20: {
                File packProperties;
                if (options.input.isFile() && options.input.getName().endsWith(".zip")) {
                    ZipProcessor processor2 = new ZipProcessor();
                    processor2.setWorkingDirectory(options.outputDir);
                    processor2.setSignCommand(options.signCommand);
                    processor2.setPack(options.pack);
                    processor2.setRepack(options.repack || options.pack && options.signCommand != null);
                    processor2.setUnpack(options.unpack);
                    processor2.setVerbose(options.verbose);
                    processor2.setProcessAll(options.processAll);
                    try {
                        processor2.processZip(options.input);
                    }
                    catch (ZipException e) {
                        if (options.verbose) {
                            e.printStackTrace();
                        }
                        break block18;
                    }
                    catch (IOException e) {
                        if (options.verbose) {
                            e.printStackTrace();
                        }
                        break block18;
                    }
                }
                processor = new JarProcessor();
                packProcessor = null;
                processor.setWorkingDirectory(options.outputDir);
                processor.setProcessAll(options.processAll);
                processor.setVerbose(options.verbose);
                properties = new Properties();
                if (options.input.isDirectory() && (packProperties = new File(options.input, "pack.properties")).exists() && packProperties.isFile()) {
                    BufferedInputStream in = null;
                    try {
                        try {
                            in = new BufferedInputStream(new FileInputStream(packProperties));
                            properties.load(in);
                        }
                        catch (IOException e) {
                            if (options.verbose) {
                                e.printStackTrace();
                            }
                            Utils.close(in);
                            break block20;
                        }
                    }
                    catch (Throwable throwable) {
                        Utils.close(in);
                        throw throwable;
                    }
                    Utils.close(in);
                }
            }
            if (options.unpack) {
                this.addUnpackStep(processor, properties, options);
            }
            if (options.repack || options.pack && options.signCommand != null) {
                this.addPackUnpackStep(processor, properties, options);
            }
            if (options.signCommand != null) {
                this.addSignStep(processor, properties, options);
            }
            if (options.pack) {
                packProcessor = new JarProcessor();
                packProcessor.setWorkingDirectory(options.outputDir);
                packProcessor.setProcessAll(options.processAll);
                packProcessor.setVerbose(options.verbose);
                this.addPackStep(packProcessor, properties, options);
            }
            try {
                this.process(options.input, options.unpack ? Utils.PACK_GZ_FILTER : Utils.JAR_FILTER, options.verbose, processor, packProcessor);
            }
            catch (FileNotFoundException e) {
                if (!options.verbose) break block18;
                e.printStackTrace();
            }
        }
    }

    protected void process(File input, FileFilter filter, boolean verbose, JarProcessor processor, JarProcessor packProcessor) throws FileNotFoundException {
        if (!input.exists()) {
            throw new FileNotFoundException();
        }
        File[] files = null;
        if (input.isDirectory()) {
            files = input.listFiles();
        } else if (filter.accept(input)) {
            files = new File[]{input};
        }
        int i = 0;
        while (i < files.length) {
            block13: {
                if (files[i].isDirectory()) {
                    String dir = processor.getWorkingDirectory();
                    processor.setWorkingDirectory(String.valueOf(dir) + "/" + files[i].getName());
                    if (packProcessor != null) {
                        packProcessor.setWorkingDirectory(String.valueOf(dir) + "/" + files[i].getName());
                    }
                    this.process(files[i], filter, verbose, processor, packProcessor);
                    processor.setWorkingDirectory(dir);
                    if (packProcessor != null) {
                        packProcessor.setWorkingDirectory(dir);
                    }
                } else if (filter.accept(files[i])) {
                    try {
                        File result = processor.processJar(files[i]);
                        if (packProcessor != null && result != null && result.exists()) {
                            packProcessor.processJar(result);
                        }
                    }
                    catch (IOException e) {
                        if (!verbose) break block13;
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
    }

    public void addPackUnpackStep(JarProcessor processor, Properties properties, Main.Options options) {
        processor.addProcessStep(new PackUnpackStep(properties, options.verbose));
    }

    public void addSignStep(JarProcessor processor, Properties properties, Main.Options options) {
        processor.addProcessStep(new SignCommandStep(properties, options.signCommand, options.verbose));
    }

    public void addPackStep(JarProcessor processor, Properties properties, Main.Options options) {
        processor.addProcessStep(new PackStep(properties, options.verbose));
    }

    public void addUnpackStep(JarProcessor processor, Properties properties, Main.Options options) {
        processor.addProcessStep(new UnpackStep(properties, options.verbose));
    }
}

