/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryInternalReference;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryRegistryUtil;
import org.eclipse.jst.jsf.core.internal.project.facet.IJSFFacetInstallDataModelProperties;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public abstract class AbstractJSFFacetInstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object cfg, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            IDataModel config = null;
            if (cfg != null) {
                config = (IDataModel)cfg;
            }
            this.createClasspathEntries(project, config, monitor);
            this.createConfigFile(project, fv, config, monitor);
            this.createServletAndModifyWebXML(project, config, monitor);
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected void createClasspathEntries(IProject project, IDataModel config, IProgressMonitor monitor) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
        try {
            int i = 0;
            while (i < javaProject.getRawClasspath().length) {
                cpEntries.add(javaProject.getRawClasspath()[i]);
                ++i;
            }
        }
        catch (JavaModelException e) {
            JSFCorePlugin.log((Exception)((Object)e), "Unable to read classpath");
        }
        Path cp = null;
        IClasspathEntry entry = null;
        JSFLibraryInternalReference libref = null;
        if (config.getProperty("IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE_PROPERTY_NAME") == IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE.CLIENT_SUPPLIED) {
            cp = new Path("org.eclipse.jst.jsf.core.internal.jsflibrarycontainer");
            libref = (JSFLibraryInternalReference)config.getProperty("IJSFFacetInstallDataModelProperties.IMPLEMENTATION");
            IPath path = cp.append((IPath)new Path(libref.getID()));
            entry = this.getNewCPEntry(path, libref);
            cpEntries.add(entry);
        }
        JSFLibraryInternalReference[] compLibs = (JSFLibraryInternalReference[])config.getProperty("IJSFFacetInstallDataModelProperties.COMPONENT_LIBRARIES");
        int i = 0;
        while (i < compLibs.length) {
            cp = new Path("org.eclipse.jst.jsf.core.internal.jsflibrarycontainer");
            libref = compLibs[i];
            IPath path = cp.append((IPath)new Path(libref.getID()));
            entry = this.getNewCPEntry(path, libref);
            if (entry != null) {
                cpEntries.add(entry);
            }
            ++i;
        }
        JSFLibraryRegistryUtil.setRawClasspath(javaProject, cpEntries, monitor);
    }

    protected IClasspathEntry getNewCPEntry(IPath path, JSFLibraryInternalReference lib) {
        IClasspathEntry entry = null;
        if (lib.isCheckedToBeDeployed()) {
            IClasspathAttribute depAttrib = JavaCore.newClasspathAttribute((String)"org.eclipse.jst.component.dependency", (String)ClasspathDependencyUtil.getDefaultRuntimePath((boolean)true).toString());
            entry = JavaCore.newContainerEntry((IPath)path, null, (IClasspathAttribute[])new IClasspathAttribute[]{depAttrib}, (boolean)true);
        } else {
            entry = JavaCore.newContainerEntry((IPath)path);
        }
        return entry;
    }

    protected abstract void createConfigFile(IProject var1, IProjectFacetVersion var2, IDataModel var3, IProgressMonitor var4);

    protected abstract void createServletAndModifyWebXML(IProject var1, IDataModel var2, IProgressMonitor var3);

    protected List getServletMappings(IDataModel config) {
        ArrayList<String> mappings = new ArrayList<String>();
        String[] patterns = (String[])config.getProperty("IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS");
        int i = 0;
        while (i < patterns.length) {
            String pattern = patterns[i];
            mappings.add(pattern);
            ++i;
        }
        return mappings;
    }

    protected IPath resolveConfigPath(IProject project, String jsfConfigPath) {
        return ComponentCore.createComponent((IProject)project).getRootFolder().getUnderlyingFolder().getRawLocation().append((IPath)new Path(jsfConfigPath));
    }
}

