/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.templates.dialog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.sqltools.sqleditor.internal.templates.dialog.TemplateVariableProcessor;
import org.eclipse.datatools.sqltools.sqleditor.internal.templates.dialog.TextEditorTemplateMessages;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;

public class EditTemplateDialog
extends StatusDialog {
    private final Template _fTemplate;
    private Text _fNameText;
    private Text _fDescriptionText;
    private Combo _fContextCombo;
    private SourceViewer _fPatternEditor;
    private Button _fInsertVariableButton;
    private boolean _fIsNameModifiable;
    private StatusInfo _fValidationStatus;
    private boolean _fSuppressError = true;
    private Map _fGlobalActions = new HashMap(10);
    private List _fSelectionActions = new ArrayList(3);
    private String[][] _fContextTypes;
    private ContextTypeRegistry _fContextTypeRegistry;
    private final TemplateVariableProcessor _fTemplateProcessor = new TemplateVariableProcessor();

    public EditTemplateDialog(Shell parent, Template template, boolean edit, boolean isNameModifiable, ContextTypeRegistry registry) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        String title = edit ? TextEditorTemplateMessages.EditTemplateDialog_title_edit : TextEditorTemplateMessages.EditTemplateDialog_title_new;
        this.setTitle(title);
        this._fTemplate = template;
        this._fIsNameModifiable = isNameModifiable;
        ArrayList<String[]> contexts = new ArrayList<String[]>();
        Iterator it = registry.contextTypes();
        while (it.hasNext()) {
            TemplateContextType type = (TemplateContextType)it.next();
            contexts.add(new String[]{type.getId(), type.getName()});
        }
        this._fContextTypes = (String[][])contexts.toArray((T[])new String[contexts.size()][]);
        this._fValidationStatus = new StatusInfo();
        this._fContextTypeRegistry = registry;
        TemplateContextType type = this._fContextTypeRegistry.getContextType(template.getContextTypeId());
        this._fTemplateProcessor.setContextType(type);
    }

    public void create() {
        boolean valid;
        super.create();
        boolean bl = valid = this._fNameText == null || this._fNameText.getText().trim().length() != 0;
        if (!valid) {
            StatusInfo status = new StatusInfo();
            status.setError(TextEditorTemplateMessages.EditTemplateDialog_error_noname);
            this.updateButtonsEnableState((IStatus)status);
        }
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditTemplateDialog.this.doTextWidgetChanged(e.widget);
            }
        };
        if (this._fIsNameModifiable) {
            EditTemplateDialog.createLabel(parent, TextEditorTemplateMessages.EditTemplateDialog_name);
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(768));
            layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            composite.setLayout((Layout)layout);
            this._fNameText = EditTemplateDialog.createText(composite);
            this._fNameText.addModifyListener(listener);
            this._fNameText.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    if (EditTemplateDialog.this._fSuppressError) {
                        EditTemplateDialog.this._fSuppressError = false;
                        EditTemplateDialog.this.updateButtons();
                    }
                }
            });
            EditTemplateDialog.createLabel(composite, TextEditorTemplateMessages.EditTemplateDialog_context);
            this._fContextCombo = new Combo(composite, 8);
            for (int i = 0; i < this._fContextTypes.length; ++i) {
                this._fContextCombo.add(this._fContextTypes[i][1]);
            }
            this._fContextCombo.addModifyListener(listener);
        }
        EditTemplateDialog.createLabel(parent, TextEditorTemplateMessages.EditTemplateDialog_description);
        int descFlags = this._fIsNameModifiable ? 2048 : 2056;
        this._fDescriptionText = new Text(parent, descFlags);
        this._fDescriptionText.setLayoutData((Object)new GridData(768));
        this._fDescriptionText.addModifyListener(listener);
        Label patternLabel = EditTemplateDialog.createLabel(parent, TextEditorTemplateMessages.EditTemplateDialog_pattern);
        patternLabel.setLayoutData((Object)new GridData(2));
        this._fPatternEditor = this.createEditor(parent);
        Label filler = new Label(parent, 0);
        filler.setLayoutData((Object)new GridData());
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData());
        this._fInsertVariableButton = new Button(composite, 0);
        this._fInsertVariableButton.setLayoutData((Object)EditTemplateDialog.getButtonGridData(this._fInsertVariableButton));
        this._fInsertVariableButton.setText(TextEditorTemplateMessages.EditTemplateDialog_insert_variable);
        this._fInsertVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditTemplateDialog.this._fPatternEditor.getTextWidget().setFocus();
                EditTemplateDialog.this._fPatternEditor.doOperation(13);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this._fDescriptionText.setText(this._fTemplate.getDescription());
        if (this._fIsNameModifiable) {
            this._fNameText.setText(this._fTemplate.getName());
            this._fNameText.addModifyListener(listener);
            this._fContextCombo.select(this.getIndex(this._fTemplate.getContextTypeId()));
        } else {
            this._fPatternEditor.getControl().setFocus();
        }
        this.initializeActions();
        EditTemplateDialog.applyDialogFont((Control)parent);
        return composite;
    }

    private void doTextWidgetChanged(Widget w) {
        if (w == this._fNameText) {
            this._fSuppressError = false;
            String name = this._fNameText.getText();
            this._fTemplate.setName(name);
            this.updateButtons();
        } else if (w == this._fContextCombo) {
            String name = this._fContextCombo.getText();
            String contextId = this.getContextId(name);
            this._fTemplate.setContextTypeId(contextId);
            this._fTemplateProcessor.setContextType(this._fContextTypeRegistry.getContextType(contextId));
        } else if (w == this._fDescriptionText) {
            String desc = this._fDescriptionText.getText();
            this._fTemplate.setDescription(desc);
        }
    }

    private String getContextId(String name) {
        if (name == null) {
            return name;
        }
        for (int i = 0; i < this._fContextTypes.length; ++i) {
            if (!name.equals(this._fContextTypes[i][1])) continue;
            return this._fContextTypes[i][0];
        }
        return name;
    }

    private void doSourceChanged(IDocument document) {
        String text = document.get();
        this._fTemplate.setPattern(text);
        this._fValidationStatus.setOK();
        TemplateContextType contextType = this._fContextTypeRegistry.getContextType(this._fTemplate.getContextTypeId());
        if (contextType != null) {
            try {
                contextType.validate(text);
            }
            catch (TemplateException e) {
                this._fValidationStatus.setError(e.getLocalizedMessage());
            }
        }
        this.updateUndoAction();
        this.updateButtons();
    }

    private static GridData getButtonGridData(Button button) {
        GridData data = new GridData(768);
        return data;
    }

    private static Label createLabel(Composite parent, String name) {
        Label label = new Label(parent, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData());
        return label;
    }

    private static Text createText(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private SourceViewer createEditor(Composite parent) {
        SourceViewer viewer = this.createViewer(parent);
        Document document = new Document(this._fTemplate.getPattern());
        viewer.setEditable(true);
        viewer.setDocument((IDocument)document);
        int nLines = document.getNumberOfLines();
        if (nLines < 5) {
            nLines = 5;
        } else if (nLines > 12) {
            nLines = 12;
        }
        Control control = viewer.getControl();
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(80);
        data.heightHint = this.convertHeightInCharsToPixels(nLines);
        control.setLayoutData((Object)data);
        viewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                if (event.getDocumentEvent() != null) {
                    EditTemplateDialog.this.doSourceChanged(event.getDocumentEvent().getDocument());
                }
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EditTemplateDialog.this.updateSelectionDependentActions();
            }
        });
        viewer.prependVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                EditTemplateDialog.this.handleVerifyKeyPressed(event);
            }
        });
        return viewer;
    }

    protected SourceViewer createViewer(Composite parent) {
        SourceViewer viewer = new SourceViewer(parent, null, null, false, 2816);
        SourceViewerConfiguration configuration = new SourceViewerConfiguration(){

            public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
                ContentAssistant assistant = new ContentAssistant();
                assistant.enableAutoActivation(true);
                assistant.enableAutoInsert(true);
                assistant.setContentAssistProcessor((IContentAssistProcessor)EditTemplateDialog.this._fTemplateProcessor, "__dftl_partition_content_type");
                return assistant;
            }
        };
        viewer.configure(configuration);
        return viewer;
    }

    private void handleVerifyKeyPressed(VerifyEvent event) {
        if (!event.doit) {
            return;
        }
        if (event.stateMask != SWT.MOD1) {
            return;
        }
        switch (event.character) {
            case ' ': {
                this._fPatternEditor.doOperation(13);
                event.doit = false;
                break;
            }
            case '\u001a': {
                this._fPatternEditor.doOperation(1);
                event.doit = false;
            }
        }
    }

    private void initializeActions() {
        TextViewerAction action = new TextViewerAction((ITextViewer)this._fPatternEditor, 1);
        action.setText(TextEditorTemplateMessages.EditTemplateDialog_undo);
        this._fGlobalActions.put(ITextEditorActionConstants.UNDO, action);
        action = new TextViewerAction((ITextViewer)this._fPatternEditor, 3);
        action.setText(TextEditorTemplateMessages.EditTemplateDialog_cut);
        this._fGlobalActions.put(ITextEditorActionConstants.CUT, action);
        action = new TextViewerAction((ITextViewer)this._fPatternEditor, 4);
        action.setText(TextEditorTemplateMessages.EditTemplateDialog_copy);
        this._fGlobalActions.put(ITextEditorActionConstants.COPY, action);
        action = new TextViewerAction((ITextViewer)this._fPatternEditor, 5);
        action.setText(TextEditorTemplateMessages.EditTemplateDialog_paste);
        this._fGlobalActions.put(ITextEditorActionConstants.PASTE, action);
        action = new TextViewerAction((ITextViewer)this._fPatternEditor, 7);
        action.setText(TextEditorTemplateMessages.EditTemplateDialog_select_all);
        this._fGlobalActions.put(ITextEditorActionConstants.SELECT_ALL, action);
        action = new TextViewerAction((ITextViewer)this._fPatternEditor, 13);
        action.setText(TextEditorTemplateMessages.EditTemplateDialog_content_assist);
        this._fGlobalActions.put("ContentAssistProposal", action);
        this._fSelectionActions.add(ITextEditorActionConstants.CUT);
        this._fSelectionActions.add(ITextEditorActionConstants.COPY);
        this._fSelectionActions.add(ITextEditorActionConstants.PASTE);
        MenuManager manager = new MenuManager(null, null);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                EditTemplateDialog.this.fillContextMenu(mgr);
            }
        });
        StyledText text = this._fPatternEditor.getTextWidget();
        Menu menu = manager.createContextMenu((Control)text);
        text.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new GroupMarker("group.undo"));
        menu.appendToGroup("group.undo", (IAction)this._fGlobalActions.get(ITextEditorActionConstants.UNDO));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.appendToGroup("group.edit", (IAction)this._fGlobalActions.get(ITextEditorActionConstants.CUT));
        menu.appendToGroup("group.edit", (IAction)this._fGlobalActions.get(ITextEditorActionConstants.COPY));
        menu.appendToGroup("group.edit", (IAction)this._fGlobalActions.get(ITextEditorActionConstants.PASTE));
        menu.appendToGroup("group.edit", (IAction)this._fGlobalActions.get(ITextEditorActionConstants.SELECT_ALL));
        menu.add((IContributionItem)new Separator("templates"));
        menu.appendToGroup("templates", (IAction)this._fGlobalActions.get("ContentAssistProposal"));
    }

    private void updateSelectionDependentActions() {
        Iterator iterator = this._fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction((String)iterator.next());
        }
    }

    private void updateUndoAction() {
        IAction action = (IAction)this._fGlobalActions.get(ITextEditorActionConstants.UNDO);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    private void updateAction(String actionId) {
        IAction action = (IAction)this._fGlobalActions.get(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    private int getIndex(String contextid) {
        if (contextid == null) {
            return -1;
        }
        for (int i = 0; i < this._fContextTypes.length; ++i) {
            if (!contextid.equals(this._fContextTypes[i][0])) continue;
            return i;
        }
        return -1;
    }

    private void updateButtons() {
        StatusInfo status;
        boolean valid;
        boolean bl = valid = this._fNameText == null || this._fNameText.getText().trim().length() != 0;
        if (!valid) {
            status = new StatusInfo();
            if (!this._fSuppressError) {
                status.setError(TextEditorTemplateMessages.EditTemplateDialog_error_noname);
            }
        } else {
            status = this._fValidationStatus;
        }
        this.updateStatus((IStatus)status);
    }

    private static class TextViewerAction
    extends Action
    implements IUpdate {
        private int _fOperationCode = -1;
        private ITextOperationTarget _fOperationTarget;

        public TextViewerAction(ITextViewer viewer, int operationCode) {
            this._fOperationCode = operationCode;
            this._fOperationTarget = viewer.getTextOperationTarget();
            this.update();
        }

        public void update() {
            boolean wasEnabled = this.isEnabled();
            boolean isEnabled = this._fOperationTarget != null && this._fOperationTarget.canDoOperation(this._fOperationCode);
            this.setEnabled(isEnabled);
            if (wasEnabled != isEnabled) {
                this.firePropertyChange("enabled", wasEnabled ? Boolean.TRUE : Boolean.FALSE, isEnabled ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        public void run() {
            if (this._fOperationCode != -1 && this._fOperationTarget != null) {
                this._fOperationTarget.doOperation(this._fOperationCode);
            }
        }
    }
}

