/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.preview.internal;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.preview.internal.IMemento;
import org.eclipse.wst.server.preview.internal.Servlet;
import org.eclipse.wst.server.preview.internal.XMLMemento;

public class Module {
    private String name;
    private boolean isStatic;
    private String context;
    private String projectPath;
    protected String contextRoot;
    private Servlet[] servlets;
    protected IPath[] outputPaths;

    public Module(String name, boolean isStatic, String context, String projectPath) {
        this.name = name;
        this.isStatic = isStatic;
        this.context = context;
        this.projectPath = projectPath;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStaticWeb() {
        return this.isStatic;
    }

    public String getContext() {
        return this.context;
    }

    public String getPath() {
        return this.projectPath;
    }

    public void initialize() {
        this.loadComponentFile();
        this.loadWebDD();
    }

    private void loadWebDD() {
        File f = this.findWebDD().toFile();
        if (!f.exists()) {
            System.err.println("Could not find web.xml");
            return;
        }
        try {
            IMemento m;
            IMemento memento = XMLMemento.loadMemento(f);
            IMemento[] servlets2 = memento.getChildren("servlet");
            int size = this.servlets.length;
            ArrayList list = new ArrayList(size);
            int i = 0;
            while (i < size) {
                Servlet s = new Servlet();
                m = servlets2[i].getChild("servlet-name");
                s.name = m.getName().trim();
                m = servlets2[i].getChild("servlet-class");
                s.name = m.getName().trim();
                ++i;
            }
            IMemento[] mappings = memento.getChildren("servlet-mapping");
            size = mappings.length;
            int i2 = 0;
            while (i2 < size) {
                m = mappings[i2].getChild("servlet-name");
                Object s = null;
                m = mappings[i2].getChild("url-pattern");
                s.urlPattern = m.getName().trim();
                ++i2;
            }
            this.servlets = new Servlet[list.size()];
            list.toArray(this.servlets);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadComponentFile() {
        File f = new Path(this.projectPath).append(".settings").append(".component").toFile();
        if (!f.exists()) {
            System.err.println("Could not find component file");
            return;
        }
        try {
            IMemento memento = XMLMemento.loadMemento(f);
            IMemento module = memento.getChild("wb-module");
            IMemento[] resources = module.getChildren("wb-resource");
            int size = resources.length;
            int i = 0;
            while (i < size) {
                ++i;
            }
            IMemento[] dependent = module.getChildren("dependent-module");
            size = dependent.length;
            int i2 = 0;
            while (i2 < size) {
                ++i2;
            }
            IMemento[] properties = module.getChildren("property");
            size = properties.length;
            int i3 = 0;
            while (i3 < size) {
                String name2 = properties[i3].getString("name");
                if ("context-root".equals(name2)) {
                    this.contextRoot = properties[i3].getString("value");
                } else if ("java-output-path".equals(name2)) {
                    this.outputPaths = new IPath[]{new Path(this.projectPath).append(properties[i3].getString("value"))};
                }
                ++i3;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private IPath findWebDD() {
        int size = this.outputPaths.length;
        int i = 0;
        while (i < size) {
            IPath path = this.outputPaths[i].append("WEB-INF").append("web.xml");
            if (path.toFile().exists()) {
                return path;
            }
            ++i;
        }
        return null;
    }

    public ClassLoader getClassloader() {
        File f = new Path(this.projectPath).append("config").toFile();
        if (!f.exists()) {
            System.err.println("Config doesn't exist at " + this.projectPath);
            return null;
        }
        try {
            IMemento memento = XMLMemento.loadMemento(f);
            memento.getChildren("modules");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

