/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.java.mappings;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.IPersistentAttribute;
import org.eclipse.jpt.core.internal.IPersistentType;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaAttributeMapping;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaAttributeOverride;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsPackage;
import org.eclipse.jpt.core.internal.jdtutility.Attribute;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.mappings.IAttributeOverride;
import org.eclipse.jpt.core.internal.mappings.IEmbeddable;
import org.eclipse.jpt.core.internal.mappings.IEmbedded;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.IOverride;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.utility.internal.Filter;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEmbedded
extends JavaAttributeMapping
implements IEmbedded {
    protected EList<IAttributeOverride> specifiedAttributeOverrides;
    protected EList<IAttributeOverride> defaultAttributeOverrides;
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.Embedded");
    private IEmbeddable embeddable;

    protected JavaEmbedded() {
        throw new UnsupportedOperationException("Use JavaEmbedded(Attribute) instead");
    }

    protected JavaEmbedded(Attribute attribute) {
        super(attribute);
    }

    @Override
    protected void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        switch (notification.getFeatureID(IEntity.class)) {
            case 1: {
                this.attributeOverridesChanged(notification);
                break;
            }
        }
    }

    void attributeOverridesChanged(Notification notification) {
        switch (notification.getEventType()) {
            case 3: {
                this.attributeOverrideAdded(notification.getPosition(), (JavaAttributeOverride)notification.getNewValue());
                break;
            }
            case 5: {
                this.attributeOverridesAdded(notification.getPosition(), (List)notification.getNewValue());
                break;
            }
            case 4: {
                this.attributeOverrideRemoved(notification.getPosition(), (JavaAttributeOverride)notification.getOldValue());
                break;
            }
            case 6: {
                if (notification.getPosition() == -1) {
                    this.attributeOverridesCleared((List)notification.getOldValue());
                    break;
                }
                this.attributeOverridesRemoved((int[])notification.getNewValue(), (List)notification.getOldValue());
                break;
            }
            case 1: {
                if (notification.isTouch()) break;
                this.attributeOverrideSet(notification.getPosition(), (JavaAttributeOverride)notification.getOldValue(), (JavaAttributeOverride)notification.getNewValue());
                break;
            }
            case 7: {
                this.attributeOverrideMoved(notification.getOldIntValue(), notification.getPosition(), (JavaAttributeOverride)notification.getNewValue());
                break;
            }
        }
    }

    public void attributeOverrideAdded(int index, JavaAttributeOverride attributeOverride) {
        if (attributeOverride.annotation(this.getAttribute().astRoot()) == null) {
            this.synchAttributeOverrideAnnotationsAfterAdd(index + 1);
            attributeOverride.newAnnotation();
        }
    }

    public void attributeOverridesAdded(int index, List<JavaAttributeOverride> attributeOverrides) {
        if (!attributeOverrides.isEmpty() && attributeOverrides.get(0).annotation(this.getAttribute().astRoot()) == null) {
            this.synchAttributeOverrideAnnotationsAfterAdd(index + attributeOverrides.size());
            for (JavaAttributeOverride attributeOverride : attributeOverrides) {
                attributeOverride.newAnnotation();
            }
        }
    }

    public void attributeOverrideRemoved(int index, JavaAttributeOverride attributeOverride) {
        attributeOverride.removeAnnotation();
        this.synchAttributeOverrideAnnotationsAfterRemove(index);
    }

    public void attributeOverridesRemoved(int[] indexes, List<JavaAttributeOverride> attributeOverrides) {
        for (JavaAttributeOverride attributeOverride : attributeOverrides) {
            attributeOverride.removeAnnotation();
        }
        this.synchAttributeOverrideAnnotationsAfterRemove(indexes[0]);
    }

    public void attributeOverridesCleared(List<JavaAttributeOverride> attributeOverrides) {
        for (JavaAttributeOverride attributeOverride : attributeOverrides) {
            attributeOverride.removeAnnotation();
        }
    }

    public void attributeOverrideSet(int index, JavaAttributeOverride oldAttributeOverride, JavaAttributeOverride newAttributeOverride) {
        newAttributeOverride.newAnnotation();
    }

    public void attributeOverrideMoved(int sourceIndex, int targetIndex, JavaAttributeOverride attributeOverride) {
        EList<IAttributeOverride> attributeOverrides = this.getSpecifiedAttributeOverrides();
        int begin = Math.min(sourceIndex, targetIndex);
        int end = Math.max(sourceIndex, targetIndex);
        int i = begin;
        while (i-- > end) {
            this.synch((JavaAttributeOverride)attributeOverrides.get(i), i);
        }
    }

    private void synchAttributeOverrideAnnotationsAfterAdd(int index) {
        EList<IAttributeOverride> attributeOverrides = this.getSpecifiedAttributeOverrides();
        int i = attributeOverrides.size();
        while (i-- > index) {
            this.synch((JavaAttributeOverride)attributeOverrides.get(i), i);
        }
    }

    private void synchAttributeOverrideAnnotationsAfterRemove(int index) {
        EList<IAttributeOverride> attributeOverrides = this.getSpecifiedAttributeOverrides();
        int i = index;
        while (i < attributeOverrides.size()) {
            this.synch((JavaAttributeOverride)attributeOverrides.get(i), i);
            ++i;
        }
    }

    private void synch(JavaAttributeOverride attributeOverride, int index) {
        attributeOverride.moveAnnotation(index);
    }

    @Override
    protected EClass eStaticClass() {
        return JpaJavaMappingsPackage.Literals.JAVA_EMBEDDED;
    }

    @Override
    public EList<IAttributeOverride> getAttributeOverrides() {
        EObjectEList list = new EObjectEList(IAttributeOverride.class, (InternalEObject)this, 0);
        list.addAll(this.getSpecifiedAttributeOverrides());
        list.addAll(this.getDefaultAttributeOverrides());
        return list;
    }

    @Override
    public EList<IAttributeOverride> getSpecifiedAttributeOverrides() {
        if (this.specifiedAttributeOverrides == null) {
            this.specifiedAttributeOverrides = new EObjectContainmentEList(IAttributeOverride.class, (InternalEObject)this, 1);
        }
        return this.specifiedAttributeOverrides;
    }

    @Override
    public EList<IAttributeOverride> getDefaultAttributeOverrides() {
        if (this.defaultAttributeOverrides == null) {
            this.defaultAttributeOverrides = new EObjectContainmentEList(IAttributeOverride.class, (InternalEObject)this, 2);
        }
        return this.defaultAttributeOverrides;
    }

    @Override
    public IEmbeddable embeddable() {
        return this.embeddable;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getAttributeOverrides()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getSpecifiedAttributeOverrides()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getDefaultAttributeOverrides()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getAttributeOverrides();
            }
            case 1: {
                return this.getSpecifiedAttributeOverrides();
            }
            case 2: {
                return this.getDefaultAttributeOverrides();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getSpecifiedAttributeOverrides().clear();
                this.getSpecifiedAttributeOverrides().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getDefaultAttributeOverrides().clear();
                this.getDefaultAttributeOverrides().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getSpecifiedAttributeOverrides().clear();
                return;
            }
            case 2: {
                this.getDefaultAttributeOverrides().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return !this.getAttributeOverrides().isEmpty();
            }
            case 1: {
                return this.specifiedAttributeOverrides != null && !this.specifiedAttributeOverrides.isEmpty();
            }
            case 2: {
                return this.defaultAttributeOverrides != null && !this.defaultAttributeOverrides.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IEmbedded.class) {
            switch (derivedFeatureID) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IEmbedded.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    protected DeclarationAnnotationAdapter declarationAnnotationAdapter() {
        return DECLARATION_ANNOTATION_ADAPTER;
    }

    @Override
    public String getKey() {
        return "embedded";
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext) {
        super.refreshDefaults(defaultsContext);
        this.refreshEmbeddable(defaultsContext);
    }

    private void refreshEmbeddable(DefaultsContext defaultsContext) {
        this.embeddable = JavaEmbedded.embeddableFor(this.getAttribute(), defaultsContext);
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        super.updateFromJava(astRoot);
        this.updateAttributeOverridesFromJava(astRoot);
    }

    /*
     * Unable to fully structure code
     */
    private void updateAttributeOverridesFromJava(CompilationUnit astRoot) {
        block5: {
            attributeOverrides = this.getSpecifiedAttributeOverrides();
            persSize = attributeOverrides.size();
            javaSize = 0;
            allJavaAnnotationsFound = false;
            i = 0;
            while (i < persSize) {
                attributeOverride = (JavaAttributeOverride)attributeOverrides.get(i);
                if (attributeOverride.annotation(astRoot) == null) {
                    allJavaAnnotationsFound = true;
                    break;
                }
                attributeOverride.updateFromJava(astRoot);
                ++javaSize;
                ++i;
            }
            if (!allJavaAnnotationsFound) ** GOTO lbl29
            while (persSize > javaSize) {
                attributeOverrides.remove(--persSize);
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                attributeOverride = this.createJavaAttributeOverride(javaSize);
                if (attributeOverride.annotation(astRoot) == null) {
                    allJavaAnnotationsFound = true;
                    continue;
                }
                this.getSpecifiedAttributeOverrides().add((Object)attributeOverride);
                attributeOverride.updateFromJava(astRoot);
                ++javaSize;
lbl29:
                // 3 sources

                ** while (!allJavaAnnotationsFound)
            }
        }
    }

    @Override
    public IAttributeOverride attributeOverrideNamed(String name) {
        return (IAttributeOverride)this.overrideNamed(name, (List<? extends IOverride>)this.getAttributeOverrides());
    }

    @Override
    public boolean containsAttributeOverride(String name) {
        return this.containsOverride(name, (List<? extends IOverride>)this.getAttributeOverrides());
    }

    @Override
    public boolean containsSpecifiedAttributeOverride(String name) {
        return this.containsOverride(name, (List<? extends IOverride>)this.getSpecifiedAttributeOverrides());
    }

    private IOverride overrideNamed(String name, List<? extends IOverride> overrides) {
        for (IOverride iOverride : overrides) {
            String overrideName = iOverride.getName();
            if (overrideName == null && name == null) {
                return iOverride;
            }
            if (overrideName == null || !overrideName.equals(name)) continue;
            return iOverride;
        }
        return null;
    }

    private boolean containsOverride(String name, List<? extends IOverride> overrides) {
        return this.overrideNamed(name, overrides) != null;
    }

    @Override
    public Iterator<String> allOverridableAttributeNames() {
        return new TransformationIterator<IPersistentAttribute, String>(this.allOverridableAttributes()){

            protected String transform(IPersistentAttribute attribute) {
                return attribute.getName();
            }
        };
    }

    public Iterator<IPersistentAttribute> allOverridableAttributes() {
        if (this.embeddable() == null) {
            return EmptyIterator.instance();
        }
        return new FilteringIterator<IPersistentAttribute>(this.embeddable().getPersistentType().attributes()){

            protected boolean accept(Object o) {
                return ((IPersistentAttribute)o).isOverridableAttribute();
            }
        };
    }

    @Override
    public IAttributeOverride createAttributeOverride(int index) {
        return this.createJavaAttributeOverride(index);
    }

    private JavaAttributeOverride createJavaAttributeOverride(int index) {
        return JavaAttributeOverride.createAttributeOverride(new IEmbedded.AttributeOverrideOwner(this), this.getAttribute(), index);
    }

    @Override
    public Iterator<String> candidateValuesFor(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.candidateValuesFor(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (IAttributeOverride override : this.getAttributeOverrides()) {
            result = ((JavaAttributeOverride)override).candidateValuesFor(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static IEmbeddable embeddableFor(Attribute attribute, DefaultsContext defaultsContext) {
        String resolvedTypeName = attribute.resolvedTypeName();
        if (resolvedTypeName == null) {
            return null;
        }
        IPersistentType persistentType = defaultsContext.persistentType(resolvedTypeName);
        if (persistentType != null && persistentType.getMapping() instanceof IEmbeddable) {
            return (IEmbeddable)persistentType.getMapping();
        }
        return null;
    }
}

