/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.Map;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.codeassist.impl.AssistOptions;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.jdt.internal.core.INamingRequestor;

public class InternalNamingConventions {
    private static final char[] DEFAULT_NAME = "name".toCharArray();

    private static Scanner getNameScanner(CompilerOptions compilerOptions) {
        return new Scanner(false, false, false, compilerOptions.sourceLevel, null, null, true);
    }

    public static void suggestArgumentNames(IJavaProject javaProject, char[] packageName, char[] qualifiedTypeName, int dim, char[] internalPrefix, char[][] excludedNames, INamingRequestor requestor) {
        Map options = javaProject.getOptions(true);
        CompilerOptions compilerOptions = new CompilerOptions(options);
        AssistOptions assistOptions = new AssistOptions(options);
        InternalNamingConventions.suggestNames(packageName, qualifiedTypeName, dim, internalPrefix, assistOptions.argumentPrefixes, assistOptions.argumentSuffixes, excludedNames, InternalNamingConventions.getNameScanner(compilerOptions), requestor);
    }

    public static void suggestFieldNames(IJavaProject javaProject, char[] packageName, char[] qualifiedTypeName, int dim, int modifiers, char[] internalPrefix, char[][] excludedNames, INamingRequestor requestor) {
        boolean isStatic = Flags.isStatic(modifiers);
        Map options = javaProject.getOptions(true);
        CompilerOptions compilerOptions = new CompilerOptions(options);
        AssistOptions assistOptions = new AssistOptions(options);
        InternalNamingConventions.suggestNames(packageName, qualifiedTypeName, dim, internalPrefix, isStatic ? assistOptions.staticFieldPrefixes : assistOptions.fieldPrefixes, isStatic ? assistOptions.staticFieldSuffixes : assistOptions.fieldSuffixes, excludedNames, InternalNamingConventions.getNameScanner(compilerOptions), requestor);
    }

    public static void suggestLocalVariableNames(IJavaProject javaProject, char[] packageName, char[] qualifiedTypeName, int dim, char[] internalPrefix, char[][] excludedNames, INamingRequestor requestor) {
        Map options = javaProject.getOptions(true);
        CompilerOptions compilerOptions = new CompilerOptions(options);
        AssistOptions assistOptions = new AssistOptions(options);
        InternalNamingConventions.suggestNames(packageName, qualifiedTypeName, dim, internalPrefix, assistOptions.localPrefixes, assistOptions.localSuffixes, excludedNames, InternalNamingConventions.getNameScanner(compilerOptions), requestor);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static void suggestNames(char[] packageName, char[] qualifiedTypeName, int dim, char[] internalPrefix, char[][] prefixes, char[][] suffixes, char[][] excludedNames, Scanner nameScanner, INamingRequestor requestor) {
        if (qualifiedTypeName == null || qualifiedTypeName.length == 0) {
            return;
        }
        internalPrefix = internalPrefix == null ? CharOperation.NO_CHAR : InternalNamingConventions.removePrefix(internalPrefix, prefixes /* !! */ );
        typeName = CharOperation.lastSegment(qualifiedTypeName, '.');
        if (prefixes /* !! */  == null || prefixes /* !! */ .length == 0) {
            prefixes /* !! */  = new char[1][0];
        } else {
            length = prefixes /* !! */ .length;
            v0 = prefixes /* !! */ ;
            v1 = new char[length + 1][];
            prefixes /* !! */  = v1;
            System.arraycopy(v0, 0, v1, 0, length);
            prefixes /* !! */ [length] = CharOperation.NO_CHAR;
        }
        if (suffixes /* !! */  == null || suffixes /* !! */ .length == 0) {
            suffixes /* !! */  = new char[1][0];
        } else {
            length = suffixes /* !! */ .length;
            v2 = suffixes /* !! */ ;
            v3 = new char[length + 1][];
            suffixes /* !! */  = v3;
            System.arraycopy(v2, 0, v3, 0, length);
            suffixes /* !! */ [length] = CharOperation.NO_CHAR;
        }
        tempNames /* !! */  = null;
        try {
            nameScanner.setSource(typeName);
            switch (nameScanner.getNextToken()) {
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: {
                    if (internalPrefix != null && internalPrefix.length > 0) {
                        return;
                    }
                    name = InternalNamingConventions.computeBaseTypeNames(typeName[0], excludedNames);
                    if (name == null) break;
                    tempNames /* !! */  = new char[][]{name};
                }
                default: {
                    ** break;
                }
lbl-1000:
                // 1 sources

                {
                }
            }
        }
        catch (InvalidInputException v4) {}
        if (tempNames /* !! */  == null) {
            tempNames /* !! */  = InternalNamingConventions.computeNames(typeName);
        }
        acceptDefaultName = true;
        i = 0;
        while (i < tempNames /* !! */ .length) {
            tempName = tempNames /* !! */ [i];
            if (dim > 0) {
                length = tempName.length;
                if (tempName[length - 1] == 's') {
                    if (tempName.length > 1 && tempName[length - 2] == 's') {
                        v5 = tempName;
                        tempName = new char[length + 2];
                        System.arraycopy(v5, 0, tempName, 0, length);
                        tempName[length] = 101;
                        tempName[length + 1] = 115;
                    }
                } else if (tempName[length - 1] == 'y') {
                    v6 = tempName;
                    tempName = new char[length + 2];
                    System.arraycopy(v6, 0, tempName, 0, length);
                    tempName[length - 1] = 105;
                    tempName[length] = 101;
                    tempName[length + 1] = 115;
                } else {
                    v7 = tempName;
                    tempName = new char[length + 1];
                    System.arraycopy(v7, 0, tempName, 0, length);
                    tempName[length] = 115;
                }
            }
            unprefixedName = tempName;
            j = 0;
            while (j <= internalPrefix.length) {
                if (j == internalPrefix.length || CharOperation.prefixEquals(CharOperation.subarray(internalPrefix, j, -1), unprefixedName, false)) {
                    tempName = CharOperation.concat(CharOperation.subarray(internalPrefix, 0, j), unprefixedName);
                    if (j != 0) {
                        tempName[j] = ScannerHelper.toUpperCase(tempName[j]);
                    }
                    k = 0;
                    while (k < prefixes /* !! */ .length) {
                        tempName[0] = prefixes /* !! */ [k].length > 0 && ScannerHelper.isLetterOrDigit(prefixes /* !! */ [k][prefixes /* !! */ [k].length - 1]) != false ? ScannerHelper.toUpperCase(tempName[0]) : ScannerHelper.toLowerCase(tempName[0]);
                        prefixName = CharOperation.concat(prefixes /* !! */ [k], tempName);
                        l = 0;
                        while (l < suffixes /* !! */ .length) {
                            block38: {
                                suffixName = CharOperation.concat(prefixName, suffixes /* !! */ [l]);
                                suffixName = InternalNamingConventions.excludeNames(suffixName, prefixName, suffixes /* !! */ [l], excludedNames);
                                try {
                                    nameScanner.setSource(suffixName);
                                    block5 : switch (nameScanner.getNextToken()) {
                                        case 26: {
                                            token = nameScanner.getNextToken();
                                            if (token == 68 && nameScanner.startPosition == suffixName.length) {
                                                InternalNamingConventions.acceptName(suffixName, prefixes /* !! */ [k], suffixes /* !! */ [l], k == 0, l == 0, internalPrefix.length - j, requestor);
                                                acceptDefaultName = false;
                                            }
                                            break;
                                        }
                                        default: {
                                            suffixName = CharOperation.concat(prefixName, String.valueOf(1).toCharArray(), suffixes /* !! */ [l]);
                                            suffixName = InternalNamingConventions.excludeNames(suffixName, prefixName, suffixes /* !! */ [l], excludedNames);
                                            nameScanner.setSource(suffixName);
                                            switch (nameScanner.getNextToken()) {
                                                case 26: {
                                                    token = nameScanner.getNextToken();
                                                    if (token != 68 || nameScanner.startPosition != suffixName.length) break block38;
                                                    InternalNamingConventions.acceptName(suffixName, prefixes /* !! */ [k], suffixes /* !! */ [l], k == 0, l == 0, internalPrefix.length - j, requestor);
                                                    acceptDefaultName = false;
                                                }
                                                default: {
                                                    break block5;
                                                }
                                            }
                                        }
                                    }
                                }
                                catch (InvalidInputException v8) {}
                            }
                            ++l;
                        }
                        ++k;
                    }
                    break;
                }
                ++j;
            }
            ++i;
        }
        if (acceptDefaultName) {
            name = InternalNamingConventions.excludeNames(InternalNamingConventions.DEFAULT_NAME, InternalNamingConventions.DEFAULT_NAME, CharOperation.NO_CHAR, excludedNames);
            requestor.acceptNameWithoutPrefixAndSuffix(name, 0);
        }
    }

    private static void acceptName(char[] name, char[] prefix, char[] suffix, boolean isFirstPrefix, boolean isFirstSuffix, int reusedCharacters, INamingRequestor requestor) {
        if (prefix.length > 0 && suffix.length > 0) {
            requestor.acceptNameWithPrefixAndSuffix(name, isFirstPrefix, isFirstSuffix, reusedCharacters);
        } else if (prefix.length > 0) {
            requestor.acceptNameWithPrefix(name, isFirstPrefix, reusedCharacters);
        } else if (suffix.length > 0) {
            requestor.acceptNameWithSuffix(name, isFirstSuffix, reusedCharacters);
        } else {
            requestor.acceptNameWithoutPrefixAndSuffix(name, reusedCharacters);
        }
    }

    private static char[] computeBaseTypeNames(char firstName, char[][] excludedNames) {
        char[] name = new char[]{firstName};
        int i = 0;
        while (i < excludedNames.length) {
            if (CharOperation.equals(name, excludedNames[i], false)) {
                name[0] = (char)(name[0] + '\u0001');
                if (name[0] > 'z') {
                    name[0] = 97;
                }
                if (name[0] == firstName) {
                    return null;
                }
                i = 0;
            }
            ++i;
        }
        return name;
    }

    private static char[][] computeNames(char[] sourceName) {
        char[][] names = new char[5][];
        int nameCount = 0;
        boolean previousIsUpperCase = false;
        boolean previousIsLetter = true;
        int i = sourceName.length - 1;
        while (i >= 0) {
            char[] name;
            boolean isUpperCase = ScannerHelper.isUpperCase(sourceName[i]);
            boolean isLetter = ScannerHelper.isLetter(sourceName[i]);
            if (isUpperCase && !previousIsUpperCase && previousIsLetter && (name = CharOperation.subarray(sourceName, i, sourceName.length)).length > 1) {
                if (nameCount == names.length) {
                    char[][] cArrayArray = names;
                    names = new char[nameCount * 2][];
                    System.arraycopy(cArrayArray, 0, names, 0, nameCount);
                }
                name[0] = ScannerHelper.toLowerCase(name[0]);
                names[nameCount++] = name;
            }
            previousIsUpperCase = isUpperCase;
            previousIsLetter = isLetter;
            --i;
        }
        if (nameCount == 0) {
            names[nameCount++] = CharOperation.toLowerCase(sourceName);
        }
        char[][] cArrayArray = names;
        names = new char[nameCount][];
        System.arraycopy(cArrayArray, 0, names, 0, nameCount);
        return names;
    }

    private static char[] excludeNames(char[] suffixName, char[] prefixName, char[] suffix, char[][] excludedNames) {
        int count = 2;
        int m = 0;
        while (m < excludedNames.length) {
            if (CharOperation.equals(suffixName, excludedNames[m], false)) {
                suffixName = CharOperation.concat(prefixName, String.valueOf(count++).toCharArray(), suffix);
                m = 0;
                continue;
            }
            ++m;
        }
        return suffixName;
    }

    private static char[] removePrefix(char[] name, char[][] prefixes) {
        char[] withoutPrefixName = name;
        if (prefixes != null) {
            int bestLength = 0;
            int nameLength = name.length;
            int i = 0;
            while (i < prefixes.length) {
                char[] prefix = prefixes[i];
                int prefixLength = prefix.length;
                if (prefixLength <= nameLength) {
                    if (CharOperation.prefixEquals(prefix, name, false) && prefixLength > bestLength) {
                        bestLength = prefixLength;
                    }
                } else {
                    int currLen = 0;
                    while (currLen < nameLength) {
                        if (ScannerHelper.toLowerCase(prefix[currLen]) != ScannerHelper.toLowerCase(name[currLen])) {
                            if (currLen <= bestLength) break;
                            bestLength = currLen;
                            break;
                        }
                        ++currLen;
                    }
                    if (currLen == nameLength && currLen > bestLength) {
                        bestLength = currLen;
                    }
                }
                ++i;
            }
            if (bestLength > 0) {
                withoutPrefixName = bestLength == nameLength ? CharOperation.NO_CHAR : CharOperation.subarray(name, bestLength, nameLength);
            }
        }
        return withoutPrefixName;
    }

    public static final boolean prefixEquals(char[] prefix, char[] name) {
        int max = prefix.length;
        if (name.length < max) {
            return false;
        }
        int i = max;
        while (--i >= 0) {
            if (prefix[i] == name[i]) continue;
            return false;
        }
        return true;
    }
}

