/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.tool;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.lang.model.SourceVersion;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.tool.EclipseFileManager;
import org.eclipse.jdt.internal.compiler.tool.Options;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;

public class EclipseCompiler
extends Main
implements JavaCompiler {
    private static final CompilationUnit[] NO_UNITS = new CompilationUnit[0];
    private HashMap<CompilationUnit, JavaFileObject> javaFileObjectMap;
    private static Set<SourceVersion> SupportedSourceVersions;
    Iterable<? extends JavaFileObject> compilationUnits;
    public DiagnosticListener<? super JavaFileObject> diagnosticListener;
    public JavaFileManager fileManager;
    protected Processor[] processors;

    static {
        EnumSet<SourceVersion> enumSet = EnumSet.range(SourceVersion.RELEASE_0, SourceVersion.RELEASE_6);
        SupportedSourceVersions = Collections.unmodifiableSet(enumSet);
    }

    public EclipseCompiler(PrintWriter out, PrintWriter err, boolean systemExitWhenFinished) {
        super(out, err, systemExitWhenFinished);
    }

    public EclipseCompiler() {
        super(null, null, false);
    }

    /*
     * Exception decompiling
     */
    public boolean call() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void cleanup() {
        this.logger.flush();
        this.logger.close();
        this.processors = null;
        try {
            if (this.fileManager != null) {
                this.fileManager.flush();
            }
        }
        catch (IOException iOException) {}
    }

    public CompilationUnit[] getCompilationUnits() {
        if (this.compilationUnits == null) {
            return NO_UNITS;
        }
        ArrayList<1> units = new ArrayList<1>();
        for (final JavaFileObject javaFileObject : this.compilationUnits) {
            if (javaFileObject.getKind() != JavaFileObject.Kind.SOURCE) {
                throw new IllegalArgumentException();
            }
            String name = javaFileObject.getName();
            name = name.replace('\\', '/');
            CompilationUnit compilationUnit = new CompilationUnit(null, name, null){

                public char[] getContents() {
                    try {
                        return javaFileObject.getCharContent(true).toString().toCharArray();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new AbortCompilationUnit(null, e, null);
                    }
                }
            };
            units.add(compilationUnit);
            this.javaFileObjectMap.put(compilationUnit, javaFileObject);
        }
        CompilationUnit[] compilationUnitArray = new CompilationUnit[units.size()];
        units.toArray(compilationUnitArray);
        return compilationUnitArray;
    }

    public IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            public boolean proceedOnErrors() {
                return false;
            }

            public boolean stopOnFirstError() {
                return false;
            }
        };
    }

    public IProblemFactory getProblemFactory() {
        return new DefaultProblemFactory(){

            public CategorizedProblem createProblem(final char[] originatingFileName, final int problemId, final String[] problemArguments, String[] messageArguments, final int severity, final int startPosition, final int endPosition, final int lineNumber, final int columnNumber) {
                DiagnosticListener<? super JavaFileObject> diagnosticListener = EclipseCompiler.this.diagnosticListener;
                if (diagnosticListener != null) {
                    diagnosticListener.report((Diagnostic<? super JavaFileObject>)new Diagnostic<JavaFileObject>(){

                        @Override
                        public String getCode() {
                            return Integer.toString(problemId);
                        }

                        @Override
                        public long getColumnNumber() {
                            return columnNumber;
                        }

                        @Override
                        public long getEndPosition() {
                            return endPosition;
                        }

                        @Override
                        public Diagnostic.Kind getKind() {
                            if ((severity & 1) != 0) {
                                return Diagnostic.Kind.ERROR;
                            }
                            if ((severity & 0x20) != 0) {
                                return Diagnostic.Kind.WARNING;
                            }
                            if (false) {
                                return Diagnostic.Kind.MANDATORY_WARNING;
                            }
                            return Diagnostic.Kind.OTHER;
                        }

                        @Override
                        public long getLineNumber() {
                            return lineNumber;
                        }

                        @Override
                        public String getMessage(Locale locale) {
                            this.setLocale(locale);
                            return this.getLocalizedMessage(problemId, problemArguments);
                        }

                        @Override
                        public long getPosition() {
                            return startPosition;
                        }

                        @Override
                        public JavaFileObject getSource() {
                            try {
                                if ((this).EclipseCompiler.this.fileManager.hasLocation(StandardLocation.SOURCE_PATH)) {
                                    return (this).EclipseCompiler.this.fileManager.getJavaFileForInput(StandardLocation.SOURCE_PATH, new String(originatingFileName), JavaFileObject.Kind.SOURCE);
                                }
                            }
                            catch (IOException iOException) {}
                            return null;
                        }

                        @Override
                        public long getStartPosition() {
                            return startPosition;
                        }
                    });
                }
                return super.createProblem(originatingFileName, problemId, problemArguments, messageArguments, severity, startPosition, endPosition, lineNumber, columnNumber);
            }
        };
    }

    @Override
    public Set<SourceVersion> getSourceVersions() {
        return SupportedSourceVersions;
    }

    @Override
    public StandardJavaFileManager getStandardFileManager(DiagnosticListener<? super JavaFileObject> diagnosticListener, Locale locale, Charset charset) {
        this.diagnosticListener = diagnosticListener;
        return new EclipseFileManager(this, locale, charset);
    }

    @Override
    public JavaCompiler.CompilationTask getTask(Writer out, JavaFileManager fileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> options, Iterable<String> classes, Iterable<? extends JavaFileObject> compilationUnits) {
        StandardJavaFileManager javaFileManager;
        Iterable<? extends File> location;
        PrintWriter writerOut = null;
        PrintWriter writerErr = null;
        if (out == null) {
            writerOut = new PrintWriter(System.out);
            writerErr = new PrintWriter(System.err);
        } else {
            writerOut = new PrintWriter(out);
            writerErr = new PrintWriter(out);
        }
        this.compilationUnits = compilationUnits;
        this.diagnosticListener = diagnosticListener;
        this.fileManager = fileManager != null ? fileManager : this.getStandardFileManager(diagnosticListener, null, null);
        this.initialize(writerOut, writerErr, false);
        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
        this.options.put("org.eclipse.jdt.core.compiler.source", "1.6");
        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
        ArrayList<String> allOptions = new ArrayList<String>();
        if (options != null) {
            Iterator<String> iterator = options.iterator();
            while (iterator.hasNext()) {
                this.fileManager.handleOption(iterator.next(), iterator);
            }
            for (String string : options) {
                allOptions.add(string);
            }
        }
        if (compilationUnits != null) {
            for (JavaFileObject javaFileObject : compilationUnits) {
                allOptions.add(new File(javaFileObject.toUri()).getAbsolutePath());
            }
        }
        if (classes != null) {
            allOptions.add("-classNames");
            StringBuilder stringBuilder = new StringBuilder();
            int i = 0;
            for (String className : classes) {
                if (i != 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(className);
                ++i;
            }
            allOptions.add(String.valueOf(stringBuilder));
        }
        String[] stringArray = new String[allOptions.size()];
        allOptions.toArray(stringArray);
        try {
            this.configure(stringArray);
        }
        catch (InvalidInputException e) {
            throw new RuntimeException(e);
        }
        if (this.fileManager instanceof StandardJavaFileManager && (location = (javaFileManager = (StandardJavaFileManager)this.fileManager).getLocation(StandardLocation.CLASS_OUTPUT)) != null) {
            this.setDestinationPath(location.iterator().next().getAbsolutePath());
        }
        return new JavaCompiler.CompilationTask(){
            private boolean hasRun = false;

            @Override
            public Boolean call() {
                if (this.hasRun) {
                    throw new IllegalStateException("This task has already been run");
                }
                Boolean value = EclipseCompiler.this.call() ? Boolean.TRUE : Boolean.FALSE;
                this.hasRun = true;
                return value;
            }

            @Override
            public void setLocale(Locale locale) {
                EclipseCompiler.this.setLocale(locale);
            }

            @Override
            public void setProcessors(Iterable<? extends Processor> processors) {
                ArrayList<Processor> temp = new ArrayList<Processor>();
                for (Processor processor : processors) {
                    temp.add(processor);
                }
                Processor[] processorArray = new Processor[temp.size()];
                temp.toArray(processorArray);
                EclipseCompiler.this.processors = processorArray;
            }
        };
    }

    protected void initialize(PrintWriter outWriter, PrintWriter errWriter, boolean systemExit, Map customDefaultOptions) {
        super.initialize(outWriter, errWriter, systemExit, customDefaultOptions);
        this.javaFileObjectMap = new HashMap();
    }

    protected void initializeAnnotationProcessorManager() {
        super.initializeAnnotationProcessorManager();
        if (this.batchCompiler.annotationProcessorManager != null && this.processors != null) {
            this.batchCompiler.annotationProcessorManager.setProcessors((Object[])this.processors);
        } else if (this.processors != null) {
            throw new UnsupportedOperationException("Cannot handle annotation processing");
        }
    }

    @Override
    public int isSupportedOption(String option) {
        return Options.processOptions(option);
    }

    public void outputClassFiles(CompilationResult unitResult) {
        if (unitResult != null && (!unitResult.hasErrors() || this.proceedOnError)) {
            ClassFile[] classFiles = unitResult.getClassFiles();
            boolean generateClasspathStructure = this.fileManager.hasLocation(StandardLocation.CLASS_OUTPUT);
            String currentDestinationPath = this.destinationPath;
            File outputLocation = null;
            if (currentDestinationPath != null) {
                outputLocation = new File(currentDestinationPath);
                outputLocation.mkdirs();
            }
            int i = 0;
            int fileCount = classFiles.length;
            while (i < fileCount) {
                ClassFile classFile = classFiles[i];
                char[] filename = classFile.fileName();
                int length = filename.length;
                char[] relativeName = new char[length + 6];
                System.arraycopy(filename, 0, relativeName, 0, length);
                System.arraycopy(SuffixConstants.SUFFIX_class, 0, relativeName, length, 6);
                CharOperation.replace((char[])relativeName, (char)'/', (char)File.separatorChar);
                String relativeStringName = new String(relativeName);
                if (this.compilerOptions.verbose) {
                    this.out.println(Messages.bind((String)Messages.compilation_write, (Object[])new String[]{String.valueOf(this.exportedClassFilesCounter + 1), relativeStringName}));
                }
                try {
                    JavaFileObject javaFileForOutput = this.fileManager.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, new String(filename), JavaFileObject.Kind.CLASS, this.javaFileObjectMap.get(unitResult.compilationUnit));
                    if (generateClasspathStructure) {
                        if (currentDestinationPath != null) {
                            int index = CharOperation.lastIndexOf((char)File.separatorChar, (char[])relativeName);
                            if (index != -1) {
                                File currentFolder = new File(currentDestinationPath, relativeStringName.substring(0, index));
                                currentFolder.mkdirs();
                            }
                        } else {
                            String path = javaFileForOutput.toUri().getPath();
                            int index = path.lastIndexOf(47);
                            if (index != -1) {
                                File file = new File(path.substring(0, index));
                                file.mkdirs();
                            }
                        }
                    }
                    OutputStream openOutputStream = javaFileForOutput.openOutputStream();
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(openOutputStream);
                    bufferedOutputStream.write(classFile.header, 0, classFile.headerOffset);
                    bufferedOutputStream.write(classFile.contents, 0, classFile.contentsOffset);
                    bufferedOutputStream.flush();
                    bufferedOutputStream.close();
                }
                catch (IOException e) {
                    this.logger.logNoClassFileCreated(currentDestinationPath, relativeStringName, e);
                }
                LookupEnvironment env = this.batchCompiler.lookupEnvironment;
                if (classFile.isShared) {
                    env.classFilePool.release(classFile);
                }
                this.logger.logClassFile(generateClasspathStructure, currentDestinationPath, relativeStringName);
                ++this.exportedClassFilesCounter;
                ++i;
            }
        }
    }

    @Override
    public int run(InputStream in, OutputStream out, OutputStream err, String ... arguments) {
        boolean succeed = new Main(new PrintWriter(new OutputStreamWriter(out)), new PrintWriter(new OutputStreamWriter(err)), true).compile(arguments);
        return succeed ? 0 : -1;
    }

    protected void setPaths(ArrayList bootclasspaths, String sourcepathClasspathArg, ArrayList sourcepathClasspaths, ArrayList classpaths, ArrayList extdirsClasspaths, ArrayList endorsedDirClasspaths, String customEncoding) throws InvalidInputException {
        int n;
        ArrayList fileSystemClasspaths = new ArrayList();
        EclipseFileManager javaFileManager = null;
        StandardJavaFileManager standardJavaFileManager = null;
        if (this.fileManager instanceof EclipseFileManager) {
            javaFileManager = (EclipseFileManager)this.fileManager;
        }
        if (this.fileManager instanceof StandardJavaFileManager) {
            standardJavaFileManager = (StandardJavaFileManager)this.fileManager;
        }
        if (javaFileManager != null && (javaFileManager.flags & 4) == 0 && (javaFileManager.flags & 2) != 0) {
            fileSystemClasspaths.addAll(this.handleEndorseddirs(null));
        }
        Iterable<? extends File> location = null;
        if (standardJavaFileManager != null) {
            location = standardJavaFileManager.getLocation(StandardLocation.PLATFORM_CLASS_PATH);
        }
        if (location != null) {
            for (File file : location) {
                FileSystem.Classpath classpath2 = FileSystem.getClasspath((String)file.getAbsolutePath(), null, null);
                if (classpath2 == null) continue;
                fileSystemClasspaths.add(classpath2);
            }
        }
        if (javaFileManager != null && (javaFileManager.flags & 1) == 0 && (javaFileManager.flags & 2) != 0) {
            fileSystemClasspaths.addAll(this.handleExtdirs(null));
        }
        if ((location = standardJavaFileManager != null ? standardJavaFileManager.getLocation(StandardLocation.SOURCE_PATH) : null) != null) {
            for (File file : location) {
                fileSystemClasspaths.add(FileSystem.getClasspath((String)file.getAbsolutePath(), null, null));
            }
        }
        if ((location = standardJavaFileManager != null ? standardJavaFileManager.getLocation(StandardLocation.CLASS_PATH) : null) != null) {
            for (File file : location) {
                FileSystem.Classpath classpath = FileSystem.getClasspath((String)file.getAbsolutePath(), null, null);
                if (classpath == null) continue;
                fileSystemClasspaths.add(classpath);
            }
        }
        if (this.checkedClasspaths == null) {
            fileSystemClasspaths.addAll(this.handleBootclasspath(null, null));
            fileSystemClasspaths.addAll(this.handleClasspath(null, null));
        }
        if ((n = (fileSystemClasspaths = FileSystem.ClasspathNormalizer.normalize(fileSystemClasspaths)).size()) != 0) {
            this.checkedClasspaths = new FileSystem.Classpath[n];
            int i = 0;
            for (FileSystem.Classpath classpath : fileSystemClasspaths) {
                this.checkedClasspaths[i++] = classpath;
            }
        }
    }
}

