/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ejb.ui.internal.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.actions.BaseAction;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.ClientJARCreationConstants;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;

public abstract class AbstractClientJARAction
extends BaseAction
implements ClientJARCreationConstants {
    protected IProject getProject() {
        IProject project = null;
        Object element = this.selection.getFirstElement();
        if (element instanceof EJBJar) {
            project = ProjectUtilities.getProject((EObject)((EJBJar)element));
        } else if (element instanceof IProject) {
            project = (IProject)element;
        } else if (element instanceof IAdaptable) {
            project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
        }
        return project;
    }

    protected boolean hasClientJar() {
        int projectVersionInt;
        String projectVersion;
        IProject project = this.getProject();
        if (project != null && project.exists() && project.isAccessible() && J2EEProjectUtilities.isEJBProject((IProject)project) && (projectVersion = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)project)) != null && (projectVersionInt = J2EEVersionUtil.convertVersionStringToInt((String)projectVersion)) != 0 && projectVersionInt <= 21) {
            EJBArtifactEdit edit = null;
            try {
                edit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)project);
                if (edit != null && edit.hasEJBClientJARProject()) {
                    return true;
                }
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
        return false;
    }
}

