/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.actions;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.internal.navigator.resources.actions.WorkingSetRootModeActionGroup;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.IExtensionActivationListener;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.INavigatorContentService;

public class WorkingSetActionProvider
extends CommonActionProvider {
    private static final String TAG_CURRENT_WORKING_SET_NAME = "currentWorkingSetName";
    private boolean contributedToViewMenu = false;
    private StructuredViewer viewer;
    private INavigatorContentService contentService;
    private WorkingSetFilterActionGroup workingSetActionGroup;
    private WorkingSetRootModeActionGroup workingSetRootModeActionGroup;
    private Object originalViewerInput = ResourcesPlugin.getWorkspace().getRoot();
    private IExtensionStateModel extensionStateModel;
    private IPropertyChangeListener filterChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            IWorkingSet oldWorkingSet = (IWorkingSet)event.getOldValue();
            IWorkingSet newWorkingSet = (IWorkingSet)event.getNewValue();
            if (newWorkingSet != null && !WorkingSetActionProvider.this.contentService.isActive("org.eclipse.ui.navigator.resources.workingSets")) {
                WorkingSetActionProvider.this.contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.navigator.resources.workingSets"}, false);
                WorkingSetActionProvider.this.contentService.getActivationService().persistExtensionActivations();
            }
            if (WorkingSetActionProvider.this.viewer != null) {
                if (newWorkingSet == null) {
                    WorkingSetActionProvider.this.viewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                } else if (oldWorkingSet != newWorkingSet) {
                    WorkingSetActionProvider.this.viewer.setInput((Object)newWorkingSet);
                }
            }
        }
    };
    private WorkingSetManagerListener managerChangeListener = new WorkingSetManagerListener();
    private IExtensionActivationListener activationListener = new IExtensionActivationListener(){
        private IWorkingSet workingSet;

        public void onExtensionActivation(String aViewerId, String[] theNavigatorExtensionIds, boolean isActive) {
            int i = 0;
            while (i < theNavigatorExtensionIds.length) {
                if ("org.eclipse.ui.navigator.resources.workingSets".equals(theNavigatorExtensionIds[i])) {
                    if (isActive) {
                        WorkingSetActionProvider.this.extensionStateModel = WorkingSetActionProvider.this.contentService.findStateModel("org.eclipse.ui.navigator.resources.workingSets");
                        WorkingSetActionProvider.this.workingSetRootModeActionGroup.setStateModel(WorkingSetActionProvider.this.extensionStateModel);
                        if (this.workingSet != null) {
                            WorkingSetActionProvider.this.viewer.setInput((Object)this.workingSet);
                            WorkingSetActionProvider.this.workingSetActionGroup.setWorkingSet(this.workingSet);
                            WorkingSetActionProvider.this.workingSetRootModeActionGroup.setShowTopLevelWorkingSets(true);
                        }
                        WorkingSetActionProvider.this.managerChangeListener.listen();
                    } else {
                        Object input = WorkingSetActionProvider.this.viewer.getInput();
                        if (input instanceof IWorkingSet) {
                            this.workingSet = (IWorkingSet)input;
                            if (WorkingSetActionProvider.this.viewer != null && input != WorkingSetActionProvider.this.originalViewerInput) {
                                WorkingSetActionProvider.this.viewer.setInput(WorkingSetActionProvider.this.originalViewerInput);
                            }
                        } else {
                            this.workingSet = null;
                        }
                        WorkingSetActionProvider.this.managerChangeListener.ignore();
                        WorkingSetActionProvider.this.workingSetActionGroup.setWorkingSet(null);
                        WorkingSetActionProvider.this.workingSetRootModeActionGroup.setShowTopLevelWorkingSets(false);
                    }
                }
                ++i;
            }
        }
    };

    public void init(ICommonActionExtensionSite aSite) {
        this.viewer = aSite.getStructuredViewer();
        this.contentService = aSite.getContentService();
        this.extensionStateModel = this.contentService.findStateModel("org.eclipse.ui.navigator.resources.workingSets");
        this.workingSetActionGroup = new WorkingSetFilterActionGroup(aSite.getViewSite().getShell(), this.filterChangeListener);
        if (this.extensionStateModel != null) {
            this.workingSetRootModeActionGroup = new WorkingSetRootModeActionGroup(this.viewer, this.extensionStateModel);
        }
        if (this.contentService.isActive("org.eclipse.ui.navigator.resources.workingSets")) {
            this.managerChangeListener.listen();
        }
        this.contentService.getActivationService().addExtensionActivationListener(this.activationListener);
    }

    public void restoreState(IMemento aMemento) {
        super.restoreState(aMemento);
        boolean showWorkingSets = true;
        if (aMemento != null) {
            Integer showWorkingSetsInt = aMemento.getInteger("org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets");
            showWorkingSets = showWorkingSetsInt == null || showWorkingSetsInt == 1;
            this.extensionStateModel.setBooleanProperty("org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets", showWorkingSets);
            this.workingSetRootModeActionGroup.setShowTopLevelWorkingSets(showWorkingSets);
            if (this.viewer != null) {
                String lastWorkingSetName = aMemento.getString(TAG_CURRENT_WORKING_SET_NAME);
                IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                IWorkingSet lastWorkingSet = workingSetManager.getWorkingSet(lastWorkingSetName);
                this.viewer.setInput((Object)lastWorkingSet);
                this.workingSetActionGroup.setWorkingSet(lastWorkingSet);
            }
        } else {
            showWorkingSets = false;
            this.extensionStateModel.setBooleanProperty("org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets", showWorkingSets);
            this.workingSetRootModeActionGroup.setShowTopLevelWorkingSets(showWorkingSets);
        }
    }

    public void saveState(IMemento aMemento) {
        super.saveState(aMemento);
        if (aMemento != null) {
            Object input;
            int showWorkingSets = this.extensionStateModel.getBooleanProperty("org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets") ? 1 : 0;
            aMemento.putInteger("org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets", showWorkingSets);
            if (this.viewer != null && (input = this.viewer.getInput()) instanceof IWorkingSet) {
                IWorkingSet workingSet = (IWorkingSet)input;
                aMemento.putString(TAG_CURRENT_WORKING_SET_NAME, workingSet.getName());
            }
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        if (!this.contributedToViewMenu) {
            try {
                super.fillActionBars(actionBars);
                this.workingSetActionGroup.fillActionBars(actionBars);
                if (this.workingSetRootModeActionGroup != null) {
                    this.workingSetRootModeActionGroup.fillActionBars(actionBars);
                }
            }
            finally {
                this.contributedToViewMenu = true;
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.workingSetActionGroup.dispose();
        if (this.workingSetRootModeActionGroup != null) {
            this.workingSetRootModeActionGroup.dispose();
        }
        this.managerChangeListener.ignore();
        this.contentService.getActivationService().removeExtensionActivationListener(this.activationListener);
    }

    public class WorkingSetManagerListener
    implements IPropertyChangeListener {
        private boolean listening = false;

        public void propertyChange(PropertyChangeEvent event) {
            Object input = WorkingSetActionProvider.this.viewer.getInput();
            if (input instanceof IWorkingSet) {
                IWorkingSet workingSet = (IWorkingSet)input;
                String property = event.getProperty();
                Object newValue = event.getNewValue();
                Object oldValue = event.getOldValue();
                if ("workingSetRemove".equals(property) && oldValue == workingSet) {
                    if (WorkingSetActionProvider.this.viewer != null) {
                        WorkingSetActionProvider.this.viewer.setInput(WorkingSetActionProvider.this.originalViewerInput);
                    }
                } else if ((!"workingSetNameChange".equals(property) || newValue != workingSet) && "workingSetContentChange".equals(property) && newValue == workingSet && WorkingSetActionProvider.this.viewer != null) {
                    WorkingSetActionProvider.this.viewer.refresh();
                }
            }
        }

        public synchronized void listen() {
            if (!this.listening) {
                PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener((IPropertyChangeListener)WorkingSetActionProvider.this.managerChangeListener);
                this.listening = true;
            }
        }

        public synchronized void ignore() {
            if (this.listening) {
                PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener((IPropertyChangeListener)WorkingSetActionProvider.this.managerChangeListener);
                this.listening = false;
            }
        }
    }
}

