/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.figurehandler;

import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.css2.provider.ICSSWidgetProvider;
import org.eclipse.jst.pagedesigner.css2.widget.ButtonWidgetProvider;
import org.eclipse.jst.pagedesigner.css2.widget.CheckboxWidgetProvider;
import org.eclipse.jst.pagedesigner.css2.widget.HiddenProvider;
import org.eclipse.jst.pagedesigner.css2.widget.ImageWidgetProvider;
import org.eclipse.jst.pagedesigner.css2.widget.InputFileWidgetProvider;
import org.eclipse.jst.pagedesigner.css2.widget.RadioWidgetProvider;
import org.eclipse.jst.pagedesigner.css2.widget.TextInputWidgetProvider;
import org.eclipse.jst.pagedesigner.figurehandler.WidgetFigureHandler;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.eclipse.jst.pagedesigner.utils.ImageResolver;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Element;

public class InputFigureHandler
extends WidgetFigureHandler {
    private Image _image;

    void initializeImage(Element node) {
        if (this._image != null) {
            this._image.dispose();
        }
        this._image = ImageResolver.initializeImage(node, "src");
    }

    ImageWidgetProvider getImageProvider(Element node) {
        this.initializeImage(node);
        ImageWidgetProvider provider = new ImageWidgetProvider(this._image, this.getCSSStyle(node));
        return provider;
    }

    ICSSWidgetProvider getButtonProvider(Element node) {
        ButtonWidgetProvider provider = new ButtonWidgetProvider(this.getCSSStyle(node));
        provider.setValue(this.getButtonValue(node));
        return provider;
    }

    ICSSWidgetProvider getFileProvider(Element node) {
        ICSSWidgetProvider textprovider = this.getTextInputProvider(node);
        ButtonWidgetProvider browsebutton = new ButtonWidgetProvider(this.getCSSStyle(node));
        browsebutton.setValue("Browse...");
        InputFileWidgetProvider provider = new InputFileWidgetProvider(this.getCSSStyle(node), textprovider, browsebutton);
        return provider;
    }

    protected Image getHiddenImage() {
        return PDPlugin.getDefault().getImage("palette/GENERIC/small/PD_Palette_Default.gif");
    }

    ICSSWidgetProvider getHiddenProvider(Element node) {
        return new HiddenProvider(this.getHiddenImage(), node);
    }

    ICSSWidgetProvider getPasswordProvider(Element node) {
        TextInputWidgetProvider provider = new TextInputWidgetProvider(this.getCSSStyle(node), 18);
        provider.setSize(this.getSize(node));
        provider.setValue("********");
        return provider;
    }

    ICSSWidgetProvider getTextInputProvider(Element node) {
        TextInputWidgetProvider provider = new TextInputWidgetProvider(this.getCSSStyle(node));
        provider.setSize(this.getSize(node));
        provider.setValue(this.getValue(node));
        return provider;
    }

    private int getSize(Element node) {
        String s = DOMUtil.getAttributeIgnoreCase(node, "size");
        try {
            if (s != null) {
                return Integer.parseInt(s);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return 0;
    }

    private String getValue(Element node) {
        return DOMUtil.getAttributeIgnoreCase(node, "value");
    }

    private String getButtonValue(Element node) {
        String value = this.getValue(node);
        if (value == null) {
            String type = DOMUtil.getAttributeIgnoreCase(node, "type");
            if (type.equalsIgnoreCase("submit")) {
                return "Submit Query";
            }
            if (type.equalsIgnoreCase("reset")) {
                return "Reset";
            }
        }
        return value;
    }

    protected ICSSWidgetProvider initializeWidgetProvider(Element node) {
        this.reset();
        String type = DOMUtil.getAttributeIgnoreCase(node, "type");
        if (type == null) {
            return this.getTextInputProvider(node);
        }
        if (type.equalsIgnoreCase("submit") || type.equalsIgnoreCase("reset") || type.equalsIgnoreCase("button")) {
            return this.getButtonProvider(node);
        }
        if (type.equalsIgnoreCase("image")) {
            return this.getImageProvider(node);
        }
        if (type.equalsIgnoreCase("file")) {
            return this.getFileProvider(node);
        }
        if (type.equalsIgnoreCase("radio")) {
            RadioWidgetProvider provider = new RadioWidgetProvider(this.getCSSStyle(node));
            provider.setChecked(node.hasAttribute("checked"));
            return provider;
        }
        if (type.equalsIgnoreCase("checkbox")) {
            CheckboxWidgetProvider provider = new CheckboxWidgetProvider(this.getCSSStyle(node));
            provider.setChecked(node.hasAttribute("checked"));
            return provider;
        }
        if (type.equalsIgnoreCase("hidden")) {
            return this.getHiddenProvider(node);
        }
        if (type.equalsIgnoreCase("password")) {
            return this.getPasswordProvider(node);
        }
        return this.getTextInputProvider(node);
    }

    private void reset() {
        if (this._image != null) {
            this._image.dispose();
            this._image = null;
        }
    }

    public void dispose() {
        this.reset();
    }
}

