/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.properties.attrgroup;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogFieldGroup;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IDialogFieldApplyListener;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IDialogFieldChangeListener;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.ISupportTextValue;
import org.eclipse.jst.pagedesigner.meta.AttributeDescriptor;
import org.eclipse.jst.pagedesigner.meta.EditorCreator;
import org.eclipse.jst.pagedesigner.meta.IAttributeDescriptor;
import org.eclipse.jst.pagedesigner.meta.IElementDescriptor;
import org.eclipse.jst.pagedesigner.meta.internal.CMRegistry;
import org.eclipse.jst.pagedesigner.properties.attrgroup.IElementContextable;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class AttributeGroup
extends DialogFieldGroup {
    private static final Object KEY_ATTR = "KEY_ATTR";
    private String _uri;
    private String _tagName;
    private IAttributeDescriptor[] _attrs;
    private String _helpContextId;
    private List _dialogFields = null;
    private IDOMElement _ownerElement;

    public AttributeGroup(String uri, String tagName, String[] attrNames) {
        this._uri = uri;
        this._tagName = tagName;
        this._attrs = this.prepareAttributeDescriptors(uri, tagName, attrNames);
    }

    public String getTagName() {
        return this._tagName;
    }

    public String getURI() {
        return this._uri;
    }

    private IAttributeDescriptor[] prepareAttributeDescriptors(String uri, String tagName, String[] attrNames) {
        IAttributeDescriptor[] attrs;
        IElementDescriptor eleDesc = CMRegistry.getInstance().getElementDescriptor(uri, tagName);
        if (eleDesc != null) {
            this._helpContextId = eleDesc.getHelpContextID();
            if (attrNames == null) {
                attrs = eleDesc.getAttributeDescriptors();
            } else {
                attrs = new IAttributeDescriptor[attrNames.length];
                int i = 0;
                while (i < attrs.length) {
                    attrs[i] = eleDesc.getAttributeDescriptor(attrNames[i]);
                    if (attrs[i] == null) {
                        attrs[i] = new AttributeDescriptor(attrNames[i]);
                    }
                    ++i;
                }
            }
        } else if (attrNames == null) {
            attrs = new IAttributeDescriptor[]{};
        } else {
            attrs = new IAttributeDescriptor[attrNames.length];
            int i = 0;
            while (i < attrs.length) {
                attrs[i] = new AttributeDescriptor(attrNames[i]);
                ++i;
            }
        }
        return attrs;
    }

    public IAttributeDescriptor getAttributeDescriptor(DialogField field) {
        Object obj = field.getAttachedData(KEY_ATTR);
        if (obj instanceof IAttributeDescriptor) {
            return (IAttributeDescriptor)obj;
        }
        return null;
    }

    protected DialogField createDialogField(String uri, String tag, IAttributeDescriptor attr) {
        return null;
    }

    public void initialize() {
        if (this._dialogFields == null) {
            this._dialogFields = new ArrayList();
            IAttributeDescriptor[] descriptors = this._attrs;
            int i = 0;
            while (i < descriptors.length) {
                DialogField field = this.createDialogField(this._uri, this._tagName, descriptors[i]);
                if (field == null) {
                    EditorCreator creator = EditorCreator.getInstance();
                    field = creator.createDialogFieldWithWrapper(this._uri, this._tagName, descriptors[i], null);
                }
                field.putAttachedData(KEY_ATTR, (Object)descriptors[i]);
                IDialogFieldApplyListener applyListener = this.getDialogFieldApplyListener(this._uri, this._tagName, descriptors[i]);
                if (applyListener == null) {
                    applyListener = this.getDefaultApplyListener();
                }
                field.setDialogFieldApplyListener(applyListener);
                IDialogFieldChangeListener changeListener = this.getDialogFieldChangeListener(this._uri, this._tagName, descriptors[i]);
                if (changeListener == null) {
                    changeListener = this.getDefaultChangeListener();
                }
                field.setDialogFieldChangeListener(changeListener);
                this._dialogFields.add(field);
                ++i;
            }
        }
    }

    public IDialogFieldApplyListener getDialogFieldApplyListener(String uri, String tag, IAttributeDescriptor attr) {
        return null;
    }

    public IDialogFieldChangeListener getDialogFieldChangeListener(String uri, String tag, IAttributeDescriptor attr) {
        return null;
    }

    public void refreshData() {
        if (this._ownerElement == null) {
            return;
        }
        this.initialize();
        int i = 0;
        int size = this._dialogFields.size();
        while (i < size) {
            DialogField field = (DialogField)this._dialogFields.get(i);
            ISupportTextValue textValue = (ISupportTextValue)field;
            IAttributeDescriptor attr = (IAttributeDescriptor)field.getAttachedData(KEY_ATTR);
            String attrName = attr.getAttributeName();
            String attrValue = this._ownerElement.getAttribute(attrName);
            textValue.setTextWithoutUpdate(attrValue);
            ++i;
        }
    }

    public IDOMElement getElement() {
        return this._ownerElement;
    }

    public void setElementContext(IDOMNode context, IDOMElement owner) {
        this.initialize();
        this._ownerElement = owner;
        if (context != null) {
            int i = 0;
            int size = this._dialogFields.size();
            while (i < size) {
                DialogField field = (DialogField)this._dialogFields.get(i);
                if (field instanceof IElementContextable) {
                    ((IElementContextable)field).setElementContext(context, owner);
                }
                ++i;
            }
        }
        this.refreshData();
    }

    public void layoutDialogFields(FormToolkit toolkit, Composite parent) {
        int numColumns;
        Composite top = toolkit == null ? new Composite(parent, 0) : toolkit.createComposite(parent);
        FillLayout fillLayout = new FillLayout(512);
        parent.setLayout((Layout)fillLayout);
        if (this._helpContextId != null && this._helpContextId.length() > 0) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)top, this._helpContextId);
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns = this.getNumColumns();
        top.setLayout((Layout)layout);
        this.initialize();
        int i = 0;
        int size = this._dialogFields.size();
        while (i < size) {
            DialogField field = (DialogField)this._dialogFields.get(i);
            field.doFillIntoGrid(toolkit, top, numColumns);
            ++i;
        }
        DialogField maxColumnField = null;
        int maxColumn = 0;
        int i2 = 0;
        int size2 = this._dialogFields.size();
        while (i2 < size2) {
            DialogField field = (DialogField)this._dialogFields.get(i2);
            int c = field.getNumberOfControls();
            if (c > maxColumn) {
                maxColumn = c;
                maxColumnField = field;
            }
            ++i2;
        }
        if (maxColumnField != null) {
            maxColumnField.handleGrabHorizontal();
        }
    }

    public int getNumColumns() {
        int columns = 1;
        this.initialize();
        int i = 0;
        int size = this._dialogFields.size();
        while (i < size) {
            DialogField field = (DialogField)this._dialogFields.get(i);
            columns = Math.max(columns, field.getNumberOfControls());
            ++i;
        }
        return columns;
    }

    public IStatus[] validateDialogFields() {
        return null;
    }

    public DialogField[] getDialogFields() {
        this.initialize();
        DialogField[] ret = new DialogField[this._dialogFields.size()];
        this._dialogFields.toArray(ret);
        return ret;
    }

    public DialogField getDialogField(String attrName) {
        this.initialize();
        int i = 0;
        int size = this._dialogFields.size();
        while (i < size) {
            DialogField field = (DialogField)this._dialogFields.get(i);
            IAttributeDescriptor attr = this.getAttributeDescriptor(field);
            if (attr != null && attr.getAttributeName().equals(attrName)) {
                return field;
            }
            ++i;
        }
        return null;
    }
}

