/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.php.internal.core.util.preferences.Key;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.IStatusChangeListener;
import org.eclipse.php.internal.ui.util.CoreUtility;
import org.eclipse.php.internal.ui.util.ScrolledPageContent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public abstract class OptionsConfigurationBlock {
    private static final String SETTINGS_EXPANDED = "expanded";
    protected final ArrayList fCheckBoxes;
    protected final ArrayList fComboBoxes;
    protected final ArrayList fTextBoxes;
    protected final HashMap fLabels;
    protected final ArrayList fExpandedComposites;
    private SelectionListener fSelectionListener;
    private ModifyListener fTextModifyListener;
    protected IStatusChangeListener fContext;
    protected final IProject fProject;
    protected final Key[] fAllKeys;
    private IScopeContext[] fLookupOrder;
    private Shell fShell;
    private final IWorkingCopyManager fManager;
    private IWorkbenchPreferenceContainer fContainer;
    public boolean hasChanges = false;
    private Map fDisabledProjectSettings;

    public OptionsConfigurationBlock(IStatusChangeListener iStatusChangeListener, IProject iProject, Key[] keyArray, IWorkbenchPreferenceContainer iWorkbenchPreferenceContainer) {
        this.fContext = iStatusChangeListener;
        this.fProject = iProject;
        this.fAllKeys = keyArray;
        this.fContainer = iWorkbenchPreferenceContainer;
        this.fManager = iWorkbenchPreferenceContainer == null ? new WorkingCopyManager() : iWorkbenchPreferenceContainer.getWorkingCopyManager();
        this.fLookupOrder = this.fProject != null ? new IScopeContext[]{new ProjectScope(this.fProject), new InstanceScope(), new DefaultScope()} : new IScopeContext[]{new InstanceScope(), new DefaultScope()};
        this.testIfOptionsComplete(keyArray);
        if (this.fProject == null || this.hasProjectSpecificOptions(this.fProject)) {
            this.fDisabledProjectSettings = null;
        } else {
            this.fDisabledProjectSettings = new IdentityHashMap();
            int n = 0;
            while (n < keyArray.length) {
                Key key = keyArray[n];
                this.fDisabledProjectSettings.put(key, key.getStoredValue(this.fLookupOrder, false, this.fManager));
                ++n;
            }
        }
        this.settingsUpdated();
        this.fCheckBoxes = new ArrayList();
        this.fComboBoxes = new ArrayList();
        this.fTextBoxes = new ArrayList(2);
        this.fLabels = new HashMap();
        this.fExpandedComposites = new ArrayList();
    }

    protected final IWorkbenchPreferenceContainer getPreferenceContainer() {
        return this.fContainer;
    }

    protected static Key getKey(String string, String string2) {
        return new Key(string, string2);
    }

    private void testIfOptionsComplete(Key[] keyArray) {
        int n = 0;
        while (n < keyArray.length) {
            if (keyArray[n].getStoredValue(this.fLookupOrder, false, this.fManager) == null) {
                PHPUiPlugin.logErrorMessage("preference option missing: " + keyArray[n] + " (" + this.getClass().getName() + ')');
            }
            ++n;
        }
    }

    protected void settingsUpdated() {
    }

    public void selectOption(String string, String string2) {
        int n = 0;
        while (n < this.fAllKeys.length) {
            Key key = this.fAllKeys[n];
            if (key.getName().equals(string) && key.getQualifier().equals(string2)) {
                this.selectOption(key);
            }
            ++n;
        }
    }

    public void selectOption(Key key) {
        Control control = this.findControl(key);
        if (control != null) {
            ExpandableComposite expandableComposite;
            if (!this.fExpandedComposites.isEmpty() && (expandableComposite = this.getParentExpandableComposite(control)) != null) {
                int n = 0;
                while (n < this.fExpandedComposites.size()) {
                    ExpandableComposite expandableComposite2;
                    expandableComposite2.setExpanded((expandableComposite2 = (ExpandableComposite)this.fExpandedComposites.get(n)) == expandableComposite);
                    ++n;
                }
                this.expandedStateChanged(expandableComposite);
            }
            control.setFocus();
        }
    }

    public final boolean hasProjectSpecificOptions(IProject iProject) {
        if (iProject != null) {
            ProjectScope projectScope = new ProjectScope(iProject);
            Key[] keyArray = this.fAllKeys;
            int n = 0;
            while (n < keyArray.length) {
                if (keyArray[n].getStoredValue((IScopeContext)projectScope, this.fManager) != null) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    protected Shell getShell() {
        return this.fShell;
    }

    protected void setShell(Shell shell) {
        this.fShell = shell;
    }

    protected abstract Control createContents(Composite var1);

    protected Button addCheckBox(Composite composite, String string, Key key, String[] stringArray, int n) {
        ControlData controlData = new ControlData(key, stringArray);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        gridData.horizontalIndent = n;
        Button button = new Button(composite, 32);
        button.setFont(JFaceResources.getDialogFont());
        button.setText(string);
        button.setData((Object)controlData);
        button.setLayoutData((Object)gridData);
        button.addSelectionListener(this.getSelectionListener());
        this.makeScrollableCompositeAware((Control)button);
        String string2 = this.getValue(key);
        button.setSelection(controlData.getSelection(string2) == 0);
        this.fCheckBoxes.add(button);
        return button;
    }

    protected Combo addComboBox(Composite composite, String string, Key key, String[] stringArray, String[] stringArray2, int n) {
        GridData gridData = new GridData(4, 2, true, false, 2, 1);
        gridData.horizontalIndent = n;
        Label label = new Label(composite, 16384);
        label.setFont(JFaceResources.getDialogFont());
        label.setText(string);
        label.setLayoutData((Object)gridData);
        Combo combo = this.newComboControl(composite, key, stringArray, stringArray2);
        combo.setLayoutData((Object)new GridData(256));
        this.fLabels.put(combo, label);
        return combo;
    }

    protected Combo addComboBox(Composite composite, String string, Key key, String[] stringArray, String[] stringArray2) {
        Label label = new Label(composite, 16384);
        label.setFont(JFaceResources.getDialogFont());
        label.setText(string);
        Combo combo = this.newComboControl(composite, key, stringArray, stringArray2);
        combo.setLayoutData((Object)new GridData(256));
        this.fLabels.put(combo, label);
        return combo;
    }

    protected Combo addInversedComboBox(Composite composite, String string, Key key, String[] stringArray, String[] stringArray2, int n) {
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = n;
        gridData.horizontalSpan = 3;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        Combo combo = this.newComboControl(composite2, key, stringArray, stringArray2);
        combo.setFont(JFaceResources.getDialogFont());
        combo.setLayoutData((Object)new GridData(256));
        Label label = new Label(composite2, 16448);
        label.setText(string);
        label.setLayoutData((Object)new GridData());
        this.fLabels.put(combo, label);
        return combo;
    }

    protected Combo newComboControl(Composite composite, Key key, String[] stringArray, String[] stringArray2) {
        ControlData controlData = new ControlData(key, stringArray);
        Combo combo = new Combo(composite, 8);
        combo.setItems(stringArray2);
        combo.setData((Object)controlData);
        combo.addSelectionListener(this.getSelectionListener());
        combo.setFont(JFaceResources.getDialogFont());
        this.makeScrollableCompositeAware((Control)combo);
        String string = this.getValue(key);
        combo.select(controlData.getSelection(string));
        this.fComboBoxes.add(combo);
        return combo;
    }

    protected Text addTextField(Composite composite, String string, Key key, int n, int n2) {
        Label label = new Label(composite, 64);
        label.setText(string);
        label.setFont(JFaceResources.getDialogFont());
        label.setLayoutData((Object)new GridData());
        Text text = new Text(composite, 2052);
        text.setData((Object)key);
        text.setLayoutData((Object)new GridData());
        this.makeScrollableCompositeAware((Control)text);
        this.fLabels.put(text, label);
        String string2 = this.getValue(key);
        if (string2 != null) {
            text.setText(string2);
        }
        text.addModifyListener(this.getTextModifyListener());
        GridData gridData = new GridData(256);
        if (n2 != 0) {
            gridData.widthHint = n2;
        }
        gridData.horizontalIndent = n;
        gridData.horizontalSpan = 2;
        text.setLayoutData((Object)gridData);
        this.fTextBoxes.add(text);
        return text;
    }

    protected ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite composite = control.getParent();
        while (!(composite instanceof ScrolledPageContent) && composite != null) {
            composite = composite.getParent();
        }
        if (composite instanceof ScrolledPageContent) {
            return (ScrolledPageContent)composite;
        }
        return null;
    }

    protected ExpandableComposite getParentExpandableComposite(Control control) {
        Composite composite = control.getParent();
        while (!(composite instanceof ExpandableComposite) && composite != null) {
            composite = composite.getParent();
        }
        if (composite instanceof ExpandableComposite) {
            return (ExpandableComposite)composite;
        }
        return null;
    }

    private void makeScrollableCompositeAware(Control control) {
        ScrolledPageContent scrolledPageContent = this.getParentScrolledComposite(control);
        if (scrolledPageContent != null) {
            scrolledPageContent.adaptChild(control);
        }
    }

    protected ExpandableComposite createStyleSection(Composite composite, String string, int n) {
        ExpandableComposite expandableComposite = new ExpandableComposite(composite, 0, 18);
        expandableComposite.setText(string);
        expandableComposite.setExpanded(false);
        expandableComposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        expandableComposite.setLayoutData((Object)new GridData(4, 4, true, false, n, 1));
        expandableComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent expansionEvent) {
                OptionsConfigurationBlock.this.expandedStateChanged((ExpandableComposite)expansionEvent.getSource());
            }
        });
        this.fExpandedComposites.add(expandableComposite);
        this.makeScrollableCompositeAware((Control)expandableComposite);
        return expandableComposite;
    }

    protected final void expandedStateChanged(ExpandableComposite expandableComposite) {
        ScrolledPageContent scrolledPageContent = this.getParentScrolledComposite((Control)expandableComposite);
        if (scrolledPageContent != null) {
            scrolledPageContent.reflow(true);
        }
    }

    protected void restoreSectionExpansionStates(IDialogSettings iDialogSettings) {
        int n = 0;
        while (n < this.fExpandedComposites.size()) {
            ExpandableComposite expandableComposite = (ExpandableComposite)this.fExpandedComposites.get(n);
            if (iDialogSettings == null) {
                expandableComposite.setExpanded(n == 0);
            } else {
                expandableComposite.setExpanded(iDialogSettings.getBoolean(SETTINGS_EXPANDED + String.valueOf(n)));
            }
            ++n;
        }
    }

    protected void storeSectionExpansionStates(IDialogSettings iDialogSettings) {
        int n = 0;
        while (n < this.fExpandedComposites.size()) {
            ExpandableComposite expandableComposite = (ExpandableComposite)this.fExpandedComposites.get(n);
            iDialogSettings.put(SETTINGS_EXPANDED + String.valueOf(n), expandableComposite.isExpanded());
            ++n;
        }
    }

    protected SelectionListener getSelectionListener() {
        if (this.fSelectionListener == null) {
            this.fSelectionListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    OptionsConfigurationBlock.this.controlChanged(selectionEvent.widget);
                }
            };
        }
        return this.fSelectionListener;
    }

    protected ModifyListener getTextModifyListener() {
        if (this.fTextModifyListener == null) {
            this.fTextModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    OptionsConfigurationBlock.this.textChanged((Text)modifyEvent.widget);
                }
            };
        }
        return this.fTextModifyListener;
    }

    protected void controlChanged(Widget widget) {
        ControlData controlData = (ControlData)widget.getData();
        String string = null;
        if (widget instanceof Button) {
            string = controlData.getValue(((Button)widget).getSelection());
        } else if (widget instanceof Combo) {
            string = controlData.getValue(((Combo)widget).getSelectionIndex());
        } else {
            return;
        }
        String string2 = this.setValue(controlData.getKey(), string);
        this.validateSettings(controlData.getKey(), string2, string);
    }

    protected void textChanged(Text text) {
        Key key = (Key)text.getData();
        String string = text.getText();
        String string2 = this.setValue(key, string);
        this.validateSettings(key, string2, string);
    }

    protected boolean checkValue(Key key, String string) {
        return string.equals(this.getValue(key));
    }

    protected String getValue(Key key) {
        if (this.fDisabledProjectSettings != null) {
            return (String)this.fDisabledProjectSettings.get(key);
        }
        return key.getStoredValue(this.fLookupOrder, false, this.fManager);
    }

    protected boolean getBooleanValue(Key key) {
        return Boolean.valueOf(this.getValue(key));
    }

    protected String setValue(Key key, String string) {
        if (this.fDisabledProjectSettings != null) {
            return this.fDisabledProjectSettings.put(key, string);
        }
        String string2 = this.getValue(key);
        key.setStoredValue(this.fLookupOrder[0], string, this.fManager);
        return string2;
    }

    protected String setValue(Key key, boolean bl) {
        return this.setValue(key, String.valueOf(bl));
    }

    protected String getStoredValue(Key key) {
        return key.getStoredValue(this.fLookupOrder, false, this.fManager);
    }

    protected abstract void validateSettings(Key var1, String var2, String var3);

    protected String[] getTokens(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = stringTokenizer.nextToken().trim();
            ++n2;
        }
        return stringArray;
    }

    private boolean getChanges(IScopeContext iScopeContext, List list) {
        boolean bl = false;
        int n = 0;
        while (n < this.fAllKeys.length) {
            Key key = this.fAllKeys[n];
            String string = key.getStoredValue(iScopeContext, null);
            String string2 = key.getStoredValue(iScopeContext, this.fManager);
            if (string2 == null) {
                if (string != null) {
                    list.add(key);
                    bl |= !string.equals(key.getStoredValue(this.fLookupOrder, true, this.fManager));
                }
            } else if (!string2.equals(string)) {
                list.add(key);
                bl |= string != null || !string2.equals(key.getStoredValue(this.fLookupOrder, true, this.fManager));
            }
            ++n;
        }
        return bl;
    }

    public void useProjectSpecificSettings(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.fDisabledProjectSettings == null;
        if (bl != bl2 && this.fProject != null) {
            if (bl) {
                int n = 0;
                while (n < this.fAllKeys.length) {
                    Key key = this.fAllKeys[n];
                    String string = (String)this.fDisabledProjectSettings.get(key);
                    key.setStoredValue(this.fLookupOrder[0], string, this.fManager);
                    ++n;
                }
                this.fDisabledProjectSettings = null;
                this.updateControls();
            } else {
                this.fDisabledProjectSettings = new IdentityHashMap();
                int n = 0;
                while (n < this.fAllKeys.length) {
                    Key key = this.fAllKeys[n];
                    String string = key.getStoredValue(this.fLookupOrder, false, this.fManager);
                    this.fDisabledProjectSettings.put(key, string);
                    key.setStoredValue(this.fLookupOrder[0], null, this.fManager);
                    ++n;
                }
            }
        }
    }

    public boolean performOk() {
        return this.processChanges(this.fContainer);
    }

    public boolean performApply() {
        return this.processChanges(null);
    }

    protected boolean processChanges(IWorkbenchPreferenceContainer iWorkbenchPreferenceContainer) {
        String[] stringArray;
        IScopeContext iScopeContext = this.fLookupOrder[0];
        ArrayList arrayList = new ArrayList();
        boolean bl = this.getChanges(iScopeContext, arrayList);
        if (arrayList.isEmpty()) {
            this.hasChanges = false;
            return true;
        }
        this.hasChanges = true;
        boolean bl2 = false;
        if (bl && (stringArray = this.getFullBuildDialogStrings(this.fProject == null)) != null) {
            MessageDialog messageDialog = new MessageDialog(this.getShell(), stringArray[0], null, stringArray[1], 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
            int n = messageDialog.open();
            if (n == 0) {
                bl2 = true;
            } else if (n != 1) {
                return false;
            }
        }
        if (bl2) {
            this.prepareForBuild();
        }
        if (iWorkbenchPreferenceContainer != null) {
            if (bl2) {
                iWorkbenchPreferenceContainer.registerUpdateJob(CoreUtility.getBuildJob(this.fProject));
            }
        } else {
            try {
                this.fManager.applyChanges();
            }
            catch (BackingStoreException backingStoreException) {
                PHPUiPlugin.log(backingStoreException);
                return false;
            }
            if (bl2) {
                CoreUtility.getBuildJob(this.fProject).schedule();
            }
        }
        return true;
    }

    protected void prepareForBuild() {
    }

    protected abstract String[] getFullBuildDialogStrings(boolean var1);

    public void performDefaults() {
        int n = 0;
        while (n < this.fAllKeys.length) {
            Key key = this.fAllKeys[n];
            String string = key.getStoredValue(this.fLookupOrder, true, this.fManager);
            this.setValue(key, string);
            ++n;
        }
        this.settingsUpdated();
        this.updateControls();
        this.validateSettings(null, null, null);
    }

    public void performRevert() {
        int n = 0;
        while (n < this.fAllKeys.length) {
            Key key = this.fAllKeys[n];
            String string = key.getStoredValue(this.fLookupOrder, false, null);
            this.setValue(key, string);
            ++n;
        }
        this.settingsUpdated();
        this.updateControls();
        this.validateSettings(null, null, null);
    }

    public void dispose() {
    }

    protected void updateControls() {
        int n = this.fCheckBoxes.size() - 1;
        while (n >= 0) {
            this.updateCheckBox((Button)this.fCheckBoxes.get(n));
            --n;
        }
        n = this.fComboBoxes.size() - 1;
        while (n >= 0) {
            this.updateCombo((Combo)this.fComboBoxes.get(n));
            --n;
        }
        n = this.fTextBoxes.size() - 1;
        while (n >= 0) {
            this.updateText((Text)this.fTextBoxes.get(n));
            --n;
        }
    }

    protected void updateCombo(Combo combo) {
        ControlData controlData = (ControlData)combo.getData();
        String string = this.getValue(controlData.getKey());
        combo.select(controlData.getSelection(string));
    }

    protected void updateCheckBox(Button button) {
        String string;
        ControlData controlData = (ControlData)button.getData();
        button.setSelection(controlData.getSelection(string = this.getValue(controlData.getKey())) == 0);
    }

    protected void updateText(Text text) {
        Key key = (Key)text.getData();
        String string = this.getValue(key);
        if (string != null) {
            text.setText(string);
        }
    }

    protected Button getCheckBox(Key key) {
        int n = this.fCheckBoxes.size() - 1;
        while (n >= 0) {
            Button button = (Button)this.fCheckBoxes.get(n);
            ControlData controlData = (ControlData)button.getData();
            if (key.equals(controlData.getKey())) {
                return button;
            }
            --n;
        }
        return null;
    }

    protected Combo getComboBox(Key key) {
        int n = this.fComboBoxes.size() - 1;
        while (n >= 0) {
            Combo combo = (Combo)this.fComboBoxes.get(n);
            ControlData controlData = (ControlData)combo.getData();
            if (key.equals(controlData.getKey())) {
                return combo;
            }
            --n;
        }
        return null;
    }

    protected Text getTextControl(Key key) {
        int n = this.fTextBoxes.size() - 1;
        while (n >= 0) {
            Text text = (Text)this.fTextBoxes.get(n);
            ControlData controlData = (ControlData)text.getData();
            if (key.equals(controlData.getKey())) {
                return text;
            }
            --n;
        }
        return null;
    }

    protected Control findControl(Key key) {
        Combo combo = this.getComboBox(key);
        if (combo != null) {
            return combo;
        }
        Button button = this.getCheckBox(key);
        if (button != null) {
            return button;
        }
        Text text = this.getTextControl(key);
        if (text != null) {
            return text;
        }
        return null;
    }

    protected void setComboEnabled(Key key, boolean bl) {
        Combo combo = this.getComboBox(key);
        Label label = (Label)this.fLabels.get(combo);
        combo.setEnabled(bl);
        label.setEnabled(bl);
    }

    protected static class ControlData {
        private Key fKey;
        private String[] fValues;

        public ControlData(Key key, String[] stringArray) {
            this.fKey = key;
            this.fValues = stringArray;
        }

        public Key getKey() {
            return this.fKey;
        }

        public String getValue(boolean bl) {
            int n = bl ? 0 : 1;
            return this.fValues[n];
        }

        public String getValue(int n) {
            return this.fValues[n];
        }

        public int getSelection(String string) {
            if (string != null) {
                int n = 0;
                while (n < this.fValues.length) {
                    if (string.equals(this.fValues[n])) {
                        return n;
                    }
                    ++n;
                }
            }
            return this.fValues.length - 1;
        }
    }
}

