/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search.text;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.php.internal.ui.search.text.ResultVisitor;
import org.eclipse.php.internal.ui.search.text.TextSearcher;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchScope;

public class TextSearcherFactory {
    public static final TextSearcher createSearcher(TextSearchEngine textSearchEngine, TextSearchScope textSearchScope, ResultVisitor resultVisitor, Pattern pattern) {
        return new TextSearcher(textSearchEngine, textSearchScope, resultVisitor, pattern);
    }

    public static final TextSearcher createSearcher(TextSearchScope textSearchScope, ResultVisitor resultVisitor, Pattern pattern) {
        TextSearchEngine textSearchEngine = TextSearchEngine.createDefault();
        return TextSearcherFactory.createSearcher(textSearchEngine, textSearchScope, resultVisitor, pattern);
    }

    public static final TextSearcher createSearcher(IResource iResource, ResultVisitor resultVisitor, Pattern pattern) {
        TextSearchScope textSearchScope = TextSearchScope.newSearchScope((IResource[])new IResource[]{iResource}, (Pattern)Pattern.compile(".*"), (boolean)true);
        return TextSearcherFactory.createSearcher(textSearchScope, resultVisitor, pattern);
    }

    public static final TextSearcher createSearcher(IResource iResource, Pattern pattern) {
        ResultVisitor resultVisitor = new ResultVisitor();
        return TextSearcherFactory.createSearcher(iResource, resultVisitor, pattern);
    }

    public static final TextSearcher createSearcher(IResource iResource, String string) {
        Pattern pattern = Pattern.compile(string);
        return TextSearcherFactory.createSearcher(iResource, pattern);
    }
}

