/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.validation.core;

import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;
import org.eclipse.wst.xml.core.internal.validation.core.NestedValidatorContext;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;

public abstract class AbstractNestedValidator
implements IValidatorJob {
    private static final String REFERENCED_FILE_ERROR_OPEN = "referencedFileError(";
    private static final String REFERENCED_FILE_ERROR_CLOSE = ")";
    private static final String REFERENCED_FILE_ERROR = "referencedFileError";
    private static final String FILE_PROTOCOL_NO_SLASH = "file:";
    private static final String FILE_PROTOCOL = "file:///";
    private static final String GROUP_NAME = "groupName";
    private final String GET_FILE = "getFile";
    private final String GET_PROJECT_FILES = "getAllFiles";
    private final String GET_INPUTSTREAM = "inputStream";
    protected static final String COLUMN_NUMBER_ATTRIBUTE = "columnNumber";
    protected static final String SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE = "squiggleSelectionStrategy";
    protected static final String SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE = "squiggleNameOrValue";

    public IStatus validateInJob(IValidationContext context, IReporter reporter) throws ValidationException {
        NestedValidatorContext nestedcontext = new NestedValidatorContext();
        this.setupValidation(nestedcontext);
        String[] fileURIs = context.getURIs();
        if (fileURIs != null && fileURIs.length > 0) {
            int numFiles = fileURIs.length;
            int i = 0;
            while (i < numFiles && !reporter.isCancelled()) {
                Object[] parms;
                IFile file;
                String fileName = fileURIs[i];
                if (fileName != null && (file = (IFile)context.loadModel("getFile", parms = new Object[]{fileName})) != null && AbstractNestedValidator.shouldValidate(file)) {
                    if (context.loadModel("inputStream") instanceof InputStream) {
                        this.validate(file, (InputStream)context.loadModel("inputStream"), reporter, nestedcontext);
                    } else {
                        this.validate(file, null, reporter, nestedcontext);
                    }
                }
                ++i;
            }
        } else {
            Object[] parms = new Object[]{this.getValidatorID()};
            Collection files = (Collection)context.loadModel("getAllFiles", parms);
            Iterator iter = files.iterator();
            while (iter.hasNext() && !reporter.isCancelled()) {
                IFile file = (IFile)iter.next();
                if (!AbstractNestedValidator.shouldValidate(file)) continue;
                this.validate(file, null, reporter, nestedcontext);
            }
        }
        this.teardownValidation(nestedcontext);
        if (reporter.isCancelled()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    protected String getValidatorID() {
        return this.getClass().getName();
    }

    protected void setupValidation(NestedValidatorContext context) {
    }

    protected void teardownValidation(NestedValidatorContext context) {
    }

    public ISchedulingRule getSchedulingRule(IValidationContext arg0) {
        return null;
    }

    public void cleanup(IReporter arg0) {
    }

    public void validate(IValidationContext arg0, IReporter arg1) throws ValidationException {
    }

    private static boolean shouldValidate(IFile file) {
        IFile resource = file;
        do {
            if (!resource.isDerived() && !resource.isTeamPrivateMember() && resource.isAccessible() && resource.getName().charAt(0) != '.') continue;
            return false;
        } while (((resource = resource.getParent()).getType() & 4) == 0);
        return true;
    }

    private void validate(IFile file, InputStream inputstream, IReporter reporter, NestedValidatorContext context) {
        LocalizedMessage message = new LocalizedMessage(4, file.getFullPath().toString());
        reporter.displaySubtask((IValidator)this, (IMessage)message);
        IPath path = file.getLocation();
        String uri = this.createURIForFilePath(path.toString());
        this.clearMarkers(file, (IValidator)this, reporter);
        ValidationReport valreport = this.validate(uri, inputstream, context);
        this.createMarkers(file, valreport.getValidationMessages(), reporter);
        try {
            file.setSessionProperty(ValidationMessage.ERROR_MESSAGE_MAP_QUALIFIED_NAME, (Object)valreport.getNestedMessages());
        }
        catch (CoreException coreException) {
            System.out.println("Unable to set nested messages property.");
        }
    }

    public abstract ValidationReport validate(String var1, InputStream var2, NestedValidatorContext var3);

    private void clearMarkers(IFile iFile, IValidator validator, IReporter reporter) {
        if (this.fileIsAccessible(iFile)) {
            reporter.removeAllMessages(validator, (Object)iFile);
        }
    }

    private boolean fileIsAccessible(IFile file) {
        return file != null && file.exists() && file.getProject().isAccessible();
    }

    private String createURIForFilePath(String filename) {
        if (!filename.startsWith(FILE_PROTOCOL_NO_SLASH)) {
            while (filename.startsWith("/")) {
                filename = filename.substring(1);
            }
            filename = FILE_PROTOCOL + filename;
        }
        return filename;
    }

    public void createMarkers(IFile iFile, ValidationMessage[] valmessages, IReporter reporter) {
        if (!this.fileIsAccessible(iFile)) {
            return;
        }
        int nummessages = valmessages.length;
        int i = 0;
        while (i < nummessages) {
            ValidationMessage validationMessage = valmessages[i];
            String uri = validationMessage.getUri();
            LocalizedMessage message = validationMessage.getSeverity() == ValidationMessage.SEV_LOW ? new LocalizedMessage(2, validationMessage.getMessage(), (IResource)iFile) : new LocalizedMessage(1, validationMessage.getMessage(), (IResource)iFile);
            message.setLineNo(validationMessage.getLineNumber());
            this.addInfoToMessage(validationMessage, (IMessage)message);
            List nestederrors = validationMessage.getNestedMessages();
            if (nestederrors != null && !nestederrors.isEmpty()) {
                message.setGroupName(REFERENCED_FILE_ERROR_OPEN + uri + REFERENCED_FILE_ERROR_CLOSE);
            }
            reporter.addMessage((IValidator)this, (IMessage)message);
            ++i;
        }
        try {
            IMarker[] markers = iFile.findMarkers(null, true, 2);
            int i2 = 0;
            while (i2 < markers.length) {
                IMarker marker = markers[i2];
                String groupName = null;
                try {
                    groupName = (String)marker.getAttribute(GROUP_NAME);
                }
                catch (Exception exception) {}
                if (groupName != null && groupName.startsWith(REFERENCED_FILE_ERROR)) {
                    marker.setAttribute("done", true);
                }
                ++i2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void addInfoToMessage(ValidationMessage validationmessage, IMessage message) {
    }

    class LocalizedMessage
    extends Message {
        private String _message = null;

        public LocalizedMessage(int severity, String messageText) {
            this(severity, messageText, null);
        }

        public LocalizedMessage(int severity, String messageText, IResource targetObject) {
            this(severity, messageText, (Object)targetObject);
        }

        public LocalizedMessage(int severity, String messageText, Object targetObject) {
            super(null, severity, null);
            this.setLocalizedMessage(messageText);
            this.setTargetObject(targetObject);
        }

        public void setLocalizedMessage(String message) {
            this._message = message;
        }

        public String getLocalizedMessage() {
            return this._message;
        }

        public String getText() {
            return this.getLocalizedMessage();
        }

        public String getText(ClassLoader cl) {
            return this.getLocalizedMessage();
        }

        public String getText(Locale l) {
            return this.getLocalizedMessage();
        }

        public String getText(Locale l, ClassLoader cl) {
            return this.getLocalizedMessage();
        }
    }
}

