/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.ide.undo.AbstractWorkspaceOperation;
import org.eclipse.ui.ide.undo.MoveResourcesOperation;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class MoveFilesAndFoldersOperation
extends CopyFilesAndFoldersOperation {
    public MoveFilesAndFoldersOperation(Shell shell) {
        super(shell);
    }

    protected boolean canPerformAutoRename() {
        return false;
    }

    protected void copy(IResource[] resources, IPath destination, IProgressMonitor subMonitor) throws CoreException {
        int i = 0;
        while (i < resources.length) {
            IResource source = resources[i];
            IPath destinationPath = destination.append(source.getName());
            IWorkspace workspace = source.getWorkspace();
            IWorkspaceRoot workspaceRoot = workspace.getRoot();
            IResource existing = workspaceRoot.findMember(destinationPath);
            if (source.getType() == 2 && existing != null) {
                if (this.homogenousResources(source, existing)) {
                    IResource[] children = ((IContainer)source).members();
                    this.copy(children, destinationPath, subMonitor);
                    this.delete(source, subMonitor);
                } else {
                    this.delete(existing, (IProgressMonitor)new SubProgressMonitor(subMonitor, 0));
                    source.move(destinationPath, 34, (IProgressMonitor)new SubProgressMonitor(subMonitor, 0));
                }
            } else {
                if (existing != null) {
                    if (this.homogenousResources(source, existing)) {
                        this.moveExisting(source, existing, subMonitor);
                    } else {
                        this.delete(existing, (IProgressMonitor)new SubProgressMonitor(subMonitor, 0));
                        source.move(destinationPath, 34, (IProgressMonitor)new SubProgressMonitor(subMonitor, 0));
                    }
                } else {
                    source.move(destinationPath, 34, (IProgressMonitor)new SubProgressMonitor(subMonitor, 0));
                }
                subMonitor.worked(1);
                if (subMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
            ++i;
        }
    }

    protected String getDeepCheckQuestion(IResource source) {
        return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_deepMoveQuestion, (Object)source.getFullPath().makeRelative());
    }

    protected String getOperationTitle() {
        return IDEWorkbenchMessages.MoveFilesAndFoldersOperation_operationTitle;
    }

    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.MoveFilesAndFoldersOperation_problemMessage;
    }

    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.MoveFilesAndFoldersOperation_moveFailedTitle;
    }

    protected boolean getValidateConflictSource() {
        return true;
    }

    private void moveExisting(IResource source, IResource existing, IProgressMonitor subMonitor) throws CoreException {
        IFile sourceFile;
        IFile existingFile = this.getFile(existing);
        if (existingFile != null && (sourceFile = this.getFile(source)) != null) {
            existingFile.setContents(sourceFile.getContents(), 2, (IProgressMonitor)new SubProgressMonitor(subMonitor, 0));
            this.delete((IResource)sourceFile, subMonitor);
        }
    }

    public String validateDestination(IContainer destination, IResource[] sourceResources) {
        IPath destinationLocation = destination.getLocation();
        int i = 0;
        while (i < sourceResources.length) {
            IResource sourceResource = sourceResources[i];
            if (sourceResource.getParent().equals((Object)destination)) {
                return NLS.bind((String)IDEWorkbenchMessages.MoveFilesAndFoldersOperation_sameSourceAndDest, (Object)sourceResource.getName());
            }
            if (destinationLocation != null) {
                IPath sourceLocation = sourceResource.getLocation();
                IPath destinationResource = destinationLocation.append(sourceResource.getName());
                if (sourceLocation != null && sourceLocation.isPrefixOf(destinationResource)) {
                    return NLS.bind((String)IDEWorkbenchMessages.MoveFilesAndFoldersOperation_sameSourceAndDest, (Object)sourceResource.getName());
                }
            }
            ++i;
        }
        return super.validateDestination(destination, sourceResources);
    }

    protected boolean isMove() {
        return true;
    }

    protected AbstractWorkspaceOperation getUndoableCopyOrMoveOperation(IResource[] resources, IPath destinationPath) {
        return new MoveResourcesOperation(resources, destinationPath, IDEWorkbenchMessages.CopyFilesAndFoldersOperation_moveTitle);
    }
}

