/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.content;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinitionRegistry;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.services.IVirtualNodeServiceFactory;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.virtual.IKnownConnectionNode;
import org.eclipse.datatools.connectivity.sqm.core.ui.services.IDataToolsUIServiceManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.content.ServerExplorerConfiguration;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.providers.ServerExplorerManager;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IServerStatusDecorationService;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IServicesManager;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.util.resources.ResourceLoader;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class ServerExplorerInitializer {
    private static final ResourceLoader resourceLoader = ResourceLoader.INSTANCE;
    private static final String SCHEMA_NODE = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.SCHEMA");
    private static final String DATABASE = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.DATABASE");
    private static final String PLUGIN_DIR = "Plugin_Directory/";
    private static final String PLUGIN_STATE_LOCATION = "Plugin_State_Location";
    private static final IVirtualNodeServiceFactory virtualNodeFactory = IDataToolsUIServiceManager.INSTANCE.getVirtualNodeServiceFactory();
    private static final DatabaseDefinitionRegistry defRegistry = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry();
    private ConnectionInfo info;

    private IConnectionNode getServerNode(ConnectionInfo info) {
        IConnectionNode connection = null;
        IKnownConnectionNode serverNode = IServicesManager.INSTANCE.getServerExplorerContentService().getKnownServerNode();
        Object[] connections = serverNode.getChildrenArray();
        int i = 0;
        int n = connections.length;
        while (i < n) {
            connection = (IConnectionNode)connections[i];
            if (connection.getName().equals(info.getName())) {
                return connection;
            }
            ++i;
        }
        return null;
    }

    private void addNewDatabases(IConnectionNode serverNode, Database database) {
        IServicesManager.INSTANCE.getServerExplorerContentService().addNode(serverNode, database);
    }

    private void saveNewDatabaseConnection(ConnectionInfo connectionInfo, Database database, IConnectionNode serverNode) {
        try {
            connectionInfo.setDatabaseName(database.getName());
            new ServerExplorerConfiguration().save(connectionInfo);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean displayNewConnection(String serverName, ConnectionInfo connectionInfo) {
        IConnectionNode node = this.getServerNode(connectionInfo);
        if (node == null) {
            return this.displayNewConnection(serverName, connectionInfo, true);
        }
        IServicesManager.INSTANCE.getServerExplorerContentService().connectServer(node);
        IServerStatusDecorationService service = IServicesManager.INSTANCE.getServerStatusDecorationService();
        if (service != null) {
            service.refreshDecoration(new Object[]{node});
        }
        return true;
    }

    private boolean displayNewConnection(String serverName, ConnectionInfo connectionInfo, boolean save) {
        IConnectionNode server = virtualNodeFactory.makeConnectionNode(connectionInfo.getName(), connectionInfo.getName(), (Object)ServerExplorerManager.INSTANCE.getRootKnownServerNode(), connectionInfo);
        IServicesManager.INSTANCE.getServerExplorerContentService().addKnownServer(server);
        return true;
    }

    private String substitutePluginDirectory(String logicalPath, IConfigurationElement element) {
        try {
            return logicalPath.replaceFirst(PLUGIN_DIR, Platform.resolve((URL)Platform.getBundle((String)element.getDeclaringExtension().getNamespace()).getEntry("/")).getPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isBundleActivated(IConfigurationElement element) {
        try {
            Bundle bundle = Platform.getBundle((String)element.getDeclaringExtension().getNamespace());
            if (bundle.getState() == 4) {
                bundle.start();
            }
            return bundle.getState() == 32;
        }
        catch (BundleException e) {
            e.printStackTrace();
            return false;
        }
    }

    private String substituteLocationDirectory(String logicalPath, IConfigurationElement element) {
        String stateLocation = Platform.getStateLocation((Bundle)Platform.getBundle((String)element.getDeclaringExtension().getNamespace())).toOSString();
        int index = logicalPath.indexOf(PLUGIN_STATE_LOCATION);
        if (index != -1) {
            logicalPath = String.valueOf(logicalPath.substring(0, index)) + stateLocation + logicalPath.substring(index + PLUGIN_STATE_LOCATION.length());
        }
        return logicalPath;
    }

    private ConnectionInfo getConnectionInfo(String product, String version, String databaseName) {
        return null;
    }

    private void enableLocalDatabase(IConfigurationElement[] configElements, String user, String password, String loadingPath, String driverClassName) {
    }

    public void loadLocalRegisteredDatabases() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.datatools.connectivity.sqm.server.ui", "ServerExplorerInitializationProvider");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                if (configElements[j].getName().equals("server")) {
                    String user = configElements[j].getAttribute("user");
                    String password = configElements[j].getAttribute("password");
                    String loadingPath = configElements[j].getAttribute("loadingPath");
                    String driverClassName = configElements[j].getAttribute("driverClassName");
                    String serverName = configElements[j].getAttribute("serverName");
                    this.enableLocalDatabase(configElements[j].getChildren("database"), user, password, loadingPath, driverClassName);
                }
                ++j;
            }
            ++i;
        }
    }
}

