/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.data.internal.core.load;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.data.internal.core.DataCorePlugin;
import org.eclipse.datatools.sqltools.data.internal.core.common.data.DataDeserializer;
import org.eclipse.datatools.sqltools.data.internal.core.common.data.PreparedStatementWriter;
import org.eclipse.datatools.sqltools.data.internal.core.load.DataFormatException;

public class TableLoader {
    protected Table table;
    protected Connection con = null;
    protected String tableName = null;
    protected PreparedStatement insertStmt = null;
    protected int[] colTypes;
    protected String[] colNames;
    protected int deletedRows = 0;
    protected int insertedRows = 0;
    protected int failedRows = 0;
    protected HashSet errorColumns = new HashSet();
    protected String failedError;

    public TableLoader(Table table) {
        this.table = table;
    }

    public void open() throws SQLException {
        this.con = ((ICatalogObject)this.table).getConnection();
        this.tableName = DataCorePlugin.getQualifiedTableName(this.table);
        String q = "insert into " + this.tableName + " values(?";
        for (int i = 0; i < this.table.getColumns().size() - 1; ++i) {
            q = q + ",?";
        }
        q = q + ")";
        this.insertStmt = this.con.prepareStatement(q);
        Statement stmt = this.con.createStatement();
        ResultSetMetaData md = stmt.executeQuery("select * from " + this.tableName).getMetaData();
        int cc = md.getColumnCount();
        this.colNames = new String[cc];
        this.colTypes = new int[cc];
        for (int i = 0; i < this.colNames.length; ++i) {
            this.colNames[i] = md.getColumnName(i + 1);
            this.colTypes[i] = md.getColumnType(i + 1);
        }
        stmt.close();
    }

    public void close() throws SQLException {
        if (this.insertStmt != null) {
            this.insertStmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emptyTable() throws SQLException {
        Statement st = null;
        try {
            st = this.con.createStatement();
            String q = "delete from " + this.tableName;
            this.deletedRows = st.executeUpdate(q);
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    public void loadRow(String[] row) throws SQLException, DataFormatException, IOException {
        if (row.length != this.table.getColumns().size()) {
            throw new DataFormatException("Unexpected number of values");
        }
        try {
            for (int i = 0; i < this.colTypes.length; ++i) {
                Object o = DataDeserializer.deserialize(row[i], this.colTypes[i]);
                this.setVal(o, this.insertStmt, i);
            }
            this.insertStmt.executeUpdate();
            ++this.insertedRows;
        }
        catch (Exception ex) {
            ++this.failedRows;
            this.failedError = ex.toString();
        }
    }

    public void setVal(Object val, PreparedStatement pst, int column) throws SQLException, IOException {
        try {
            PreparedStatementWriter.write(pst, column, this.colTypes[column], val);
        }
        catch (Exception ex) {
            this.errorColumns.add(this.colNames[column]);
            pst.setNull(column + 1, this.colTypes[column]);
        }
    }

    public int getDeletedRows() {
        return this.deletedRows;
    }

    public int getFailedRows() {
        return this.failedRows;
    }

    public int getInsertedRows() {
        return this.insertedRows;
    }

    public HashSet getErrorColumns() {
        return this.errorColumns;
    }

    public String getFailedRowError() {
        return this.failedError;
    }
}

