/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis2.consumption.ui.preferences;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jst.ws.axis2.core.context.Axis2EmitterContext;
import org.eclipse.jst.ws.axis2.core.plugin.WebServiceAxis2CorePlugin;
import org.eclipse.jst.ws.axis2.core.plugin.messages.Axis2CoreUIMessages;
import org.eclipse.jst.ws.axis2.core.utils.Axis2CoreUtils;
import org.eclipse.jst.ws.axis2.core.utils.RuntimePropertyUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class Axis2RuntimePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button browseButton;
    private Text axis2Path;
    private Text statusLabel;
    private IStatus status = Status.OK_STATUS;
    private boolean webappExist = false;
    private boolean isWar = false;
    private String statusBanner = null;
    Axis2EmitterContext context;
    private Combo aarExtensionCombo;
    private Combo serviceDatabindingCombo;
    private Combo clientDatabindingCombo;

    protected Control createContents(Composite superparent) {
        this.context = WebServiceAxis2CorePlugin.getDefault().getAxisEmitterContext();
        this.status = Status.OK_STATUS;
        final Composite mainComp = new Composite(superparent, 0);
        mainComp.setLayout((Layout)new GridLayout());
        mainComp.setLayoutData((Object)new GridData(1808));
        TabFolder axis2PreferenceTab = new TabFolder(mainComp, 0);
        axis2PreferenceTab.setLayoutData((Object)new GridData(1808));
        TabItem runtimeInstalLocationItem = new TabItem(axis2PreferenceTab, 0);
        runtimeInstalLocationItem.setText(Axis2CoreUIMessages.AXIS2_RUNTIME);
        runtimeInstalLocationItem.setToolTipText(Axis2CoreUIMessages.AXIS2_RUNTIME_TOOLTIP);
        final Composite runtimeGroup = new Composite((Composite)axis2PreferenceTab, 0);
        runtimeInstalLocationItem.setControl((Control)runtimeGroup);
        runtimeGroup.setToolTipText(Axis2CoreUIMessages.AXIS2_RUNTIME_TOOLTIP);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 10;
        runtimeGroup.setLayout((Layout)layout);
        runtimeGroup.setLayoutData((Object)new GridData(1808));
        Label label = new Label(runtimeGroup, 0);
        label.setText(Axis2CoreUIMessages.AXIS2_RUNTIME_LOCATION);
        this.axis2Path = new Text(runtimeGroup, 2048);
        String serverPath = null;
        if (this.context.getAxis2RuntimeLocation() != null) {
            serverPath = this.context.getAxis2RuntimeLocation();
            this.axis2Path.setText(serverPath);
        }
        this.webappExist = this.runtimeExist(serverPath);
        if (this.isWar) {
            this.updateWarStatus(true);
        } else {
            this.updateWarStatus(false);
        }
        GridData gd = new GridData(768);
        gd.minimumWidth = 40;
        this.axis2Path.setLayoutData((Object)gd);
        this.axis2Path.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Axis2RuntimePreferencePage.this.context.setAxis2RuntimeLocation(Axis2RuntimePreferencePage.this.axis2Path.getText());
                Axis2RuntimePreferencePage.this.webappExist = Axis2RuntimePreferencePage.this.runtimeExist(Axis2RuntimePreferencePage.this.axis2Path.getText());
                Axis2RuntimePreferencePage.this.storeValues();
                Axis2RuntimePreferencePage.this.status = RuntimePropertyUtils.writeServerPathToPropertiesFile((String)Axis2RuntimePreferencePage.this.axis2Path.getText());
                if (Axis2RuntimePreferencePage.this.webappExist) {
                    Axis2RuntimePreferencePage.this.status = Status.OK_STATUS;
                    Axis2RuntimePreferencePage.this.statusUpdate(true);
                } else {
                    Axis2RuntimePreferencePage.this.status = Status.CANCEL_STATUS;
                    Axis2RuntimePreferencePage.this.statusUpdate(false);
                }
                runtimeGroup.layout();
            }
        });
        this.browseButton = new Button(runtimeGroup, 0);
        this.browseButton.setText(Axis2CoreUIMessages.LABEL_BROUSE);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Axis2RuntimePreferencePage.this.handleBrowse(mainComp.getShell());
            }
        });
        if (this.axis2Path.getText().equals("")) {
            this.status = new Status(4, "id", 0, Axis2CoreUIMessages.ERROR_INVALID_AXIS2_SERVER_LOCATION, null);
        }
        Label separator = new Label(runtimeGroup, 0);
        gd = new GridData();
        gd.horizontalSpan = 3;
        separator.setText(" ");
        separator.setLayoutData((Object)gd);
        this.statusLabel = new Text(runtimeGroup, 0x1000008);
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 2;
        this.statusLabel.setLayoutData((Object)gd);
        this.statusBanner = this.axis2Path.getText().equals("") ? Axis2CoreUIMessages.LABEL_AXIS2_RUNTIME_NOT_EXIT : (!this.axis2Path.getText().equals("") && !this.webappExist ? Axis2CoreUIMessages.LABEL_AXIS2_RUNTIME_LOAD_ERROR : Axis2CoreUIMessages.LABEL_AXIS2_RUNTIME_LOAD);
        this.statusLabel.setText(this.statusBanner);
        this.webappExist = this.runtimeExist(this.axis2Path.getText());
        TabItem codegenPreferencesItem = new TabItem(axis2PreferenceTab, 0);
        codegenPreferencesItem.setText(Axis2CoreUIMessages.AXIS2_PREFERENCES);
        codegenPreferencesItem.setToolTipText(Axis2CoreUIMessages.AXIS2_PREFERENCES_TOOLTIP);
        Composite codegenGroup = new Composite((Composite)axis2PreferenceTab, 0);
        codegenPreferencesItem.setControl((Control)codegenGroup);
        codegenGroup.setToolTipText(Axis2CoreUIMessages.AXIS2_PREFERENCES_TOOLTIP);
        layout = new GridLayout();
        codegenGroup.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.marginHeight = 10;
        gd = new GridData(1808);
        codegenGroup.setLayoutData((Object)gd);
        Text serviceCodegenLabel = new Text(codegenGroup, 8);
        serviceCodegenLabel.setText(Axis2CoreUIMessages.LABEL_WEB_SERVICE_CODEGEN);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        serviceCodegenLabel.setLayoutData((Object)gd);
        Label databindingLabel = new Label(codegenGroup, 0);
        databindingLabel.setText(Axis2CoreUIMessages.LABEL_DATABINDING);
        String[] databindingItems = new String[]{this.context.getServiceDatabinding().toUpperCase()};
        this.serviceDatabindingCombo = new Combo(codegenGroup, 2060);
        this.serviceDatabindingCombo.setItems(databindingItems);
        this.serviceDatabindingCombo.select(0);
        this.context.setServiceDatabinding(this.serviceDatabindingCombo.getItem(0));
        this.serviceDatabindingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Axis2RuntimePreferencePage.this.context.setServiceDatabinding(Axis2RuntimePreferencePage.this.serviceDatabindingCombo.getItem(Axis2RuntimePreferencePage.this.serviceDatabindingCombo.getSelectionIndex()));
            }
        });
        final Button generateServerSideInterfaceCheckBoxButton = new Button(codegenGroup, 32);
        generateServerSideInterfaceCheckBoxButton.setText(Axis2CoreUIMessages.LABEL_GENERATE_SERVERSIDE_INTERFACE);
        generateServerSideInterfaceCheckBoxButton.setSelection(this.context.isServiceInterfaceSkeleton());
        generateServerSideInterfaceCheckBoxButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2RuntimePreferencePage.this.context.setServiceInterfaceSkeleton(generateServerSideInterfaceCheckBoxButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        generateServerSideInterfaceCheckBoxButton.setLayoutData((Object)gd);
        final Button generateAllCheckBoxButton = new Button(codegenGroup, 32);
        generateAllCheckBoxButton.setSelection(this.context.isServiceGenerateAll());
        generateAllCheckBoxButton.setText(Axis2CoreUIMessages.LABEL_GENERATE_ALL);
        generateAllCheckBoxButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2RuntimePreferencePage.this.context.setServiceGenerateAll(generateAllCheckBoxButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        generateAllCheckBoxButton.setLayoutData((Object)gd);
        Label seperatorLabel0 = new Label(codegenGroup, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.verticalIndent = 5;
        seperatorLabel0.setLayoutData((Object)gd);
        Text clientCodegenLabel = new Text(codegenGroup, 8);
        clientCodegenLabel.setText(Axis2CoreUIMessages.LABEL_WEB_SERVICE_CLIENT_CODEGEN);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.verticalIndent = 5;
        clientCodegenLabel.setLayoutData((Object)gd);
        Label clientLabel = new Label(codegenGroup, 256);
        clientLabel.setText(Axis2CoreUIMessages.LABEL_CLIENT_SIDE);
        final Button syncAndAsyncRadioButton = new Button(codegenGroup, 16);
        syncAndAsyncRadioButton.setText(Axis2CoreUIMessages.LABEL_SYNC_AND_ASYNC);
        syncAndAsyncRadioButton.setVisible(true);
        syncAndAsyncRadioButton.setSelection(!this.context.isSync() && !this.context.isAsync() ? true : this.context.isSync() && this.context.isAsync());
        syncAndAsyncRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2RuntimePreferencePage.this.context.setAsync(syncAndAsyncRadioButton.getSelection());
                Axis2RuntimePreferencePage.this.context.setSync(syncAndAsyncRadioButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(codegenGroup, 0);
        final Button syncOnlyRadioButton = new Button(codegenGroup, 16);
        syncOnlyRadioButton.setText(Axis2CoreUIMessages.LABEL_SYNC);
        syncOnlyRadioButton.setSelection(this.context.isSync() && !this.context.isAsync());
        syncOnlyRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2RuntimePreferencePage.this.context.setAsync(!syncOnlyRadioButton.getSelection());
                Axis2RuntimePreferencePage.this.context.setSync(syncOnlyRadioButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(codegenGroup, 0);
        final Button asyncOnlyRadioButton = new Button(codegenGroup, 16);
        asyncOnlyRadioButton.setText(Axis2CoreUIMessages.LABEL_ASYNC);
        asyncOnlyRadioButton.setSelection(this.context.isAsync() && !this.context.isSync());
        asyncOnlyRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2RuntimePreferencePage.this.context.setAsync(asyncOnlyRadioButton.getSelection());
                Axis2RuntimePreferencePage.this.context.setSync(!asyncOnlyRadioButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label clientDatabindingLabel = new Label(codegenGroup, 0);
        clientDatabindingLabel.setText(Axis2CoreUIMessages.LABEL_DATABINDING);
        this.clientDatabindingCombo = new Combo(codegenGroup, 2060);
        this.clientDatabindingCombo.setItems(databindingItems);
        this.clientDatabindingCombo.select(0);
        this.context.setClientDatabinding(this.clientDatabindingCombo.getItem(0));
        this.clientDatabindingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Axis2RuntimePreferencePage.this.context.setClientDatabinding(Axis2RuntimePreferencePage.this.clientDatabindingCombo.getItem(Axis2RuntimePreferencePage.this.clientDatabindingCombo.getSelectionIndex()));
            }
        });
        final Button clientTestCaseCheckBoxButton = new Button(codegenGroup, 32);
        clientTestCaseCheckBoxButton.setText(Axis2CoreUIMessages.LABEL_GENERATE_TESTCASE_CAPTION);
        clientTestCaseCheckBoxButton.setSelection(this.context.isClientTestCase());
        clientTestCaseCheckBoxButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2RuntimePreferencePage.this.context.setClientTestCase(clientTestCaseCheckBoxButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        clientTestCaseCheckBoxButton.setLayoutData((Object)gd);
        final Button clientGenerateAllCheckBoxButton = new Button(codegenGroup, 32);
        clientGenerateAllCheckBoxButton.setSelection(this.context.isClientGenerateAll());
        clientGenerateAllCheckBoxButton.setText(Axis2CoreUIMessages.LABEL_GENERATE_ALL);
        clientGenerateAllCheckBoxButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2RuntimePreferencePage.this.context.setClientGenerateAll(clientGenerateAllCheckBoxButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        clientGenerateAllCheckBoxButton.setLayoutData((Object)gd);
        Label seperatorLabel11 = new Label(codegenGroup, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.verticalIndent = 5;
        seperatorLabel11.setLayoutData((Object)gd);
        Text aarLabel = new Text(codegenGroup, 8);
        aarLabel.setText(Axis2CoreUIMessages.LABEL_WEB_SERVICE_AAR);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.verticalIndent = 5;
        aarLabel.setLayoutData((Object)gd);
        Label aarExtentionLabel = new Label(codegenGroup, 0);
        aarExtentionLabel.setText(Axis2CoreUIMessages.LABEL_AAR_EXTENTION);
        String[] aarExtentionItems = new String[]{"aar"};
        this.aarExtensionCombo = new Combo(codegenGroup, 2060);
        this.aarExtensionCombo.setItems(aarExtentionItems);
        this.aarExtensionCombo.select(0);
        this.context.setAarExtention(this.aarExtensionCombo.getItem(0));
        this.aarExtensionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = Axis2RuntimePreferencePage.this.aarExtensionCombo.getSelectionIndex();
                Axis2RuntimePreferencePage.this.context.setAarExtention(Axis2RuntimePreferencePage.this.aarExtensionCombo.getItem(index));
            }
        });
        axis2PreferenceTab.setEnabled(true);
        axis2PreferenceTab.setVisible(true);
        return mainComp;
    }

    public void init(IWorkbench workbench) {
    }

    private void handleBrowse(Shell parent) {
        DirectoryDialog fileDialog = new DirectoryDialog(parent);
        String fileName = fileDialog.open();
        if (fileName != null) {
            this.axis2Path.setText(fileName);
            this.context.setAxis2RuntimeLocation(this.axis2Path.getText());
            if (this.isWar) {
                this.updateWarStatus(true);
            } else {
                this.updateWarStatus(false);
            }
        }
    }

    private void statusUpdate(boolean status) {
        if (this.statusLabel != null) {
            if (!this.axis2Path.getText().equals("")) {
                if (status) {
                    this.statusLabel.setText(Axis2CoreUIMessages.LABEL_AXIS2_RUNTIME_LOAD);
                    this.setErrorMessage(null);
                } else {
                    this.statusLabel.setText(Axis2CoreUIMessages.LABEL_AXIS2_RUNTIME_LOAD_ERROR);
                }
            } else {
                this.statusLabel.setText(Axis2CoreUIMessages.LABEL_AXIS2_RUNTIME_NOT_EXIT);
            }
        }
    }

    private boolean runtimeExist(String path) {
        this.isWar = false;
        File axis2HomeDir = new File(path);
        if (axis2HomeDir.isDirectory()) {
            String axis2LibPath = Axis2CoreUtils.addAnotherNodeToPath((String)axis2HomeDir.getAbsolutePath(), (String)"lib");
            String axis2WebappPath = Axis2CoreUtils.addAnotherNodeToPath((String)axis2HomeDir.getAbsolutePath(), (String)"webapp");
            if (new File(axis2LibPath).isDirectory() && new File(axis2WebappPath).isDirectory()) {
                this.statusUpdate(true);
                return true;
            }
            String axis2WarPath = Axis2CoreUtils.addAnotherNodeToPath((String)path, (String)"axis2.war");
            if (new File(axis2WarPath).isFile()) {
                this.isWar = true;
                this.statusUpdate(true);
                return true;
            }
            this.statusUpdate(false);
            return false;
        }
        this.statusUpdate(false);
        return false;
    }

    private void updateWarStatus(boolean status) {
        RuntimePropertyUtils.writeWarStausToPropertiesFile((boolean)status);
    }

    private void storeValues() {
        this.context.setAxis2RuntimeLocation(this.axis2Path.getText());
    }
}

