/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.launching;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ApplicationFileViewerFilter
extends ViewerFilter {
    protected String[] validExtensions;
    protected String[] requiredNatures;

    public ApplicationFileViewerFilter(String[] stringArray, String[] stringArray2) {
        this.requiredNatures = stringArray;
        this.validExtensions = stringArray2;
    }

    public boolean select(Viewer viewer, Object object, Object object2) {
        return this.isValid(object2);
    }

    public boolean isValid(Object object) {
        if (IFile.class.isInstance(object)) {
            return this.isValidFile((IFile)object);
        }
        if (IContainer.class.isInstance(object)) {
            return this.isValidDirectory((IContainer)object);
        }
        return false;
    }

    public boolean isValidFile(IFile iFile) {
        String string = iFile.getFileExtension();
        int n = 0;
        while (n < this.validExtensions.length) {
            if (this.validExtensions[n].equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isValidDirectory(IContainer iContainer) {
        try {
            return this.projectHasRequiredNatures(iContainer.getProject()) && !iContainer.getName().startsWith(".");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean projectHasRequiredNatures(IProject iProject) throws CoreException {
        if (this.requiredNatures != null) {
            int n = 0;
            while (n < this.requiredNatures.length) {
                if (!iProject.hasNature(this.requiredNatures[n])) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }
}

