/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.datatools.sqltools.core.DBHelper;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IDatabaseSetting;
import org.eclipse.datatools.sqltools.core.ISqlDataValidator;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.core.services.ConnectionService;
import org.eclipse.datatools.sqltools.core.services.SQLDataService;
import org.eclipse.datatools.sqltools.core.services.SQLEditorService;
import org.eclipse.datatools.sqltools.core.services.SQLService;
import org.eclipse.datatools.sqltools.editor.core.connection.IConnectionInitializer;
import org.eclipse.datatools.sqltools.editor.template.GenericSQLContextType;
import org.eclipse.datatools.sqltools.internal.core.SQLDevToolsConfigRegistry;
import org.eclipse.datatools.sqltools.internal.core.SQLDevToolsConfigRegistryImpl;
import org.eclipse.datatools.sqltools.plan.IPlanOption;
import org.eclipse.datatools.sqltools.plan.IPlanService;
import org.eclipse.datatools.sqltools.sql.ISQLSyntax;
import org.eclipse.datatools.sqltools.sql.parser.SQLParser;

public class SQLToolsFacade {
    private static SQLToolsFacade _instance = new SQLToolsFacade();

    private SQLToolsFacade() {
    }

    public static SQLToolsFacade getInstance() {
        return _instance;
    }

    private static SQLDevToolsConfigRegistry getRegistry() {
        return EditorCorePlugin.getDatabaseFactoryRegistry();
    }

    public static Collection getConfigurations() {
        Collection c = SQLToolsFacade.getRegistry().getConfigurations();
        return c;
    }

    public static Collection getSupportedDBDefinitionNames() {
        Collection c = SQLToolsFacade.getRegistry().getConfigurations();
        ArrayList<String> names = new ArrayList<String>();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            SQLDevToolsConfiguration factory = (SQLDevToolsConfiguration)iter.next();
            String vendor = factory.getDatabaseVendorDefinitionId().getProductName();
            String version = factory.getDatabaseVendorDefinitionId().getVersion();
            names.add(vendor + "_" + version);
        }
        return names;
    }

    public static SQLDevToolsConfiguration getConfigurationByDBDefName(String dbDefName) {
        return SQLToolsFacade.getConfigurationByVendorIdentifier(new DatabaseVendorDefinitionId(dbDefName));
    }

    public static SQLDevToolsConfiguration getConfigurationByVendorIdentifier(DatabaseVendorDefinitionId vendorId) {
        return SQLToolsFacade.getConfiguration(null, vendorId);
    }

    public static SQLDevToolsConfiguration getConfigurationByProfileName(String profileName) {
        return SQLToolsFacade.getConfigurationByVendorIdentifier(ProfileUtil.getDatabaseVendorDefinitionId(profileName));
    }

    public static SQLDevToolsConfiguration getConfiguration(DatabaseIdentifier databaseIdentifier, DatabaseVendorDefinitionId vendorId) {
        SQLDevToolsConfiguration f = null;
        if (databaseIdentifier != null) {
            f = SQLToolsFacade.getConfigurationByProfileName(databaseIdentifier.getProfileName());
        }
        if (f == null && vendorId != null) {
            vendorId = SQLToolsFacade.getCanonicalDatabaseVendorDefinitionId(vendorId);
            f = SQLToolsFacade.getRegistry().getConfigurationByVendorIdentifier(vendorId);
        }
        if (f == null) {
            f = SQLToolsFacade.getDefaultConfiguration();
        }
        return f;
    }

    public static DatabaseVendorDefinitionId getCanonicalDatabaseVendorDefinitionId(DatabaseVendorDefinitionId vendorId) {
        Collection versions;
        SQLDevToolsConfiguration f = SQLToolsFacade.getRegistry().getConfigurationByVendorIdentifier(vendorId);
        if (f == null) {
            vendorId = SQLToolsFacade.recognize(vendorId.getProductName(), vendorId.getVersion());
            f = SQLToolsFacade.getRegistry().getConfigurationByVendorIdentifier(vendorId);
        }
        if (f == null && (versions = SQLToolsFacade.getRegistry().getVersions(vendorId.getProductName())) != null) {
            String version = "0";
            Iterator iter = versions.iterator();
            while (iter.hasNext()) {
                String v = (String)iter.next();
                if (v.compareTo(version) < 0) continue;
                version = v;
            }
            vendorId = new DatabaseVendorDefinitionId(vendorId.getProductName(), version);
            f = SQLToolsFacade.getRegistry().getConfigurationByVendorIdentifier(vendorId);
        }
        return vendorId;
    }

    public static SQLDevToolsConfiguration getDefaultConfiguration() {
        SQLDevToolsConfiguration defaultConfiguration = SQLDevToolsConfigRegistryImpl.getDefaultConfiguration();
        if (defaultConfiguration == null) {
            defaultConfiguration = SQLDevToolsConfiguration.getDefaultInstance();
        }
        return defaultConfiguration;
    }

    public static DatabaseVendorDefinitionId getDefaultDatabaseVendorDefinitionId() {
        return SQLToolsFacade.getDefaultConfiguration().getDatabaseVendorDefinitionId();
    }

    public static DatabaseVendorDefinitionId getNonSpecificDatabaseVendorDefinitionId() {
        return SQLDevToolsConfiguration.getDefaultInstance().getDatabaseVendorDefinitionId();
    }

    public static DatabaseVendorDefinitionId recognize(String product, String version) {
        DatabaseVendorDefinitionId defaultId = SQLToolsFacade.getDefaultConfiguration().getDatabaseVendorDefinitionId();
        Collection configs = SQLToolsFacade.getConfigurations();
        Iterator iter = configs.iterator();
        while (iter.hasNext()) {
            SQLDevToolsConfiguration conf = (SQLDevToolsConfiguration)iter.next();
            if (!conf.recognize(product, version) || conf.getDatabaseVendorDefinitionId().equals(defaultId)) continue;
            return conf.getDatabaseVendorDefinitionId();
        }
        return defaultId;
    }

    public static int getConnectionId(DatabaseIdentifier databaseIdentifier, Connection conn) {
        if (databaseIdentifier == null || conn == null) {
            return 0;
        }
        try {
            if (conn.isClosed()) {
                return 0;
            }
        }
        catch (SQLException e) {
            EditorCorePlugin.getDefault().log(e);
        }
        ConnectionService service = SQLToolsFacade.getConnectionService(databaseIdentifier);
        return service.getConnectionId(databaseIdentifier, conn);
    }

    public static ConnectionService getConnectionService(DatabaseIdentifier databaseIdentifier) {
        ConnectionService service = SQLToolsFacade.getConfiguration(null, databaseIdentifier).getConnectionService();
        return service;
    }

    public static Runnable getConnectionKiller(DatabaseIdentifier databaseIdentifier, Connection conn) {
        ConnectionService service = SQLToolsFacade.getConnectionService(databaseIdentifier);
        if (service != null) {
            return service.getConnectionKiller(databaseIdentifier, conn);
        }
        return null;
    }

    public static IDatabaseSetting getDatabaseSetting(DatabaseIdentifier databaseIdentifier) {
        SQLDevToolsConfiguration f = SQLToolsFacade.getConfiguration(null, databaseIdentifier);
        return f.getDatabaseSetting(databaseIdentifier);
    }

    public static IConnectionInitializer getConnectionInitializer(DatabaseIdentifier databaseIdentifier) {
        ConnectionService service = SQLToolsFacade.getConnectionService(databaseIdentifier);
        if (service != null) {
            return service.getConnectionInitializer();
        }
        return null;
    }

    public static DBHelper getDBHelper(DatabaseIdentifier databaseIdentifier, String dbType) {
        SQLDevToolsConfiguration f = SQLToolsFacade.getConfiguration(dbType, databaseIdentifier);
        return f.getDBHelper();
    }

    public static DBHelper getDBHelper(DatabaseIdentifier databaseIdentifier) {
        return SQLToolsFacade.getDBHelper(databaseIdentifier, null);
    }

    public static DBHelper getDBHelper(String dbType) {
        return SQLToolsFacade.getDBHelper(null, dbType);
    }

    public static SQLDataService getSQLDataService(DatabaseIdentifier databaseIdentifier, String dbType) {
        SQLDevToolsConfiguration f = SQLToolsFacade.getConfiguration(dbType, databaseIdentifier);
        return f.getSQLDataService();
    }

    public static ISqlDataValidator getSQLDataValidator(DatabaseIdentifier databaseIdentifier) {
        SQLDataService s = SQLToolsFacade.getSQLDataService(databaseIdentifier, null);
        if (s != null) {
            return s.getSQLDataValidator(databaseIdentifier);
        }
        return null;
    }

    public static SQLService getSQLService(DatabaseIdentifier databaseIdentifier, String dbType) {
        SQLDevToolsConfiguration f = SQLToolsFacade.getConfiguration(dbType, databaseIdentifier);
        return f.getSQLService();
    }

    public static ISQLSyntax getSQLSyntax(String dbType) {
        SQLService s = SQLToolsFacade.getSQLService(null, dbType);
        if (s != null) {
            return s.getSQLSyntax();
        }
        return null;
    }

    public static SQLParser getSQLParser(String profileName, String dbType) {
        SQLService s = SQLToolsFacade.getSQLService(new DatabaseIdentifier(profileName), dbType);
        if (s != null) {
            return s.getSQLParser();
        }
        return null;
    }

    public static GenericSQLContextType getSQLContextType(String dbType) {
        SQLService service = SQLToolsFacade.getSQLService(null, dbType);
        if (service != null) {
            return service.getSQLContextType();
        }
        return null;
    }

    public static SQLEditorService getSQLEditorService(DatabaseIdentifier databaseIdentifier, String dbType) {
        SQLDevToolsConfiguration f = SQLToolsFacade.getConfiguration(dbType, databaseIdentifier);
        return f.getSQLEditorService();
    }

    public static IPlanService getPlanService(DatabaseIdentifier databaseIdentifier) {
        SQLDevToolsConfiguration f = SQLToolsFacade.getConfiguration(null, databaseIdentifier);
        return f.getPlanService();
    }

    public static int[] getDBTypes() {
        Collection c = SQLToolsFacade.getRegistry().getConfigurations();
        int size = c.size();
        String[] types = c.toArray(new String[size]);
        int[] ts = new int[size];
        for (int i = 0; i < size; ++i) {
            ts[i] = Integer.parseInt(types[i]);
        }
        return ts;
    }

    public static Collection getSQLContextTypes() {
        Collection c = SQLToolsFacade.getRegistry().getConfigurations();
        int size = c.size();
        SQLDevToolsConfiguration[] fs = c.toArray(new SQLDevToolsConfiguration[size]);
        ArrayList<GenericSQLContextType> ctxTypes = new ArrayList<GenericSQLContextType>();
        for (int i = 0; i < size; ++i) {
            ctxTypes.add(fs[i].getSQLService().getSQLContextType());
        }
        return ctxTypes;
    }

    public static Collection getPlanOptions() {
        Collection c = SQLToolsFacade.getRegistry().getConfigurations();
        int size = c.size();
        SQLDevToolsConfiguration[] fs = c.toArray(new SQLDevToolsConfiguration[size]);
        ArrayList<IPlanOption> planOps = new ArrayList<IPlanOption>();
        for (int i = 0; i < size; ++i) {
            planOps.add(fs[i].getPlanService().getPlanOption());
        }
        return planOps;
    }

    public static boolean showAction(String dbType, String actionId) {
        SQLDevToolsConfiguration f = null;
        f = SQLToolsFacade.getConfigurationByDBDefName(dbType);
        if (f != null) {
            return f.getActionService().supportsAction(actionId);
        }
        return false;
    }

    public static SQLDevToolsConfiguration getConfiguration(String dbType, DatabaseIdentifier databaseIdentifier) {
        if (dbType == null) {
            return SQLToolsFacade.getConfiguration(databaseIdentifier, null);
        }
        return SQLToolsFacade.getConfiguration(databaseIdentifier, new DatabaseVendorDefinitionId(dbType));
    }
}

